"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mobilehub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [mobilehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmobilehub.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mobilehub extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [mobilehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmobilehub.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'mobilehub';
        this.accessLevelList = {
            Write: [
                'CreateProject',
                'CreateServiceRole',
                'DeleteProject',
                'DeleteProjectSnapshot',
                'DeployToStage',
                'ImportProject',
                'InstallBundle',
                'SynchronizeProject',
                'UpdateProject'
            ],
            Read: [
                'DescribeBundle',
                'ExportBundle',
                'ExportProject',
                'GenerateProjectParameters',
                'GetProject',
                'GetProjectSnapshot',
                'ValidateProject',
                'VerifyServiceRole'
            ],
            List: [
                'ListAvailableConnectors',
                'ListAvailableFeatures',
                'ListAvailableRegions',
                'ListBundles',
                'ListProjectSnapshots',
                'ListProjects'
            ]
        };
    }
    /**
     * Create a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Enable AWS Mobile Hub in the account by creating the required service role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toCreateServiceRole() {
        return this.to('CreateServiceRole');
    }
    /**
     * Delete the specified project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Delete a saved snapshot of project configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toDeleteProjectSnapshot() {
        return this.to('DeleteProjectSnapshot');
    }
    /**
     * Deploy changes to the specified stage
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toDeployToStage() {
        return this.to('DeployToStage');
    }
    /**
     * Describe the download bundle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toDescribeBundle() {
        return this.to('DescribeBundle');
    }
    /**
     * Export the download bundle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toExportBundle() {
        return this.to('ExportBundle');
    }
    /**
     * Export the project configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toExportProject() {
        return this.to('ExportProject');
    }
    /**
     * Generate project parameters required for code generation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toGenerateProjectParameters() {
        return this.to('GenerateProjectParameters');
    }
    /**
     * Get project configuration and resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Fetch the previously exported project configuration snapshot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toGetProjectSnapshot() {
        return this.to('GetProjectSnapshot');
    }
    /**
     * Create a new project from the previously exported project configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toImportProject() {
        return this.to('ImportProject');
    }
    /**
     * Install a bundle in the project deployments S3 bucket
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toInstallBundle() {
        return this.to('InstallBundle');
    }
    /**
     * List the available SaaS (Software as a Service) connectors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toListAvailableConnectors() {
        return this.to('ListAvailableConnectors');
    }
    /**
     * List available features
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toListAvailableFeatures() {
        return this.to('ListAvailableFeatures');
    }
    /**
     * List available regions for projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toListAvailableRegions() {
        return this.to('ListAvailableRegions');
    }
    /**
     * List the available download bundles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toListBundles() {
        return this.to('ListBundles');
    }
    /**
     * List saved snapshots of project configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toListProjectSnapshots() {
        return this.to('ListProjectSnapshots');
    }
    /**
     * List projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Synchronize state of resources into project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toSynchronizeProject() {
        return this.to('SynchronizeProject');
    }
    /**
     * Update project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toUpdateProject() {
        return this.to('UpdateProject');
    }
    /**
     * Validate a mobile hub project.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toValidateProject() {
        return this.to('ValidateProject');
    }
    /**
     * Verify AWS Mobile Hub is enabled in the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/managed-policies.html
     */
    toVerifyServiceRole() {
        return this.to('VerifyServiceRole');
    }
    /**
     * Adds a resource of type project to the statement
     *
     * https://docs.aws.amazon.com/mobile-hub/latest/developerguide/reference-mobile-hub-iam-managed-policies.html
     *
     * @param projectId - Identifier for the projectId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProject(projectId, account, region, partition) {
        return this.on(`arn:${partition || Mobilehub.defaultPartition}:mobilehub:${region || '*'}:${account || '*'}:project/${projectId}`);
    }
}
exports.Mobilehub = Mobilehub;
_a = JSII_RTTI_SYMBOL_1;
Mobilehub[_a] = { fqn: "iam-floyd.Mobilehub", version: "0.469.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9iaWxlaHViLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibW9iaWxlaHViLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQTRDO0FBRTVDOzs7O0dBSUc7QUFDSCxNQUFhLFNBQVUsU0FBUSx3QkFBZTtJQUc1Qzs7OztPQUlHO0lBQ0gsWUFBWSxHQUFZO1FBQ3RCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQVJOLGtCQUFhLEdBQUcsV0FBVyxDQUFDO1FBd1F6QixvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsZUFBZTtnQkFDZixtQkFBbUI7Z0JBQ25CLGVBQWU7Z0JBQ2YsdUJBQXVCO2dCQUN2QixlQUFlO2dCQUNmLGVBQWU7Z0JBQ2YsZUFBZTtnQkFDZixvQkFBb0I7Z0JBQ3BCLGVBQWU7YUFDaEI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osZ0JBQWdCO2dCQUNoQixjQUFjO2dCQUNkLGVBQWU7Z0JBQ2YsMkJBQTJCO2dCQUMzQixZQUFZO2dCQUNaLG9CQUFvQjtnQkFDcEIsaUJBQWlCO2dCQUNqQixtQkFBbUI7YUFDcEI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0oseUJBQXlCO2dCQUN6Qix1QkFBdUI7Z0JBQ3ZCLHNCQUFzQjtnQkFDdEIsYUFBYTtnQkFDYixzQkFBc0I7Z0JBQ3RCLGNBQWM7YUFDZjtTQUNGLENBQUM7SUE3UkYsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBa0NEOzs7Ozs7Ozs7T0FTRztJQUNJLFNBQVMsQ0FBQyxTQUFpQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3ZGLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxTQUFTLENBQUMsZ0JBQWlCLGNBQWUsTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxZQUFhLFNBQVUsRUFBRSxDQUFDLENBQUM7SUFDN0ksQ0FBQzs7QUFyVEgsOEJBc1RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9zaGFyZWQnO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbbW9iaWxlaHViXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3Ntb2JpbGVodWIuaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBNb2JpbGVodWIgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdtb2JpbGVodWInO1xuXG4gIC8qKlxuICAgKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW21vYmlsZWh1Yl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzbW9iaWxlaHViLmh0bWwpLlxuICAgKlxuICAgKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlIGEgcHJvamVjdFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVByb2plY3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVByb2plY3QnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBFbmFibGUgQVdTIE1vYmlsZSBIdWIgaW4gdGhlIGFjY291bnQgYnkgY3JlYXRpbmcgdGhlIHJlcXVpcmVkIHNlcnZpY2Ugcm9sZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNlcnZpY2VSb2xlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVTZXJ2aWNlUm9sZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZSB0aGUgc3BlY2lmaWVkIHByb2plY3RcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVQcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVQcm9qZWN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlIGEgc2F2ZWQgc25hcHNob3Qgb2YgcHJvamVjdCBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL21vYmlsZS1odWIvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL21hbmFnZWQtcG9saWNpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUHJvamVjdFNuYXBzaG90KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVQcm9qZWN0U25hcHNob3QnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXBsb3kgY2hhbmdlcyB0byB0aGUgc3BlY2lmaWVkIHN0YWdlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL21vYmlsZS1odWIvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL21hbmFnZWQtcG9saWNpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVwbG95VG9TdGFnZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVwbG95VG9TdGFnZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlc2NyaWJlIHRoZSBkb3dubG9hZCBidW5kbGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQnVuZGxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUJ1bmRsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEV4cG9ydCB0aGUgZG93bmxvYWQgYnVuZGxlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9FeHBvcnRCdW5kbGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0V4cG9ydEJ1bmRsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEV4cG9ydCB0aGUgcHJvamVjdCBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9FeHBvcnRQcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdFeHBvcnRQcm9qZWN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR2VuZXJhdGUgcHJvamVjdCBwYXJhbWV0ZXJzIHJlcXVpcmVkIGZvciBjb2RlIGdlbmVyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dlbmVyYXRlUHJvamVjdFBhcmFtZXRlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dlbmVyYXRlUHJvamVjdFBhcmFtZXRlcnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXQgcHJvamVjdCBjb25maWd1cmF0aW9uIGFuZCByZXNvdXJjZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFByb2plY3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFByb2plY3QnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGZXRjaCB0aGUgcHJldmlvdXNseSBleHBvcnRlZCBwcm9qZWN0IGNvbmZpZ3VyYXRpb24gc25hcHNob3RcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFByb2plY3RTbmFwc2hvdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0UHJvamVjdFNuYXBzaG90Jyk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlIGEgbmV3IHByb2plY3QgZnJvbSB0aGUgcHJldmlvdXNseSBleHBvcnRlZCBwcm9qZWN0IGNvbmZpZ3VyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9JbXBvcnRQcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdJbXBvcnRQcm9qZWN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogSW5zdGFsbCBhIGJ1bmRsZSBpbiB0aGUgcHJvamVjdCBkZXBsb3ltZW50cyBTMyBidWNrZXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9JbnN0YWxsQnVuZGxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdJbnN0YWxsQnVuZGxlJyk7XG4gIH1cblxuICAvKipcbiAgICogTGlzdCB0aGUgYXZhaWxhYmxlIFNhYVMgKFNvZnR3YXJlIGFzIGEgU2VydmljZSkgY29ubmVjdG9yc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL21vYmlsZS1odWIvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL21hbmFnZWQtcG9saWNpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEF2YWlsYWJsZUNvbm5lY3RvcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBdmFpbGFibGVDb25uZWN0b3JzJyk7XG4gIH1cblxuICAvKipcbiAgICogTGlzdCBhdmFpbGFibGUgZmVhdHVyZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBdmFpbGFibGVGZWF0dXJlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEF2YWlsYWJsZUZlYXR1cmVzJyk7XG4gIH1cblxuICAvKipcbiAgICogTGlzdCBhdmFpbGFibGUgcmVnaW9ucyBmb3IgcHJvamVjdHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBdmFpbGFibGVSZWdpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0QXZhaWxhYmxlUmVnaW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3QgdGhlIGF2YWlsYWJsZSBkb3dubG9hZCBidW5kbGVzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0QnVuZGxlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEJ1bmRsZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0IHNhdmVkIHNuYXBzaG90cyBvZiBwcm9qZWN0IGNvbmZpZ3VyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQcm9qZWN0U25hcHNob3RzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UHJvamVjdFNuYXBzaG90cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3QgcHJvamVjdHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQcm9qZWN0cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFByb2plY3RzJyk7XG4gIH1cblxuICAvKipcbiAgICogU3luY2hyb25pemUgc3RhdGUgb2YgcmVzb3VyY2VzIGludG8gcHJvamVjdFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tYW5hZ2VkLXBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N5bmNocm9uaXplUHJvamVjdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3luY2hyb25pemVQcm9qZWN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlIHByb2plY3RcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVQcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVQcm9qZWN0Jyk7XG4gIH1cblxuICAvKipcbiAgICogVmFsaWRhdGUgYSBtb2JpbGUgaHViIHByb2plY3QuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9WYWxpZGF0ZVByb2plY3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1ZhbGlkYXRlUHJvamVjdCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFZlcmlmeSBBV1MgTW9iaWxlIEh1YiBpcyBlbmFibGVkIGluIHRoZSBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbW9iaWxlLWh1Yi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9WZXJpZnlTZXJ2aWNlUm9sZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVmVyaWZ5U2VydmljZVJvbGUnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0NyZWF0ZVByb2plY3QnLFxuICAgICAgJ0NyZWF0ZVNlcnZpY2VSb2xlJyxcbiAgICAgICdEZWxldGVQcm9qZWN0JyxcbiAgICAgICdEZWxldGVQcm9qZWN0U25hcHNob3QnLFxuICAgICAgJ0RlcGxveVRvU3RhZ2UnLFxuICAgICAgJ0ltcG9ydFByb2plY3QnLFxuICAgICAgJ0luc3RhbGxCdW5kbGUnLFxuICAgICAgJ1N5bmNocm9uaXplUHJvamVjdCcsXG4gICAgICAnVXBkYXRlUHJvamVjdCdcbiAgICBdLFxuICAgIFJlYWQ6IFtcbiAgICAgICdEZXNjcmliZUJ1bmRsZScsXG4gICAgICAnRXhwb3J0QnVuZGxlJyxcbiAgICAgICdFeHBvcnRQcm9qZWN0JyxcbiAgICAgICdHZW5lcmF0ZVByb2plY3RQYXJhbWV0ZXJzJyxcbiAgICAgICdHZXRQcm9qZWN0JyxcbiAgICAgICdHZXRQcm9qZWN0U25hcHNob3QnLFxuICAgICAgJ1ZhbGlkYXRlUHJvamVjdCcsXG4gICAgICAnVmVyaWZ5U2VydmljZVJvbGUnXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnTGlzdEF2YWlsYWJsZUNvbm5lY3RvcnMnLFxuICAgICAgJ0xpc3RBdmFpbGFibGVGZWF0dXJlcycsXG4gICAgICAnTGlzdEF2YWlsYWJsZVJlZ2lvbnMnLFxuICAgICAgJ0xpc3RCdW5kbGVzJyxcbiAgICAgICdMaXN0UHJvamVjdFNuYXBzaG90cycsXG4gICAgICAnTGlzdFByb2plY3RzJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgcHJvamVjdCB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tb2JpbGUtaHViL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9yZWZlcmVuY2UtbW9iaWxlLWh1Yi1pYW0tbWFuYWdlZC1wb2xpY2llcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBwcm9qZWN0SWQgLSBJZGVudGlmaWVyIGZvciB0aGUgcHJvamVjdElkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqL1xuICBwdWJsaWMgb25Qcm9qZWN0KHByb2plY3RJZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IE1vYmlsZWh1Yi5kZWZhdWx0UGFydGl0aW9uIH06bW9iaWxlaHViOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OnByb2plY3QvJHsgcHJvamVjdElkIH1gKTtcbiAgfVxufVxuIl19