"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sms = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [sms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservermigrationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Sms extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [sms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservermigrationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'sms';
        this.accessLevelList = {
            Write: [
                'CreateApp',
                'CreateReplicationJob',
                'DeleteApp',
                'DeleteAppLaunchConfiguration',
                'DeleteAppReplicationConfiguration',
                'DeleteAppValidationConfiguration',
                'DeleteReplicationJob',
                'DeleteServerCatalog',
                'DisassociateConnector',
                'GenerateChangeSet',
                'GenerateTemplate',
                'ImportAppCatalog',
                'ImportServerCatalog',
                'LaunchApp',
                'NotifyAppValidationOutput',
                'PutAppLaunchConfiguration',
                'PutAppReplicationConfiguration',
                'PutAppValidationConfiguration',
                'SendMessage',
                'StartAppReplication',
                'StartOnDemandAppReplication',
                'StartOnDemandReplicationRun',
                'StopAppReplication',
                'TerminateApp',
                'UpdateApp',
                'UpdateReplicationJob'
            ],
            Read: [
                'GetApp',
                'GetAppLaunchConfiguration',
                'GetAppReplicationConfiguration',
                'GetAppValidationConfiguration',
                'GetAppValidationOutput',
                'GetConnectors',
                'GetMessages',
                'GetReplicationJobs',
                'GetReplicationRuns',
                'GetServers'
            ],
            List: [
                'ListApps'
            ]
        };
    }
    /**
     * Grants permission to create an application configuration to migrate on-premise application onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateApp.html
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * Grants permission to create a job to migrate on-premise server onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateReplicationJob.html
     */
    toCreateReplicationJob() {
        return this.to('CreateReplicationJob');
    }
    /**
     * Grants permission to delete an existing application configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Grants permission to delete launch configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppLaunchConfiguration.html
     */
    toDeleteAppLaunchConfiguration() {
        return this.to('DeleteAppLaunchConfiguration');
    }
    /**
     * Grants permission to delete replication configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppReplicationConfiguration.html
     */
    toDeleteAppReplicationConfiguration() {
        return this.to('DeleteAppReplicationConfiguration');
    }
    /**
     * Grants permission to delete validation configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppValidationConfiguration.html
     */
    toDeleteAppValidationConfiguration() {
        return this.to('DeleteAppValidationConfiguration');
    }
    /**
     * Grants permission to delete an existing job to migrate on-premise server onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteReplicationJob.html
     */
    toDeleteReplicationJob() {
        return this.to('DeleteReplicationJob');
    }
    /**
     * Grants permission to delete the complete list of on-premise servers gathered into AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteServerCatalog.html
     */
    toDeleteServerCatalog() {
        return this.to('DeleteServerCatalog');
    }
    /**
     * Grants permission to disassociate a connector that has been associated
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DisassociateConnector.html
     */
    toDisassociateConnector() {
        return this.to('DisassociateConnector');
    }
    /**
     * Grants permission to generate a changeSet for the CloudFormation stack of an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateChangeSet.html
     */
    toGenerateChangeSet() {
        return this.to('GenerateChangeSet');
    }
    /**
     * Grants permission to generate a CloudFormation template for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateTemplate.html
     */
    toGenerateTemplate() {
        return this.to('GenerateTemplate');
    }
    /**
     * Grants permission to get the configuration and statuses for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetApp.html
     */
    toGetApp() {
        return this.to('GetApp');
    }
    /**
     * Grants permission to get launch configuration for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppLaunchConfiguration.html
     */
    toGetAppLaunchConfiguration() {
        return this.to('GetAppLaunchConfiguration');
    }
    /**
     * Grants permission to get replication configuration for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppReplicationConfiguration.html
     */
    toGetAppReplicationConfiguration() {
        return this.to('GetAppReplicationConfiguration');
    }
    /**
     * Grants permission to get validation configuration for an existing application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationConfiguration.html
     */
    toGetAppValidationConfiguration() {
        return this.to('GetAppValidationConfiguration');
    }
    /**
     * Grants permission to get notification sent from application validation script.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationOutput.html
     */
    toGetAppValidationOutput() {
        return this.to('GetAppValidationOutput');
    }
    /**
     * Grants permission to get all connectors that have been associated
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetConnectors.html
     */
    toGetConnectors() {
        return this.to('GetConnectors');
    }
    /**
     * Grants permission to gets messages from AWS Server Migration Service to Server Migration Connector
     *
     * Access Level: Read
     */
    toGetMessages() {
        return this.to('GetMessages');
    }
    /**
     * Grants permission to get all existing jobs to migrate on-premise servers onto AWS
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationJobs.html
     */
    toGetReplicationJobs() {
        return this.to('GetReplicationJobs');
    }
    /**
     * Grants permission to get all runs for an existing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationRuns.html
     */
    toGetReplicationRuns() {
        return this.to('GetReplicationRuns');
    }
    /**
     * Grants permission to get all servers that have been imported
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetServers.html
     */
    toGetServers() {
        return this.to('GetServers');
    }
    /**
     * Grants permission to import application catalog from AWS Application Discovery Service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportAppCatalog.html
     */
    toImportAppCatalog() {
        return this.to('ImportAppCatalog');
    }
    /**
     * Grants permission to gather a complete list of on-premise servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportServerCatalog.html
     */
    toImportServerCatalog() {
        return this.to('ImportServerCatalog');
    }
    /**
     * Grants permission to create and launch a CloudFormation stack for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_LaunchApp.html
     */
    toLaunchApp() {
        return this.to('LaunchApp');
    }
    /**
     * Grants permission to get a list of summaries for existing applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ListAppss.html
     */
    toListApps() {
        return this.to('ListApps');
    }
    /**
     * Grants permission to send notification for application validation script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_NotifyAppValidationOutput.html
     */
    toNotifyAppValidationOutput() {
        return this.to('NotifyAppValidationOutput');
    }
    /**
     * Grants permission to create or update launch configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppLaunchConfiguration.html
     */
    toPutAppLaunchConfiguration() {
        return this.to('PutAppLaunchConfiguration');
    }
    /**
     * Grants permission to create or update replication configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppReplicationConfiguration.html
     */
    toPutAppReplicationConfiguration() {
        return this.to('PutAppReplicationConfiguration');
    }
    /**
     * Grants permission to put validation configuration for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppValidationConfiguration.html
     */
    toPutAppValidationConfiguration() {
        return this.to('PutAppValidationConfiguration');
    }
    /**
     * Grants permission to send message from Server Migration Connector to AWS Server Migration Service
     *
     * Access Level: Write
     */
    toSendMessage() {
        return this.to('SendMessage');
    }
    /**
     * Grants permission to create and start replication jobs for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartAppReplication.html
     */
    toStartAppReplication() {
        return this.to('StartAppReplication');
    }
    /**
     * Grants permission to start a replication run for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandAppReplication.html
     */
    toStartOnDemandAppReplication() {
        return this.to('StartOnDemandAppReplication');
    }
    /**
     * Grants permission to start a replication run for an existing replication job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandReplicationRun.html
     */
    toStartOnDemandReplicationRun() {
        return this.to('StartOnDemandReplicationRun');
    }
    /**
     * Grants permission to stop and delete replication jobs for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StopAppReplication.html
     */
    toStopAppReplication() {
        return this.to('StopAppReplication');
    }
    /**
     * Grants permission to terminate the CloudFormation stack for an existing application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_TerminateApp.html
     */
    toTerminateApp() {
        return this.to('TerminateApp');
    }
    /**
     * Grants permission to update an existing application configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateApp.html
     */
    toUpdateApp() {
        return this.to('UpdateApp');
    }
    /**
     * Grants permission to update an existing job to migrate on-premise server onto AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateReplicationJob.html
     */
    toUpdateReplicationJob() {
        return this.to('UpdateReplicationJob');
    }
}
exports.Sms = Sms;
_a = JSII_RTTI_SYMBOL_1;
Sms[_a] = { fqn: "iam-floyd.Sms", version: "0.469.0" };
//# sourceMappingURL=data:application/json;base64,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