import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [wickr](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswickr.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Wickr extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [wickr](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswickr.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create and manage Wickr networks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toCreateAdminSession(): this;
    /**
     * Grants permission to view Wickr networks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toListNetworks(): this;
    protected accessLevelList: AccessLevelList;
}
