# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['moffman']

package_data = \
{'': ['*']}

install_requires = \
['APScheduler>=3.9.1,<4.0.0',
 'aiogoogle>=4.2.0,<5.0.0',
 'aiohttp>=3.7.4,<4.0.0',
 'arrow>=1.2.2,<2.0.0',
 'click>=8.0.1,<9.0.0',
 'onacol>=0.3.0,<0.4.0',
 'sockjs>=0.11.0,<0.12.0']

entry_points = \
{'console_scripts': ['moffman = moffman.cli:main']}

setup_kwargs = {
    'name': 'moffman',
    'version': '0.2.4',
    'description': 'Microservice for managing team attendance in multiple offices.',
    'long_description': '==============================\nmoffman (Multi-Office Manager)\n==============================\n\nMicroservice for managing team attendance in multiple offices.\n\nUses Google account as a data and configuration backing store.\n\nFeatures\n--------\n\n* Provides REST API for registration and approval of planned attendance.\n* Uses Google account as a data and configuration backing store.\n* Can use `Byroapi`_ for issuing attendance approval forms.\n* Runtime configurations via Google Spreadsheets.\n\n\nHow does it work\n----------------\n\nMoffman basically manages a shared Google calendar and handles the "approvals".\nThe calendar stores day-events that marks persons who intend to attend given\noffice.\nThere are two ways how to add events to the calendar:\n\n* **REST API way** - this way is for request that come from another office\n  automation workflow. It also allows approving events that has been already\n  added.\n* **Manual way** - this way is for members who (for any reason) cannot\n  participate in another automation workflows. They can add events directly into\n  the shared calendar. Only explicitly specified users (through config) can do\n  this.\n\nThe output of this system is the shared Google calendar(s) (there can be several\noffices each with one calendar).\n\nIn case the events are added/approved using REST API way, there are no further\nactions than updating the Google calendar itself. It is assumed that the same\noffice automation workflow that controls moffman via the REST API would take\ncare of any additional steps such as approval form creation etc.\n\nIn case the events are added manually, moffman provides possibility to\nautomatically approve the added event and issue an approval form with\n`Byroapi`_.\n\n\nInstallation:\n-------------\n\n.. code-block:: console\n\n    $ pip install moffman\n\nUsage\n-----\n\n1. Having a backing Google account\n++++++++++++++++++++++++++++++++++\n\nMoffman needs API access to an existing Google account, to use it\'s calendar and\nspreadsheet data.\nOn the Google Account that is chosen for this function, following steps must be\ntaken:\n\n1. `Enabling and authorizing Google Calendar API. <https://developers.google.com/calendar/api/guides/auth>`_\n2. `Enabling and authorizing Google Spreadsheets API. <https://developers.google.com/sheets/api/guides/authorizing>`_\n3. `Creating service account. <https://cloud.google.com/docs/authentication/production>`_\n\n2. Configuration\n++++++++++++++++\n\nMoffman uses `Onacol`_ configuration, so any configuration parameter described\nbelow can be configured either in the YAML file or through CLI option\nor environment variable.\n\nThis documentation only describes the YAML configuration method.\n\nTo create a configuration file template, use following command::\n\n    $ byroapi --get-config-template your_config.yaml\n\nTypical example configuration with some template looks as follows:\n\n.. code-block:: yaml\n\n    general:\n        # Logging level [DEBUG, INFO, WARNING, ERROR, CRITICAL]\n        log_level: INFO\n        # Interval to check for manually added events.\n        manual_calendar_check_interval:  7200\n\n        # Path to a persistant storage file (for storing tokens etc.). Keep null not to use persistent storage.\n        storage_path: "moffman_store.dbm"\n\n    google_api:\n        # Path to the Google API credentials JSON file\n        service_account_key_path: "some-service-account-343435.json"\n\n    # External users that have access only to the Google Docs/Calendar.\n    manual_users:\n        # List of items in format {id: <user_email>, name: <user_name>}\n        user_list: []\n        google_config:\n            # Google Drive ID of the Google spreadsheet file\n            sheet_id: "1Id24zwRK41IDkdl34jpfx90tkY3bi4dGrl340nnldf9"\n\n            # Google sheet range notation, see https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/cells\n            range: "Manual users!A2:B"\n            # Min. interval between updates [seconds], null if automatic update is not necessary\n            update_interval: null\n\n    # Offices managed by this application\n    offices:\n        # List of items in format {name: <office name>, id: <Google calendar id>}\n        office_list: []\n        google_config: "1Id24zwRK41IDkdl9dfsdfstkY3bi4dG340nnldf9"\n\n    # Byroapi (https://github.com/calcite/byroapi) form-filler configuration\n    forms:\n        template: "Your_Template"\n        url: "http://your-byroapi-instance.com/api/v1/form"\n        date_format: "DD.MM.YYYY"\n        email:\n            from:\n                moffman-administrator@macme.com: "Moffman admin"\n            to: "form-recipient-email@acme.com"\n            cc:\n                moffman-administrator@macme.com: "Moffman admin"\n            subject: "Some office attendance - {user_name} ({date_from} - {date_to})"\n            contents: "Hey, here\'s the form regarding someone\'s office attendance ({user_name}: {date_from} - {date_to}).\\n\\nDěkuji předem za zpracování,\\n\\nJosef"\n\n    calendar:\n        # Event colors (defined as indexes to the Google calendar color palette)\n        colors:\n            # Color of approval-pending registration event.\n            unapproved:\n            # Color of approved registration event.\n            approved:\n\n        # Checking range for event lookup in the manual update. The values are relative to the time of update, and are defined as Arrow shift arguments (https://arrow.readthedocs.io/en/latest/#arrow.arrow.Arrow.shift)\n        checking_range:\n            min:\n                weeks: -1\n            max:\n                weeks: 2\n        date_format: "YYYY-MM-DD"\n        end_date_corrective:\n            days: -1\n\n    rest_api:  # Configuration of the REST API endpoint\n        addr: 0.0.0.0\n        port: 8080\n\nas you can see, several configuration items include a ``google_config`` section.\nThe purpose of this section is to refer to a range in an defined\nGoogle Spreadsheet, that contains configuration in expected format.o\n\nThis is the way how to dynamically update some configuration details without\nrestarting the service.\n\nConfiguration data from Google Spreadsheet are downloaded to the moffman\nconfiguration in two ways:\n\n1. Using a fixed-time interval specified in\n``google_config:min_update_interval`` for each section.\n2. Manually initiating updat via REST API - by doing GET on\n``/api/v1/config_update``.\n\n3. Usage\n++++++++\n\nMoffman provides a simple CLI. To run as a server::\n\n    $ moffman --config your_config.yaml\n\nIt\'s also possible to convey the configuration via ENV variables (see `Onacol`_).\n\nMoffmann runs as a background service, receiving data on it\'s REST intreface,\nand updating/manipulating data on Google calendar.\n\nFollowing API endpoints are currently provided:\n\n* ``POST /api/v1/reservations`` - accepts JSON reservations in following form:\n\n.. code-block:: json\n\n    {\n\t"user": {\n        "name": "Some User",\n        "email": "user@nacme.com"\n        },\n    "approved": true,\n    "start": "2022-06-28",\n    "end": "2022-06-29",\n    "request_dt": "11:38:00 2020/06/25",\n    "office_id": "your-office"\n    }\n\n* ``GET /api/v1/config_update`` - empty GET to force configuration reload from\n  Google Spreadsheet.\n\n\n.. _Onacol: https://github.com/calcite/onacol\n.. _Byroapi: https://github.com/calcite/byroapi\n',
    'author': 'Josef Nevrly',
    'author_email': 'josef.nevrly@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/JNevrly/moffman',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.0,<4.0.0',
}


setup(**setup_kwargs)
