"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Archive = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const events_generated_1 = require("./events.generated");
const util_1 = require("./util");
/**
 * Define an EventBridge Archive
 *
 * @resource AWS::Events::Archive
 */
class Archive extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, { physicalName: props.archiveName });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_events_ArchiveProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        let archive = new events_generated_1.CfnArchive(this, 'Archive', {
            sourceArn: props.sourceEventBus.eventBusArn,
            description: props.description,
            eventPattern: util_1.renderEventPattern(props.eventPattern),
            retentionDays: ((_b = props.retention) === null || _b === void 0 ? void 0 : _b.toDays({ integral: true })) || 0,
            archiveName: this.physicalName,
        });
        this.archiveArn = archive.attrArn;
        this.archiveName = archive.attrArchiveName;
    }
}
exports.Archive = Archive;
_a = JSII_RTTI_SYMBOL_1;
Archive[_a] = { fqn: "@aws-cdk/aws-events.Archive", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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