#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

/* Definition for CPU ID */
#define XPAR_CPU_ID 0U

/* Definitions for peripheral PS7_CORTEXA9_0 */
#define XPAR_PS7_CORTEXA9_0_CPU_CLK_FREQ_HZ 666000000


/******************************************************************/

/* Canonical definitions for peripheral PS7_CORTEXA9_0 */
#define XPAR_CPU_CORTEXA9_0_CPU_CLK_FREQ_HZ 666000000


/******************************************************************/

#include "xparameters_ps.h"

#define STDIN_BASEADDRESS 0xE0000000
#define STDOUT_BASEADDRESS 0xE0000000

/******************************************************************/

/* Definitions for driver AXIDMA */
#define XPAR_XAXIDMA_NUM_INSTANCES 2

/* Definitions for peripheral TRACE_ANALYZER_PI_AXI_DMA_0 */
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_DEVICE_ID 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_BASEADDR 0x80430000
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_HIGHADDR 0x8043FFFF
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_SG_INCLUDE_STSCNTRL_STRM 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_INCLUDE_MM2S_DRE 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_INCLUDE_S2MM_DRE 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_INCLUDE_MM2S 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_INCLUDE_S2MM 1
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_M_AXI_MM2S_DATA_WIDTH 32
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_M_AXI_S2MM_DATA_WIDTH 64
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_INCLUDE_SG 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_ENABLE_MULTI_CHANNEL 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_NUM_MM2S_CHANNELS 1
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_NUM_S2MM_CHANNELS 1
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_MM2S_BURST_SIZE 16
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_S2MM_BURST_SIZE 64
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_MICRO_DMA 0
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_ADDR_WIDTH 32


/* Definitions for peripheral TRACE_ANALYZER_PMODB_AXI_DMA_0 */
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_DEVICE_ID 1
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_BASEADDR 0x80420000
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_HIGHADDR 0x8042FFFF
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_SG_INCLUDE_STSCNTRL_STRM 0
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_INCLUDE_MM2S_DRE 0
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_INCLUDE_S2MM_DRE 0
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_INCLUDE_MM2S 0
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_INCLUDE_S2MM 1
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_M_AXI_MM2S_DATA_WIDTH 32
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_M_AXI_S2MM_DATA_WIDTH 32
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_INCLUDE_SG 0
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_ENABLE_MULTI_CHANNEL 0
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_NUM_MM2S_CHANNELS 1
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_NUM_S2MM_CHANNELS 1
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_MM2S_BURST_SIZE 16
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_S2MM_BURST_SIZE 64
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_MICRO_DMA 0
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_ADDR_WIDTH 32


/******************************************************************/

/* Canonical definitions for peripheral TRACE_ANALYZER_PI_AXI_DMA_0 */
#define XPAR_AXIDMA_0_DEVICE_ID XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_DEVICE_ID
#define XPAR_AXIDMA_0_BASEADDR 0x80430000
#define XPAR_AXIDMA_0_SG_INCLUDE_STSCNTRL_STRM 0
#define XPAR_AXIDMA_0_INCLUDE_MM2S 0
#define XPAR_AXIDMA_0_INCLUDE_MM2S_DRE 0
#define XPAR_AXIDMA_0_M_AXI_MM2S_DATA_WIDTH 32
#define XPAR_AXIDMA_0_INCLUDE_S2MM 1
#define XPAR_AXIDMA_0_INCLUDE_S2MM_DRE 0
#define XPAR_AXIDMA_0_M_AXI_S2MM_DATA_WIDTH 64
#define XPAR_AXIDMA_0_INCLUDE_SG 0
#define XPAR_AXIDMA_0_ENABLE_MULTI_CHANNEL 0
#define XPAR_AXIDMA_0_NUM_MM2S_CHANNELS 1
#define XPAR_AXIDMA_0_NUM_S2MM_CHANNELS 1
#define XPAR_AXIDMA_0_MM2S_BURST_SIZE 16
#define XPAR_AXIDMA_0_S2MM_BURST_SIZE 64
#define XPAR_AXIDMA_0_MICRO_DMA 0
#define XPAR_AXIDMA_0_c_addr_width 32

/* Canonical definitions for peripheral TRACE_ANALYZER_PMODB_AXI_DMA_0 */
#define XPAR_AXIDMA_1_DEVICE_ID XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_DEVICE_ID
#define XPAR_AXIDMA_1_BASEADDR 0x80420000
#define XPAR_AXIDMA_1_SG_INCLUDE_STSCNTRL_STRM 0
#define XPAR_AXIDMA_1_INCLUDE_MM2S 0
#define XPAR_AXIDMA_1_INCLUDE_MM2S_DRE 0
#define XPAR_AXIDMA_1_M_AXI_MM2S_DATA_WIDTH 32
#define XPAR_AXIDMA_1_INCLUDE_S2MM 1
#define XPAR_AXIDMA_1_INCLUDE_S2MM_DRE 0
#define XPAR_AXIDMA_1_M_AXI_S2MM_DATA_WIDTH 32
#define XPAR_AXIDMA_1_INCLUDE_SG 0
#define XPAR_AXIDMA_1_ENABLE_MULTI_CHANNEL 0
#define XPAR_AXIDMA_1_NUM_MM2S_CHANNELS 1
#define XPAR_AXIDMA_1_NUM_S2MM_CHANNELS 1
#define XPAR_AXIDMA_1_MM2S_BURST_SIZE 16
#define XPAR_AXIDMA_1_S2MM_BURST_SIZE 64
#define XPAR_AXIDMA_1_MICRO_DMA 0
#define XPAR_AXIDMA_1_c_addr_width 32


/******************************************************************/

/* Definitions for driver AXIVDMA */
#define XPAR_XAXIVDMA_NUM_INSTANCES 1U

/* Definitions for peripheral VIDEO_AXI_VDMA */
#define XPAR_VIDEO_AXI_VDMA_DEVICE_ID 0U
#define XPAR_VIDEO_AXI_VDMA_BASEADDR 0x43000000U
#define XPAR_VIDEO_AXI_VDMA_HIGHADDR 0x4300FFFFU
#define XPAR_VIDEO_AXI_VDMA_NUM_FSTORES 4U
#define XPAR_VIDEO_AXI_VDMA_INCLUDE_MM2S 1U
#define XPAR_VIDEO_AXI_VDMA_INCLUDE_MM2S_DRE 0U
#define XPAR_VIDEO_AXI_VDMA_M_AXI_MM2S_DATA_WIDTH 32U
#define XPAR_VIDEO_AXI_VDMA_INCLUDE_S2MM 1U
#define XPAR_VIDEO_AXI_VDMA_INCLUDE_S2MM_DRE 0U
#define XPAR_VIDEO_AXI_VDMA_M_AXI_S2MM_DATA_WIDTH 64U
#define XPAR_VIDEO_AXI_VDMA_AXI_MM2S_ACLK_FREQ_HZ 0U
#define XPAR_VIDEO_AXI_VDMA_AXI_S2MM_ACLK_FREQ_HZ 0U
#define XPAR_VIDEO_AXI_VDMA_MM2S_GENLOCK_MODE 1U
#define XPAR_VIDEO_AXI_VDMA_MM2S_GENLOCK_NUM_MASTERS 1U
#define XPAR_VIDEO_AXI_VDMA_S2MM_GENLOCK_MODE 0U
#define XPAR_VIDEO_AXI_VDMA_S2MM_GENLOCK_NUM_MASTERS 1U
#define XPAR_VIDEO_AXI_VDMA_INCLUDE_SG 0U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_VIDPRMTR_READS 1U
#define XPAR_VIDEO_AXI_VDMA_USE_FSYNC 1U
#define XPAR_VIDEO_AXI_VDMA_FLUSH_ON_FSYNC 1U
#define XPAR_VIDEO_AXI_VDMA_MM2S_LINEBUFFER_DEPTH 512U
#define XPAR_VIDEO_AXI_VDMA_S2MM_LINEBUFFER_DEPTH 4096U
#define XPAR_VIDEO_AXI_VDMA_INCLUDE_INTERNAL_GENLOCK 1U
#define XPAR_VIDEO_AXI_VDMA_S2MM_SOF_ENABLE 1U
#define XPAR_VIDEO_AXI_VDMA_M_AXIS_MM2S_TDATA_WIDTH 32U
#define XPAR_VIDEO_AXI_VDMA_S_AXIS_S2MM_TDATA_WIDTH 32U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_1 0U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_5 0U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_6 1U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_7 1U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_9 0U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_13 0U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_14 1U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_INFO_15 1U
#define XPAR_VIDEO_AXI_VDMA_ENABLE_DEBUG_ALL 0U
#define XPAR_VIDEO_AXI_VDMA_ADDR_WIDTH 32U


/******************************************************************/

/* Canonical definitions for peripheral VIDEO_AXI_VDMA */
#define XPAR_AXIVDMA_0_DEVICE_ID XPAR_VIDEO_AXI_VDMA_DEVICE_ID
#define XPAR_AXIVDMA_0_BASEADDR 0x43000000U
#define XPAR_AXIVDMA_0_HIGHADDR 0x4300FFFFU
#define XPAR_AXIVDMA_0_NUM_FSTORES 4U
#define XPAR_AXIVDMA_0_INCLUDE_MM2S 1U
#define XPAR_AXIVDMA_0_INCLUDE_MM2S_DRE 0U
#define XPAR_AXIVDMA_0_M_AXI_MM2S_DATA_WIDTH 32U
#define XPAR_AXIVDMA_0_INCLUDE_S2MM 1U
#define XPAR_AXIVDMA_0_INCLUDE_S2MM_DRE 0U
#define XPAR_AXIVDMA_0_M_AXI_S2MM_DATA_WIDTH 64U
#define XPAR_AXIVDMA_0_AXI_MM2S_ACLK_FREQ_HZ 0U
#define XPAR_AXIVDMA_0_AXI_S2MM_ACLK_FREQ_HZ 0U
#define XPAR_AXIVDMA_0_MM2S_GENLOCK_MODE 1U
#define XPAR_AXIVDMA_0_MM2S_GENLOCK_NUM_MASTERS 1U
#define XPAR_AXIVDMA_0_S2MM_GENLOCK_MODE 0U
#define XPAR_AXIVDMA_0_S2MM_GENLOCK_NUM_MASTERS 1U
#define XPAR_AXIVDMA_0_INCLUDE_SG 0U
#define XPAR_AXIVDMA_0_ENABLE_VIDPRMTR_READS 1U
#define XPAR_AXIVDMA_0_USE_FSYNC 1U
#define XPAR_AXIVDMA_0_FLUSH_ON_FSYNC 1U
#define XPAR_AXIVDMA_0_MM2S_LINEBUFFER_DEPTH 512U
#define XPAR_AXIVDMA_0_S2MM_LINEBUFFER_DEPTH 4096U
#define XPAR_AXIVDMA_0_INCLUDE_INTERNAL_GENLOCK 1U
#define XPAR_AXIVDMA_0_S2MM_SOF_ENABLE 1U
#define XPAR_AXIVDMA_0_M_AXIS_MM2S_TDATA_WIDTH 32U
#define XPAR_AXIVDMA_0_S_AXIS_S2MM_TDATA_WIDTH 32U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_1 0U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_5 0U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_6 1U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_7 1U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_9 0U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_13 0U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_14 1U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_INFO_15 1U
#define XPAR_AXIVDMA_0_ENABLE_DEBUG_ALL 0U
#define XPAR_AXIVDMA_0_c_addr_width 32U


/******************************************************************/

/* Definitions for driver BRAM */
#define XPAR_XBRAM_NUM_INSTANCES 4U

/* Definitions for peripheral IOP_ARDUINO_MB_BRAM_CTRL */
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_DEVICE_ID 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_DATA_WIDTH 32U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_ECC 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_FAULT_INJECT 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_CE_FAILING_REGISTERS 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_UE_FAILING_REGISTERS 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_ECC_STATUS_REGISTERS 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_CE_COUNTER_WIDTH 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_ECC_ONOFF_REGISTER 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_WRITE_ACCESS 0U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_S_AXI_BASEADDR 0x44000000U
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_S_AXI_HIGHADDR 0x4400FFFFU
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_S_AXI_CTRL_BASEADDR 0xFFFFFFFFU
#define XPAR_IOP_ARDUINO_MB_BRAM_CTRL_S_AXI_CTRL_HIGHADDR 0xFFFFFFFFU


/* Definitions for peripheral IOP_PMODA_MB_BRAM_CTRL */
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_DEVICE_ID 1U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_DATA_WIDTH 32U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_ECC 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_FAULT_INJECT 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_CE_FAILING_REGISTERS 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_UE_FAILING_REGISTERS 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_ECC_STATUS_REGISTERS 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_CE_COUNTER_WIDTH 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_ECC_ONOFF_REGISTER 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_WRITE_ACCESS 0U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_S_AXI_BASEADDR 0x40000000U
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_S_AXI_HIGHADDR 0x4000FFFFU
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_S_AXI_CTRL_BASEADDR 0xFFFFFFFFU
#define XPAR_IOP_PMODA_MB_BRAM_CTRL_S_AXI_CTRL_HIGHADDR 0xFFFFFFFFU


/* Definitions for peripheral IOP_PMODB_MB_BRAM_CTRL */
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_DEVICE_ID 2U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_DATA_WIDTH 32U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_ECC 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_FAULT_INJECT 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_CE_FAILING_REGISTERS 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_UE_FAILING_REGISTERS 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_ECC_STATUS_REGISTERS 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_CE_COUNTER_WIDTH 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_ECC_ONOFF_REGISTER 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_WRITE_ACCESS 0U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_S_AXI_BASEADDR 0x42000000U
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_S_AXI_HIGHADDR 0x4200FFFFU
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_S_AXI_CTRL_BASEADDR 0xFFFFFFFFU
#define XPAR_IOP_PMODB_MB_BRAM_CTRL_S_AXI_CTRL_HIGHADDR 0xFFFFFFFFU


/* Definitions for peripheral IOP_RPI_MB_BRAM_CTRL */
#define XPAR_IOP_RPI_MB_BRAM_CTRL_DEVICE_ID 3U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_DATA_WIDTH 32U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_ECC 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_FAULT_INJECT 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_CE_FAILING_REGISTERS 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_UE_FAILING_REGISTERS 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_ECC_STATUS_REGISTERS 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_CE_COUNTER_WIDTH 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_ECC_ONOFF_REGISTER 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_WRITE_ACCESS 0U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_S_AXI_BASEADDR 0x46000000U
#define XPAR_IOP_RPI_MB_BRAM_CTRL_S_AXI_HIGHADDR 0x4600FFFFU
#define XPAR_IOP_RPI_MB_BRAM_CTRL_S_AXI_CTRL_BASEADDR 0xFFFFFFFFU
#define XPAR_IOP_RPI_MB_BRAM_CTRL_S_AXI_CTRL_HIGHADDR 0xFFFFFFFFU


/******************************************************************/

/* Canonical definitions for peripheral IOP_ARDUINO_MB_BRAM_CTRL */
#define XPAR_BRAM_0_DEVICE_ID XPAR_IOP_ARDUINO_MB_BRAM_CTRL_DEVICE_ID
#define XPAR_BRAM_0_DATA_WIDTH 32U
#define XPAR_BRAM_0_ECC 0U
#define XPAR_BRAM_0_FAULT_INJECT 0U
#define XPAR_BRAM_0_CE_FAILING_REGISTERS 0U
#define XPAR_BRAM_0_UE_FAILING_REGISTERS 0U
#define XPAR_BRAM_0_ECC_STATUS_REGISTERS 0U
#define XPAR_BRAM_0_CE_COUNTER_WIDTH 0U
#define XPAR_BRAM_0_ECC_ONOFF_REGISTER 0U
#define XPAR_BRAM_0_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_BRAM_0_WRITE_ACCESS 0U
#define XPAR_BRAM_0_BASEADDR 0x44000000U
#define XPAR_BRAM_0_HIGHADDR 0x4400FFFFU

/* Canonical definitions for peripheral IOP_PMODA_MB_BRAM_CTRL */
#define XPAR_BRAM_1_DEVICE_ID XPAR_IOP_PMODA_MB_BRAM_CTRL_DEVICE_ID
#define XPAR_BRAM_1_DATA_WIDTH 32U
#define XPAR_BRAM_1_ECC 0U
#define XPAR_BRAM_1_FAULT_INJECT 0U
#define XPAR_BRAM_1_CE_FAILING_REGISTERS 0U
#define XPAR_BRAM_1_UE_FAILING_REGISTERS 0U
#define XPAR_BRAM_1_ECC_STATUS_REGISTERS 0U
#define XPAR_BRAM_1_CE_COUNTER_WIDTH 0U
#define XPAR_BRAM_1_ECC_ONOFF_REGISTER 0U
#define XPAR_BRAM_1_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_BRAM_1_WRITE_ACCESS 0U
#define XPAR_BRAM_1_BASEADDR 0x40000000U
#define XPAR_BRAM_1_HIGHADDR 0x4000FFFFU

/* Canonical definitions for peripheral IOP_PMODB_MB_BRAM_CTRL */
#define XPAR_BRAM_2_DEVICE_ID XPAR_IOP_PMODB_MB_BRAM_CTRL_DEVICE_ID
#define XPAR_BRAM_2_DATA_WIDTH 32U
#define XPAR_BRAM_2_ECC 0U
#define XPAR_BRAM_2_FAULT_INJECT 0U
#define XPAR_BRAM_2_CE_FAILING_REGISTERS 0U
#define XPAR_BRAM_2_UE_FAILING_REGISTERS 0U
#define XPAR_BRAM_2_ECC_STATUS_REGISTERS 0U
#define XPAR_BRAM_2_CE_COUNTER_WIDTH 0U
#define XPAR_BRAM_2_ECC_ONOFF_REGISTER 0U
#define XPAR_BRAM_2_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_BRAM_2_WRITE_ACCESS 0U
#define XPAR_BRAM_2_BASEADDR 0x42000000U
#define XPAR_BRAM_2_HIGHADDR 0x4200FFFFU

/* Canonical definitions for peripheral IOP_RPI_MB_BRAM_CTRL */
#define XPAR_BRAM_3_DEVICE_ID XPAR_IOP_RPI_MB_BRAM_CTRL_DEVICE_ID
#define XPAR_BRAM_3_DATA_WIDTH 32U
#define XPAR_BRAM_3_ECC 0U
#define XPAR_BRAM_3_FAULT_INJECT 0U
#define XPAR_BRAM_3_CE_FAILING_REGISTERS 0U
#define XPAR_BRAM_3_UE_FAILING_REGISTERS 0U
#define XPAR_BRAM_3_ECC_STATUS_REGISTERS 0U
#define XPAR_BRAM_3_CE_COUNTER_WIDTH 0U
#define XPAR_BRAM_3_ECC_ONOFF_REGISTER 0U
#define XPAR_BRAM_3_ECC_ONOFF_RESET_VALUE 0U
#define XPAR_BRAM_3_WRITE_ACCESS 0U
#define XPAR_BRAM_3_BASEADDR 0x46000000U
#define XPAR_BRAM_3_HIGHADDR 0x4600FFFFU


/******************************************************************/

/* Definitions for driver COLOR_CONVERT */
#define XPAR_XCOLOR_CONVERT_NUM_INSTANCES 2

/* Definitions for peripheral VIDEO_HDMI_IN_COLOR_CONVERT */
#define XPAR_VIDEO_HDMI_IN_COLOR_CONVERT_DEVICE_ID 0
#define XPAR_VIDEO_HDMI_IN_COLOR_CONVERT_S_AXI_AXILITES_BASEADDR 0x43C50000
#define XPAR_VIDEO_HDMI_IN_COLOR_CONVERT_S_AXI_AXILITES_HIGHADDR 0x43C5FFFF


/* Definitions for peripheral VIDEO_HDMI_OUT_COLOR_CONVERT */
#define XPAR_VIDEO_HDMI_OUT_COLOR_CONVERT_DEVICE_ID 1
#define XPAR_VIDEO_HDMI_OUT_COLOR_CONVERT_S_AXI_AXILITES_BASEADDR 0x43C60000
#define XPAR_VIDEO_HDMI_OUT_COLOR_CONVERT_S_AXI_AXILITES_HIGHADDR 0x43C6FFFF


/******************************************************************/

/* Canonical definitions for peripheral VIDEO_HDMI_IN_COLOR_CONVERT */
#define XPAR_XCOLOR_CONVERT_0_DEVICE_ID XPAR_VIDEO_HDMI_IN_COLOR_CONVERT_DEVICE_ID
#define XPAR_XCOLOR_CONVERT_0_S_AXI_AXILITES_BASEADDR 0x43C50000
#define XPAR_XCOLOR_CONVERT_0_S_AXI_AXILITES_HIGHADDR 0x43C5FFFF

/* Canonical definitions for peripheral VIDEO_HDMI_OUT_COLOR_CONVERT */
#define XPAR_XCOLOR_CONVERT_1_DEVICE_ID XPAR_VIDEO_HDMI_OUT_COLOR_CONVERT_DEVICE_ID
#define XPAR_XCOLOR_CONVERT_1_S_AXI_AXILITES_BASEADDR 0x43C60000
#define XPAR_XCOLOR_CONVERT_1_S_AXI_AXILITES_HIGHADDR 0x43C6FFFF


/******************************************************************/


/* Definitions for peripheral PS7_DDR_0 */
#define XPAR_PS7_DDR_0_S_AXI_BASEADDR 0x00100000
#define XPAR_PS7_DDR_0_S_AXI_HIGHADDR 0x1FFFFFFF


/******************************************************************/

/* Definitions for driver DEVCFG */
#define XPAR_XDCFG_NUM_INSTANCES 1U

/* Definitions for peripheral PS7_DEV_CFG_0 */
#define XPAR_PS7_DEV_CFG_0_DEVICE_ID 0U
#define XPAR_PS7_DEV_CFG_0_BASEADDR 0xF8007000U
#define XPAR_PS7_DEV_CFG_0_HIGHADDR 0xF80070FFU


/******************************************************************/

/* Canonical definitions for peripheral PS7_DEV_CFG_0 */
#define XPAR_XDCFG_0_DEVICE_ID XPAR_PS7_DEV_CFG_0_DEVICE_ID
#define XPAR_XDCFG_0_BASEADDR 0xF8007000U
#define XPAR_XDCFG_0_HIGHADDR 0xF80070FFU


/******************************************************************/

/* Definitions for driver DMAPS */
#define XPAR_XDMAPS_NUM_INSTANCES 2

/* Definitions for peripheral PS7_DMA_NS */
#define XPAR_PS7_DMA_NS_DEVICE_ID 0
#define XPAR_PS7_DMA_NS_BASEADDR 0xF8004000
#define XPAR_PS7_DMA_NS_HIGHADDR 0xF8004FFF


/* Definitions for peripheral PS7_DMA_S */
#define XPAR_PS7_DMA_S_DEVICE_ID 1
#define XPAR_PS7_DMA_S_BASEADDR 0xF8003000
#define XPAR_PS7_DMA_S_HIGHADDR 0xF8003FFF


/******************************************************************/

/* Canonical definitions for peripheral PS7_DMA_NS */
#define XPAR_XDMAPS_0_DEVICE_ID XPAR_PS7_DMA_NS_DEVICE_ID
#define XPAR_XDMAPS_0_BASEADDR 0xF8004000
#define XPAR_XDMAPS_0_HIGHADDR 0xF8004FFF

/* Canonical definitions for peripheral PS7_DMA_S */
#define XPAR_XDMAPS_1_DEVICE_ID XPAR_PS7_DMA_S_DEVICE_ID
#define XPAR_XDMAPS_1_BASEADDR 0xF8003000
#define XPAR_XDMAPS_1_HIGHADDR 0xF8003FFF


/******************************************************************/

/* Definitions for driver EMACPS */
#define XPAR_XEMACPS_NUM_INSTANCES 1

/* Definitions for peripheral PS7_ETHERNET_0 */
#define XPAR_PS7_ETHERNET_0_DEVICE_ID 0
#define XPAR_PS7_ETHERNET_0_BASEADDR 0xE000B000
#define XPAR_PS7_ETHERNET_0_HIGHADDR 0xE000BFFF
#define XPAR_PS7_ETHERNET_0_ENET_CLK_FREQ_HZ 125000000
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_1000MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_1000MBPS_DIV1 1
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_100MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_100MBPS_DIV1 5
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_10MBPS_DIV0 8
#define XPAR_PS7_ETHERNET_0_ENET_SLCR_10MBPS_DIV1 50


/******************************************************************/

#define XPAR_PS7_ETHERNET_0_IS_CACHE_COHERENT 0
/* Canonical definitions for peripheral PS7_ETHERNET_0 */
#define XPAR_XEMACPS_0_DEVICE_ID XPAR_PS7_ETHERNET_0_DEVICE_ID
#define XPAR_XEMACPS_0_BASEADDR 0xE000B000
#define XPAR_XEMACPS_0_HIGHADDR 0xE000BFFF
#define XPAR_XEMACPS_0_ENET_CLK_FREQ_HZ 125000000
#define XPAR_XEMACPS_0_ENET_SLCR_1000Mbps_DIV0 8
#define XPAR_XEMACPS_0_ENET_SLCR_1000Mbps_DIV1 1
#define XPAR_XEMACPS_0_ENET_SLCR_100Mbps_DIV0 8
#define XPAR_XEMACPS_0_ENET_SLCR_100Mbps_DIV1 5
#define XPAR_XEMACPS_0_ENET_SLCR_10Mbps_DIV0 8
#define XPAR_XEMACPS_0_ENET_SLCR_10Mbps_DIV1 50


/******************************************************************/


/* Definitions for peripheral AUDIO_CODEC_CTRL_0 */
#define XPAR_AUDIO_CODEC_CTRL_0_BASEADDR 0x43C00000
#define XPAR_AUDIO_CODEC_CTRL_0_HIGHADDR 0x43C0FFFF


/* Definitions for peripheral PS7_AFI_0 */
#define XPAR_PS7_AFI_0_S_AXI_BASEADDR 0xF8008000
#define XPAR_PS7_AFI_0_S_AXI_HIGHADDR 0xF8008FFF


/* Definitions for peripheral PS7_AFI_1 */
#define XPAR_PS7_AFI_1_S_AXI_BASEADDR 0xF8009000
#define XPAR_PS7_AFI_1_S_AXI_HIGHADDR 0xF8009FFF


/* Definitions for peripheral PS7_AFI_2 */
#define XPAR_PS7_AFI_2_S_AXI_BASEADDR 0xF800A000
#define XPAR_PS7_AFI_2_S_AXI_HIGHADDR 0xF800AFFF


/* Definitions for peripheral PS7_AFI_3 */
#define XPAR_PS7_AFI_3_S_AXI_BASEADDR 0xF800B000
#define XPAR_PS7_AFI_3_S_AXI_HIGHADDR 0xF800BFFF


/* Definitions for peripheral PS7_DDRC_0 */
#define XPAR_PS7_DDRC_0_S_AXI_BASEADDR 0xF8006000
#define XPAR_PS7_DDRC_0_S_AXI_HIGHADDR 0xF8006FFF


/* Definitions for peripheral PS7_GLOBALTIMER_0 */
#define XPAR_PS7_GLOBALTIMER_0_S_AXI_BASEADDR 0xF8F00200
#define XPAR_PS7_GLOBALTIMER_0_S_AXI_HIGHADDR 0xF8F002FF


/* Definitions for peripheral PS7_GPV_0 */
#define XPAR_PS7_GPV_0_S_AXI_BASEADDR 0xF8900000
#define XPAR_PS7_GPV_0_S_AXI_HIGHADDR 0xF89FFFFF


/* Definitions for peripheral PS7_INTC_DIST_0 */
#define XPAR_PS7_INTC_DIST_0_S_AXI_BASEADDR 0xF8F01000
#define XPAR_PS7_INTC_DIST_0_S_AXI_HIGHADDR 0xF8F01FFF


/* Definitions for peripheral PS7_IOP_BUS_CONFIG_0 */
#define XPAR_PS7_IOP_BUS_CONFIG_0_S_AXI_BASEADDR 0xE0200000
#define XPAR_PS7_IOP_BUS_CONFIG_0_S_AXI_HIGHADDR 0xE0200FFF


/* Definitions for peripheral PS7_L2CACHEC_0 */
#define XPAR_PS7_L2CACHEC_0_S_AXI_BASEADDR 0xF8F02000
#define XPAR_PS7_L2CACHEC_0_S_AXI_HIGHADDR 0xF8F02FFF


/* Definitions for peripheral PS7_OCMC_0 */
#define XPAR_PS7_OCMC_0_S_AXI_BASEADDR 0xF800C000
#define XPAR_PS7_OCMC_0_S_AXI_HIGHADDR 0xF800CFFF


/* Definitions for peripheral PS7_PL310_0 */
#define XPAR_PS7_PL310_0_S_AXI_BASEADDR 0xF8F02000
#define XPAR_PS7_PL310_0_S_AXI_HIGHADDR 0xF8F02FFF


/* Definitions for peripheral PS7_PMU_0 */
#define XPAR_PS7_PMU_0_S_AXI_BASEADDR 0xF8891000
#define XPAR_PS7_PMU_0_S_AXI_HIGHADDR 0xF8891FFF
#define XPAR_PS7_PMU_0_PMU1_S_AXI_BASEADDR 0xF8893000
#define XPAR_PS7_PMU_0_PMU1_S_AXI_HIGHADDR 0xF8893FFF


/* Definitions for peripheral PS7_QSPI_LINEAR_0 */
#define XPAR_PS7_QSPI_LINEAR_0_S_AXI_BASEADDR 0xFC000000
#define XPAR_PS7_QSPI_LINEAR_0_S_AXI_HIGHADDR 0xFCFFFFFF


/* Definitions for peripheral PS7_RAM_0 */
#define XPAR_PS7_RAM_0_S_AXI_BASEADDR 0x00000000
#define XPAR_PS7_RAM_0_S_AXI_HIGHADDR 0x0003FFFF


/* Definitions for peripheral PS7_RAM_1 */
#define XPAR_PS7_RAM_1_S_AXI_BASEADDR 0xFFFC0000
#define XPAR_PS7_RAM_1_S_AXI_HIGHADDR 0xFFFFFFFF


/* Definitions for peripheral PS7_SCUC_0 */
#define XPAR_PS7_SCUC_0_S_AXI_BASEADDR 0xF8F00000
#define XPAR_PS7_SCUC_0_S_AXI_HIGHADDR 0xF8F000FC


/* Definitions for peripheral PS7_SLCR_0 */
#define XPAR_PS7_SLCR_0_S_AXI_BASEADDR 0xF8000000
#define XPAR_PS7_SLCR_0_S_AXI_HIGHADDR 0xF8000FFF


/* Definitions for peripheral VIDEO_HDMI_OUT_FRONTEND_AXI_DYNCLK */
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_AXI_DYNCLK_BASEADDR 0x43C10000
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_AXI_DYNCLK_HIGHADDR 0x43C1FFFF


/******************************************************************/

/* Definitions for driver GPIO */
#define XPAR_XGPIO_NUM_INSTANCES 6

/* Definitions for peripheral BTNS_GPIO */
#define XPAR_BTNS_GPIO_BASEADDR 0x41210000
#define XPAR_BTNS_GPIO_HIGHADDR 0x4121FFFF
#define XPAR_BTNS_GPIO_DEVICE_ID 0
#define XPAR_BTNS_GPIO_INTERRUPT_PRESENT 1
#define XPAR_BTNS_GPIO_IS_DUAL 0


/* Definitions for peripheral LEDS_GPIO */
#define XPAR_LEDS_GPIO_BASEADDR 0x41250000
#define XPAR_LEDS_GPIO_HIGHADDR 0x4125FFFF
#define XPAR_LEDS_GPIO_DEVICE_ID 1
#define XPAR_LEDS_GPIO_INTERRUPT_PRESENT 1
#define XPAR_LEDS_GPIO_IS_DUAL 0


/* Definitions for peripheral RGBLEDS_GPIO */
#define XPAR_RGBLEDS_GPIO_BASEADDR 0x41240000
#define XPAR_RGBLEDS_GPIO_HIGHADDR 0x4124FFFF
#define XPAR_RGBLEDS_GPIO_DEVICE_ID 2
#define XPAR_RGBLEDS_GPIO_INTERRUPT_PRESENT 0
#define XPAR_RGBLEDS_GPIO_IS_DUAL 0


/* Definitions for peripheral SWITCHES_GPIO */
#define XPAR_SWITCHES_GPIO_BASEADDR 0x41200000
#define XPAR_SWITCHES_GPIO_HIGHADDR 0x4120FFFF
#define XPAR_SWITCHES_GPIO_DEVICE_ID 3
#define XPAR_SWITCHES_GPIO_INTERRUPT_PRESENT 1
#define XPAR_SWITCHES_GPIO_IS_DUAL 0


/* Definitions for peripheral VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN */
#define XPAR_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_BASEADDR 0x41220000
#define XPAR_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_HIGHADDR 0x4122FFFF
#define XPAR_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_DEVICE_ID 4
#define XPAR_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_INTERRUPT_PRESENT 1
#define XPAR_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_IS_DUAL 1


/* Definitions for peripheral VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO */
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_BASEADDR 0x41230000
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_HIGHADDR 0x4123FFFF
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_DEVICE_ID 5
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_INTERRUPT_PRESENT 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_IS_DUAL 0


/******************************************************************/

/* Canonical definitions for peripheral BTNS_GPIO */
#define XPAR_GPIO_0_BASEADDR 0x41210000
#define XPAR_GPIO_0_HIGHADDR 0x4121FFFF
#define XPAR_GPIO_0_DEVICE_ID XPAR_BTNS_GPIO_DEVICE_ID
#define XPAR_GPIO_0_INTERRUPT_PRESENT 1
#define XPAR_GPIO_0_IS_DUAL 0

/* Canonical definitions for peripheral LEDS_GPIO */
#define XPAR_GPIO_1_BASEADDR 0x41250000
#define XPAR_GPIO_1_HIGHADDR 0x4125FFFF
#define XPAR_GPIO_1_DEVICE_ID XPAR_LEDS_GPIO_DEVICE_ID
#define XPAR_GPIO_1_INTERRUPT_PRESENT 1
#define XPAR_GPIO_1_IS_DUAL 0

/* Canonical definitions for peripheral RGBLEDS_GPIO */
#define XPAR_GPIO_2_BASEADDR 0x41240000
#define XPAR_GPIO_2_HIGHADDR 0x4124FFFF
#define XPAR_GPIO_2_DEVICE_ID XPAR_RGBLEDS_GPIO_DEVICE_ID
#define XPAR_GPIO_2_INTERRUPT_PRESENT 0
#define XPAR_GPIO_2_IS_DUAL 0

/* Canonical definitions for peripheral SWITCHES_GPIO */
#define XPAR_GPIO_3_BASEADDR 0x41200000
#define XPAR_GPIO_3_HIGHADDR 0x4120FFFF
#define XPAR_GPIO_3_DEVICE_ID XPAR_SWITCHES_GPIO_DEVICE_ID
#define XPAR_GPIO_3_INTERRUPT_PRESENT 1
#define XPAR_GPIO_3_IS_DUAL 0

/* Canonical definitions for peripheral VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN */
#define XPAR_GPIO_4_BASEADDR 0x41220000
#define XPAR_GPIO_4_HIGHADDR 0x4122FFFF
#define XPAR_GPIO_4_DEVICE_ID XPAR_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_DEVICE_ID
#define XPAR_GPIO_4_INTERRUPT_PRESENT 1
#define XPAR_GPIO_4_IS_DUAL 1

/* Canonical definitions for peripheral VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO */
#define XPAR_GPIO_5_BASEADDR 0x41230000
#define XPAR_GPIO_5_HIGHADDR 0x4123FFFF
#define XPAR_GPIO_5_DEVICE_ID XPAR_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_DEVICE_ID
#define XPAR_GPIO_5_INTERRUPT_PRESENT 1
#define XPAR_GPIO_5_IS_DUAL 0


/******************************************************************/

/* Definitions for driver GPIOPS */
#define XPAR_XGPIOPS_NUM_INSTANCES 1

/* Definitions for peripheral PS7_GPIO_0 */
#define XPAR_PS7_GPIO_0_DEVICE_ID 0
#define XPAR_PS7_GPIO_0_BASEADDR 0xE000A000
#define XPAR_PS7_GPIO_0_HIGHADDR 0xE000AFFF


/******************************************************************/

/* Canonical definitions for peripheral PS7_GPIO_0 */
#define XPAR_XGPIOPS_0_DEVICE_ID XPAR_PS7_GPIO_0_DEVICE_ID
#define XPAR_XGPIOPS_0_BASEADDR 0xE000A000
#define XPAR_XGPIOPS_0_HIGHADDR 0xE000AFFF


/******************************************************************/

/* Definitions for driver IICPS */
#define XPAR_XIICPS_NUM_INSTANCES 2

/* Definitions for peripheral PS7_I2C_0 */
#define XPAR_PS7_I2C_0_DEVICE_ID 0
#define XPAR_PS7_I2C_0_BASEADDR 0xE0004000
#define XPAR_PS7_I2C_0_HIGHADDR 0xE0004FFF
#define XPAR_PS7_I2C_0_I2C_CLK_FREQ_HZ 127777779


/* Definitions for peripheral PS7_I2C_1 */
#define XPAR_PS7_I2C_1_DEVICE_ID 1
#define XPAR_PS7_I2C_1_BASEADDR 0xE0005000
#define XPAR_PS7_I2C_1_HIGHADDR 0xE0005FFF
#define XPAR_PS7_I2C_1_I2C_CLK_FREQ_HZ 127777779


/******************************************************************/

/* Canonical definitions for peripheral PS7_I2C_0 */
#define XPAR_XIICPS_0_DEVICE_ID XPAR_PS7_I2C_0_DEVICE_ID
#define XPAR_XIICPS_0_BASEADDR 0xE0004000
#define XPAR_XIICPS_0_HIGHADDR 0xE0004FFF
#define XPAR_XIICPS_0_I2C_CLK_FREQ_HZ 127777779

/* Canonical definitions for peripheral PS7_I2C_1 */
#define XPAR_XIICPS_1_DEVICE_ID XPAR_PS7_I2C_1_DEVICE_ID
#define XPAR_XIICPS_1_BASEADDR 0xE0005000
#define XPAR_XIICPS_1_HIGHADDR 0xE0005FFF
#define XPAR_XIICPS_1_I2C_CLK_FREQ_HZ 127777779


/******************************************************************/

#define XPAR_INTC_MAX_NUM_INTR_INPUTS 15
#define XPAR_XINTC_HAS_IPR 1
#define XPAR_XINTC_HAS_SIE 1
#define XPAR_XINTC_HAS_CIE 1
#define XPAR_XINTC_HAS_IVR 1
/* Definitions for driver INTC */
#define XPAR_XINTC_NUM_INSTANCES 1

/* Definitions for peripheral SYSTEM_INTERRUPTS */
#define XPAR_SYSTEM_INTERRUPTS_DEVICE_ID 0
#define XPAR_SYSTEM_INTERRUPTS_BASEADDR 0x41800000
#define XPAR_SYSTEM_INTERRUPTS_HIGHADDR 0x4180FFFF
#define XPAR_SYSTEM_INTERRUPTS_KIND_OF_INTR 0xFFFFFFFF
#define XPAR_SYSTEM_INTERRUPTS_HAS_FAST 0
#define XPAR_SYSTEM_INTERRUPTS_IVAR_RESET_VALUE 0x00000010
#define XPAR_SYSTEM_INTERRUPTS_NUM_INTR_INPUTS 15


/******************************************************************/

#define XPAR_INTC_SINGLE_BASEADDR 0x41800000
#define XPAR_INTC_SINGLE_HIGHADDR 0x4180FFFF
#define XPAR_INTC_SINGLE_DEVICE_ID XPAR_SYSTEM_INTERRUPTS_DEVICE_ID
#define XPAR_SYSTEM_INTERRUPTS_TYPE 0U
#define XPAR_VIDEO_AXI_VDMA_S2MM_INTROUT_MASK 0X000001U
#define XPAR_SYSTEM_INTERRUPTS_VIDEO_AXI_VDMA_S2MM_INTROUT_INTR 0U
#define XPAR_VIDEO_AXI_VDMA_MM2S_INTROUT_MASK 0X000002U
#define XPAR_SYSTEM_INTERRUPTS_VIDEO_AXI_VDMA_MM2S_INTROUT_INTR 1U
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_IRQ_MASK 0X000004U
#define XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_IRQ_INTR 2U
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_IRQ_MASK 0X000008U
#define XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_IN_FRONTEND_VTC_IN_IRQ_INTR 3U
#define XPAR_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_IP2INTC_IRPT_MASK 0X000010U
#define XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_IP2INTC_IRPT_INTR 4U
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_IP2INTC_IRPT_MASK 0X000020U
#define XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_IP2INTC_IRPT_INTR 5U
#define XPAR_TRACE_ANALYZER_PMODB_AXI_DMA_0_S2MM_INTROUT_MASK 0X000040U
#define XPAR_SYSTEM_INTERRUPTS_TRACE_ANALYZER_PMODB_AXI_DMA_0_S2MM_INTROUT_INTR 6U
#define XPAR_TRACE_ANALYZER_PI_AXI_DMA_0_S2MM_INTROUT_MASK 0X000080U
#define XPAR_SYSTEM_INTERRUPTS_TRACE_ANALYZER_PI_AXI_DMA_0_S2MM_INTROUT_INTR 7U
#define XPAR_LEDS_GPIO_IP2INTC_IRPT_MASK 0X000100U
#define XPAR_SYSTEM_INTERRUPTS_LEDS_GPIO_IP2INTC_IRPT_INTR 8U
#define XPAR_IOP_PMODA_DFF_EN_RESET_VECTOR_0_Q_MASK 0X000200U
#define XPAR_SYSTEM_INTERRUPTS_IOP_PMODA_DFF_EN_RESET_VECTOR_0_Q_INTR 9U
#define XPAR_IOP_PMODB_DFF_EN_RESET_VECTOR_0_Q_MASK 0X000400U
#define XPAR_SYSTEM_INTERRUPTS_IOP_PMODB_DFF_EN_RESET_VECTOR_0_Q_INTR 10U
#define XPAR_IOP_ARDUINO_DFF_EN_RESET_VECTOR_0_Q_MASK 0X000800U
#define XPAR_SYSTEM_INTERRUPTS_IOP_ARDUINO_DFF_EN_RESET_VECTOR_0_Q_INTR 11U
#define XPAR_IOP_RPI_DFF_EN_RESET_VECTOR_0_Q_MASK 0X001000U
#define XPAR_SYSTEM_INTERRUPTS_IOP_RPI_DFF_EN_RESET_VECTOR_0_Q_INTR 12U
#define XPAR_BTNS_GPIO_IP2INTC_IRPT_MASK 0X002000U
#define XPAR_SYSTEM_INTERRUPTS_BTNS_GPIO_IP2INTC_IRPT_INTR 13U
#define XPAR_SWITCHES_GPIO_IP2INTC_IRPT_MASK 0X004000U
#define XPAR_SYSTEM_INTERRUPTS_SWITCHES_GPIO_IP2INTC_IRPT_INTR 14U

/******************************************************************/

/* Canonical definitions for peripheral SYSTEM_INTERRUPTS */
#define XPAR_INTC_0_DEVICE_ID XPAR_SYSTEM_INTERRUPTS_DEVICE_ID
#define XPAR_INTC_0_BASEADDR 0x41800000U
#define XPAR_INTC_0_HIGHADDR 0x4180FFFFU
#define XPAR_INTC_0_KIND_OF_INTR 0xFFFFFFFFU
#define XPAR_INTC_0_HAS_FAST 0U
#define XPAR_INTC_0_IVAR_RESET_VALUE 0x00000010U
#define XPAR_INTC_0_NUM_INTR_INPUTS 15U
#define XPAR_INTC_0_INTC_TYPE 0U

#define XPAR_INTC_0_AXIVDMA_0_S2MM_INTROUT_VEC_ID XPAR_SYSTEM_INTERRUPTS_VIDEO_AXI_VDMA_S2MM_INTROUT_INTR
#define XPAR_INTC_0_AXIVDMA_0_MM2S_INTROUT_VEC_ID XPAR_SYSTEM_INTERRUPTS_VIDEO_AXI_VDMA_MM2S_INTROUT_INTR
#define XPAR_INTC_0_VTC_1_VEC_ID XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_IRQ_INTR
#define XPAR_INTC_0_VTC_0_VEC_ID XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_IN_FRONTEND_VTC_IN_IRQ_INTR
#define XPAR_INTC_0_GPIO_4_VEC_ID XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_IN_FRONTEND_AXI_GPIO_HDMIIN_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_GPIO_5_VEC_ID XPAR_SYSTEM_INTERRUPTS_VIDEO_HDMI_OUT_FRONTEND_HDMI_OUT_HPD_VIDEO_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_AXIDMA_1_VEC_ID XPAR_SYSTEM_INTERRUPTS_TRACE_ANALYZER_PMODB_AXI_DMA_0_S2MM_INTROUT_INTR
#define XPAR_INTC_0_AXIDMA_0_VEC_ID XPAR_SYSTEM_INTERRUPTS_TRACE_ANALYZER_PI_AXI_DMA_0_S2MM_INTROUT_INTR
#define XPAR_INTC_0_GPIO_1_VEC_ID XPAR_SYSTEM_INTERRUPTS_LEDS_GPIO_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_GPIO_0_VEC_ID XPAR_SYSTEM_INTERRUPTS_BTNS_GPIO_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_GPIO_3_VEC_ID XPAR_SYSTEM_INTERRUPTS_SWITCHES_GPIO_IP2INTC_IRPT_INTR

/******************************************************************/

/* Definitions for driver PIXEL_PACK */
#define XPAR_XPIXEL_PACK_NUM_INSTANCES 1

/* Definitions for peripheral VIDEO_HDMI_IN_PIXEL_PACK */
#define XPAR_VIDEO_HDMI_IN_PIXEL_PACK_DEVICE_ID 0
#define XPAR_VIDEO_HDMI_IN_PIXEL_PACK_S_AXI_AXILITES_BASEADDR 0x43C40000
#define XPAR_VIDEO_HDMI_IN_PIXEL_PACK_S_AXI_AXILITES_HIGHADDR 0x43C4FFFF


/******************************************************************/

/* Canonical definitions for peripheral VIDEO_HDMI_IN_PIXEL_PACK */
#define XPAR_XPIXEL_PACK_0_DEVICE_ID XPAR_VIDEO_HDMI_IN_PIXEL_PACK_DEVICE_ID
#define XPAR_XPIXEL_PACK_0_S_AXI_AXILITES_BASEADDR 0x43C40000
#define XPAR_XPIXEL_PACK_0_S_AXI_AXILITES_HIGHADDR 0x43C4FFFF


/******************************************************************/

/* Definitions for driver PIXEL_UNPACK */
#define XPAR_XPIXEL_UNPACK_NUM_INSTANCES 1

/* Definitions for peripheral VIDEO_HDMI_OUT_PIXEL_UNPACK */
#define XPAR_VIDEO_HDMI_OUT_PIXEL_UNPACK_DEVICE_ID 0
#define XPAR_VIDEO_HDMI_OUT_PIXEL_UNPACK_S_AXI_AXILITES_BASEADDR 0x43C70000
#define XPAR_VIDEO_HDMI_OUT_PIXEL_UNPACK_S_AXI_AXILITES_HIGHADDR 0x43C7FFFF


/******************************************************************/

/* Canonical definitions for peripheral VIDEO_HDMI_OUT_PIXEL_UNPACK */
#define XPAR_XPIXEL_UNPACK_0_DEVICE_ID XPAR_VIDEO_HDMI_OUT_PIXEL_UNPACK_DEVICE_ID
#define XPAR_XPIXEL_UNPACK_0_S_AXI_AXILITES_BASEADDR 0x43C70000
#define XPAR_XPIXEL_UNPACK_0_S_AXI_AXILITES_HIGHADDR 0x43C7FFFF


/******************************************************************/

/* Definitions for driver QSPIPS */
#define XPAR_XQSPIPS_NUM_INSTANCES 1

/* Definitions for peripheral PS7_QSPI_0 */
#define XPAR_PS7_QSPI_0_DEVICE_ID 0
#define XPAR_PS7_QSPI_0_BASEADDR 0xE000D000
#define XPAR_PS7_QSPI_0_HIGHADDR 0xE000DFFF
#define XPAR_PS7_QSPI_0_QSPI_CLK_FREQ_HZ 200000000
#define XPAR_PS7_QSPI_0_QSPI_MODE 0
#define XPAR_PS7_QSPI_0_QSPI_BUS_WIDTH 2


/******************************************************************/

/* Canonical definitions for peripheral PS7_QSPI_0 */
#define XPAR_XQSPIPS_0_DEVICE_ID XPAR_PS7_QSPI_0_DEVICE_ID
#define XPAR_XQSPIPS_0_BASEADDR 0xE000D000
#define XPAR_XQSPIPS_0_HIGHADDR 0xE000DFFF
#define XPAR_XQSPIPS_0_QSPI_CLK_FREQ_HZ 200000000
#define XPAR_XQSPIPS_0_QSPI_MODE 0
#define XPAR_XQSPIPS_0_QSPI_BUS_WIDTH 2


/******************************************************************/

/* Definitions for driver SCUGIC */
#define XPAR_XSCUGIC_NUM_INSTANCES 1U

/* Definitions for peripheral PS7_SCUGIC_0 */
#define XPAR_PS7_SCUGIC_0_DEVICE_ID 0U
#define XPAR_PS7_SCUGIC_0_BASEADDR 0xF8F00100U
#define XPAR_PS7_SCUGIC_0_HIGHADDR 0xF8F001FFU
#define XPAR_PS7_SCUGIC_0_DIST_BASEADDR 0xF8F01000U


/******************************************************************/

/* Canonical definitions for peripheral PS7_SCUGIC_0 */
#define XPAR_SCUGIC_0_DEVICE_ID 0U
#define XPAR_SCUGIC_0_CPU_BASEADDR 0xF8F00100U
#define XPAR_SCUGIC_0_CPU_HIGHADDR 0xF8F001FFU
#define XPAR_SCUGIC_0_DIST_BASEADDR 0xF8F01000U


/******************************************************************/

/* Definitions for driver SCUTIMER */
#define XPAR_XSCUTIMER_NUM_INSTANCES 1

/* Definitions for peripheral PS7_SCUTIMER_0 */
#define XPAR_PS7_SCUTIMER_0_DEVICE_ID 0
#define XPAR_PS7_SCUTIMER_0_BASEADDR 0xF8F00600
#define XPAR_PS7_SCUTIMER_0_HIGHADDR 0xF8F0061F


/******************************************************************/

/* Canonical definitions for peripheral PS7_SCUTIMER_0 */
#define XPAR_XSCUTIMER_0_DEVICE_ID XPAR_PS7_SCUTIMER_0_DEVICE_ID
#define XPAR_XSCUTIMER_0_BASEADDR 0xF8F00600
#define XPAR_XSCUTIMER_0_HIGHADDR 0xF8F0061F


/******************************************************************/

/* Definitions for driver SCUWDT */
#define XPAR_XSCUWDT_NUM_INSTANCES 1

/* Definitions for peripheral PS7_SCUWDT_0 */
#define XPAR_PS7_SCUWDT_0_DEVICE_ID 0
#define XPAR_PS7_SCUWDT_0_BASEADDR 0xF8F00620
#define XPAR_PS7_SCUWDT_0_HIGHADDR 0xF8F006FF


/******************************************************************/

/* Canonical definitions for peripheral PS7_SCUWDT_0 */
#define XPAR_SCUWDT_0_DEVICE_ID XPAR_PS7_SCUWDT_0_DEVICE_ID
#define XPAR_SCUWDT_0_BASEADDR 0xF8F00620
#define XPAR_SCUWDT_0_HIGHADDR 0xF8F006FF


/******************************************************************/

/* Definitions for driver SDPS */
#define XPAR_XSDPS_NUM_INSTANCES 1

/* Definitions for peripheral PS7_SD_0 */
#define XPAR_PS7_SD_0_DEVICE_ID 0
#define XPAR_PS7_SD_0_BASEADDR 0xE0100000
#define XPAR_PS7_SD_0_HIGHADDR 0xE0100FFF
#define XPAR_PS7_SD_0_SDIO_CLK_FREQ_HZ 50000000
#define XPAR_PS7_SD_0_HAS_CD 1
#define XPAR_PS7_SD_0_HAS_WP 0
#define XPAR_PS7_SD_0_BUS_WIDTH 0
#define XPAR_PS7_SD_0_MIO_BANK 0
#define XPAR_PS7_SD_0_HAS_EMIO 0


/******************************************************************/

#define XPAR_PS7_SD_0_IS_CACHE_COHERENT 0
/* Canonical definitions for peripheral PS7_SD_0 */
#define XPAR_XSDPS_0_DEVICE_ID XPAR_PS7_SD_0_DEVICE_ID
#define XPAR_XSDPS_0_BASEADDR 0xE0100000
#define XPAR_XSDPS_0_HIGHADDR 0xE0100FFF
#define XPAR_XSDPS_0_SDIO_CLK_FREQ_HZ 50000000
#define XPAR_XSDPS_0_HAS_CD 1
#define XPAR_XSDPS_0_HAS_WP 0
#define XPAR_XSDPS_0_BUS_WIDTH 0
#define XPAR_XSDPS_0_MIO_BANK 0
#define XPAR_XSDPS_0_HAS_EMIO 0


/******************************************************************/

/* Definitions for driver TRACE_CNTRL_32 */
#define XPAR_XTRACE_CNTRL_32_NUM_INSTANCES 1

/* Definitions for peripheral TRACE_ANALYZER_PMODB_TRACE_CNTRL_32_0 */
#define XPAR_TRACE_ANALYZER_PMODB_TRACE_CNTRL_32_0_DEVICE_ID 0
#define XPAR_TRACE_ANALYZER_PMODB_TRACE_CNTRL_32_0_S_AXI_TRACE_CNTRL_BASEADDR 0x83C20000
#define XPAR_TRACE_ANALYZER_PMODB_TRACE_CNTRL_32_0_S_AXI_TRACE_CNTRL_HIGHADDR 0x83C2FFFF


/******************************************************************/

/* Canonical definitions for peripheral TRACE_ANALYZER_PMODB_TRACE_CNTRL_32_0 */
#define XPAR_XTRACE_CNTRL_32_0_DEVICE_ID XPAR_TRACE_ANALYZER_PMODB_TRACE_CNTRL_32_0_DEVICE_ID
#define XPAR_XTRACE_CNTRL_32_0_S_AXI_TRACE_CNTRL_BASEADDR 0x83C20000
#define XPAR_XTRACE_CNTRL_32_0_S_AXI_TRACE_CNTRL_HIGHADDR 0x83C2FFFF


/******************************************************************/

/* Definitions for driver TRACE_CNTRL_64 */
#define XPAR_XTRACE_CNTRL_64_NUM_INSTANCES 1

/* Definitions for peripheral TRACE_ANALYZER_PI_TRACE_CNTRL_64_0 */
#define XPAR_TRACE_ANALYZER_PI_TRACE_CNTRL_64_0_DEVICE_ID 0
#define XPAR_TRACE_ANALYZER_PI_TRACE_CNTRL_64_0_S_AXI_TRACE_CNTRL_BASEADDR 0x83C10000
#define XPAR_TRACE_ANALYZER_PI_TRACE_CNTRL_64_0_S_AXI_TRACE_CNTRL_HIGHADDR 0x83C1FFFF


/******************************************************************/

/* Canonical definitions for peripheral TRACE_ANALYZER_PI_TRACE_CNTRL_64_0 */
#define XPAR_XTRACE_CNTRL_64_0_DEVICE_ID XPAR_TRACE_ANALYZER_PI_TRACE_CNTRL_64_0_DEVICE_ID
#define XPAR_XTRACE_CNTRL_64_0_S_AXI_TRACE_CNTRL_BASEADDR 0x83C10000
#define XPAR_XTRACE_CNTRL_64_0_S_AXI_TRACE_CNTRL_HIGHADDR 0x83C1FFFF


/******************************************************************/

/* Definitions for driver UARTPS */
#define XPAR_XUARTPS_NUM_INSTANCES 1

/* Definitions for peripheral PS7_UART_0 */
#define XPAR_PS7_UART_0_DEVICE_ID 0
#define XPAR_PS7_UART_0_BASEADDR 0xE0000000
#define XPAR_PS7_UART_0_HIGHADDR 0xE0000FFF
#define XPAR_PS7_UART_0_UART_CLK_FREQ_HZ 100000000
#define XPAR_PS7_UART_0_HAS_MODEM 0


/******************************************************************/

/* Canonical definitions for peripheral PS7_UART_0 */
#define XPAR_XUARTPS_0_DEVICE_ID XPAR_PS7_UART_0_DEVICE_ID
#define XPAR_XUARTPS_0_BASEADDR 0xE0000000
#define XPAR_XUARTPS_0_HIGHADDR 0xE0000FFF
#define XPAR_XUARTPS_0_UART_CLK_FREQ_HZ 100000000
#define XPAR_XUARTPS_0_HAS_MODEM 0


/******************************************************************/

/* Definitions for driver USBPS */
#define XPAR_XUSBPS_NUM_INSTANCES 1

/* Definitions for peripheral PS7_USB_0 */
#define XPAR_PS7_USB_0_DEVICE_ID 0
#define XPAR_PS7_USB_0_BASEADDR 0xE0002000
#define XPAR_PS7_USB_0_HIGHADDR 0xE0002FFF


/******************************************************************/

/* Canonical definitions for peripheral PS7_USB_0 */
#define XPAR_XUSBPS_0_DEVICE_ID XPAR_PS7_USB_0_DEVICE_ID
#define XPAR_XUSBPS_0_BASEADDR 0xE0002000
#define XPAR_XUSBPS_0_HIGHADDR 0xE0002FFF


/******************************************************************/

/* Definitions for driver VTC */
#define XPAR_XVTC_NUM_INSTANCES 2

/* Definitions for peripheral VIDEO_HDMI_IN_FRONTEND_VTC_IN */
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DEVICE_ID 0
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_BASEADDR 0x43C30000
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_HIGHADDR 0x43C3FFFF
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_GENERATE_EN 0
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DETECT_EN 1
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DET_HSYNC_EN 1
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DET_VSYNC_EN 1
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DET_HBLANK_EN 0
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DET_VBLANK_EN 0
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DET_AVIDEO_EN 1
#define XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DET_ACHROMA_EN 0


/* Definitions for peripheral VIDEO_HDMI_OUT_FRONTEND_VTC_OUT */
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DEVICE_ID 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_BASEADDR 0x43C20000
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_HIGHADDR 0x43C2FFFF
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_GENERATE_EN 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DETECT_EN 0
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DET_HSYNC_EN 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DET_VSYNC_EN 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DET_HBLANK_EN 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DET_VBLANK_EN 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DET_AVIDEO_EN 1
#define XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DET_ACHROMA_EN 0


/******************************************************************/

/* Canonical definitions for peripheral VIDEO_HDMI_IN_FRONTEND_VTC_IN */
#define XPAR_VTC_0_DEVICE_ID XPAR_VIDEO_HDMI_IN_FRONTEND_VTC_IN_DEVICE_ID
#define XPAR_VTC_0_BASEADDR 0x43C30000
#define XPAR_VTC_0_HIGHADDR 0x43C3FFFF
#define XPAR_VTC_0_GENERATE_EN 0
#define XPAR_VTC_0_DETECT_EN 1
#define XPAR_VTC_0_DET_HSYNC_EN 1
#define XPAR_VTC_0_DET_VSYNC_EN 1
#define XPAR_VTC_0_DET_HBLANK_EN 0
#define XPAR_VTC_0_DET_VBLANK_EN 0
#define XPAR_VTC_0_DET_AVIDEO_EN 1
#define XPAR_VTC_0_DET_ACHROMA_EN 0

/* Canonical definitions for peripheral VIDEO_HDMI_OUT_FRONTEND_VTC_OUT */
#define XPAR_VTC_1_DEVICE_ID XPAR_VIDEO_HDMI_OUT_FRONTEND_VTC_OUT_DEVICE_ID
#define XPAR_VTC_1_BASEADDR 0x43C20000
#define XPAR_VTC_1_HIGHADDR 0x43C2FFFF
#define XPAR_VTC_1_GENERATE_EN 1
#define XPAR_VTC_1_DETECT_EN 0
#define XPAR_VTC_1_DET_HSYNC_EN 1
#define XPAR_VTC_1_DET_VSYNC_EN 1
#define XPAR_VTC_1_DET_HBLANK_EN 1
#define XPAR_VTC_1_DET_VBLANK_EN 1
#define XPAR_VTC_1_DET_AVIDEO_EN 1
#define XPAR_VTC_1_DET_ACHROMA_EN 0


/******************************************************************/

/* Definitions for driver XADCPS */
#define XPAR_XADCPS_NUM_INSTANCES 1

/* Definitions for peripheral PS7_XADC_0 */
#define XPAR_PS7_XADC_0_DEVICE_ID 0
#define XPAR_PS7_XADC_0_BASEADDR 0xF8007100
#define XPAR_PS7_XADC_0_HIGHADDR 0xF8007120


/******************************************************************/

/* Canonical definitions for peripheral PS7_XADC_0 */
#define XPAR_XADCPS_0_DEVICE_ID XPAR_PS7_XADC_0_DEVICE_ID
#define XPAR_XADCPS_0_BASEADDR 0xF8007100
#define XPAR_XADCPS_0_HIGHADDR 0xF8007120


/******************************************************************/

/* Definitions for driver IIC */
#define XPAR_XIIC_NUM_INSTANCES 1

/* Definitions for peripheral ZYNQ_US_SS_0_FMCH_AXI_IIC */
#define XPAR_ZYNQ_US_SS_0_FMCH_AXI_IIC_DEVICE_ID 0
#define XPAR_ZYNQ_US_SS_0_FMCH_AXI_IIC_BASEADDR 0x41600000
#define XPAR_ZYNQ_US_SS_0_FMCH_AXI_IIC_HIGHADDR 0x4160FFFF
#define XPAR_ZYNQ_US_SS_0_FMCH_AXI_IIC_TEN_BIT_ADR 0
#define XPAR_ZYNQ_US_SS_0_FMCH_AXI_IIC_GPO_WIDTH 1


/******************************************************************/

#endif  /* end of protection macro */
