import nltk
import re

nltk.download('punkt')

emoji_dict = {
    "😊": "হাসি",
    "😢": "কান্না",
    "😠": "রাগ",
    "😔": "মন খারাপ",
    "👍": "দারুণ",
    "😎": "ঠান্ডা",
    "😭": "অশ্রু",
    "😁": "মুচকি হাসি",
    "😅": "হালকা হাসি",
    "😍": "ভালবাসা",
    "😒": "অসন্তুষ্ট",
    "😞": "হতাশা",
    "😡": "রাগান্বিত",
    "😃": "খুশি",
    "😉": "চোখ মারা",
    "😋": "স্বাদ আস্বাদন",
    "😐": "নির্বিকার",
    "😤": "অসন্তুষ্ট",
    "😴": "ঘুম",
    "😜": "মজার",
    "😩": "ক্লান্ত",
    "😯": "আশ্চর্য",
    "😆": "হাসি",
    "😷": "মাস্ক",
    "🙄": "গুর্গুরানি",
    "😳": "বিস্মিত",
    "😬": "চিন্তিত",
    "😚": "চুম্বন",
    "😰": "উদ্বিগ্ন",
    "🤗": "আলিঙ্গন",
    "🤔": "চিন্তাশীল",
    "🤐": "মুখ বন্ধ",
    "😇": "পুণ্যবান"
}

bn_stopwords =['জানায়', 'ওখানে', 'তারা', 'সঙ্গে', 'ধরা', 'ছাড়া', 'করে', 'আদ্যভাগে', 'ওরা', 'হওয়ায়', 'করায়', 'এতটাই', 'সব', 'একটি', 'করেন', 'এমনি', 'করেছে', 'এই', 'বেশ', 'ওঁদের', 'বলল', 'ক্ষেত্রে', 'কিংবা', 'দিয়েছে', 'শুধু', 'এল', 'এমন', 'আপনারা', 'যার', 'টি', 'করবে', 'ই', 'চার', 'নেওয়া', 'আই', 'বলে', 'পর্যন্ত', 'লক্ষ', 'সবাই', 'কিভাবে', 'তাহাতে', 'ব্যবহার', 'সকল', 'সর্বনিম্ন', 'তাও', 'পেয়ে', 'নানা', 'ওদের', 'অর্থাত', 'করেছেন', 'হচ্ছে', 'সেই', 'এটি', 'হবেন', 'গেল', 'কেউই', 'এবার', 'অবশ্যই', 'ভেতরে', 'আগেই', 'সবার', 'অপর', 'করেছিলেন', 'সুতরাং', 'অন্তত', 'মাঝে', 'তবু', 'তাঁাহারা', 'পারি', 'অন্য', 'হোক', 'প্রতি', 'এটাই', 'এরা', 'যাঁর', 'বিভিন্ন', 'হত', 'ওঁর', 'যখন', 'ওর', 'দুই', 'হলে', 'মধ্যবর্তী', 'অন্যান্য', 'তত', 'আবার', 'কিন্তু', 'মধ্যেই', 'হয়ে', 'নতুন', 'বরং', 'আমাদের', 'থাকায়', 'হইয়া', 'দুটি', 'এঁদের', 'সামনে', 'ঠিক', 'দিলেন', 'নয়', 'কাছ', 'এত', 'করছে', 'কবে', 'গুলি', 'গিয়ে', 'জন', 'দিয়ে', 'অথবা', 'অনেকেই', 'এখন', 'দেখতে', 'যাওয়া', 'নিতে', 'জনকে', 'আমরা', 'করিতে', 'বহু', 'থেকেও', 'করলে', 'গিয়েছে', 'কম', 'সেটাও', 'আগামী', 'শুরু', 'গিয়ে', 'কোন', 'গোটা', 'কি', 'কীভাবে', 'করি', 'দেওয়া', 'তাঁদের', 'স্পষ্ট', 'এরপর', 'থাকা', 'যাওয়া', 'নেওয়ার', 'যান', 'যাকে', 'করাই', 'তাহা', 'সঙ্গেও', 'বললেন', 'দেখে', 'ব্যাপারে', 'দেখা', 'জন্য', 'যেতে', 'করিয়ে', 'যাতে', 'থাকে', 'তাঁরা', 'তাহার', 'এছাড়া', 'এসে', 'হয়', 'যাচ্ছে', 'যতটা', 'থাকেন', 'কাছে', 'সম্প্রতি', 'হলেও', 'তিন', 'চলে', 'প্রাথমিক', 'মনে', 'হৈলে', 'রয়েছে', 'প্রায়', 'এটা', 'মতো', 'হলেই', 'থেকেই', 'তাঁর', 'ইহা', 'অবশ্য', 'তুলে', 'হয়নি', 'যাদের', 'ওঁরা', 'অনেকে', 'কী', 'তিনি', 'জানানো', 'চায়', 'ফিরে', 'একে', 'তথা', 'ভাবে', 'দেওয়ার', 'ফের', 'ওকে', 'করার', 'কেন', 'র', 'পারেন', 'বলেন', 'তিনিও', 'কারণ', 'পি', 'অতএব', 'সেখানে', 'তারপর', 'তাতে', 'কত', 'মোট', 'এস', 'তুমি', 'যেখানে', 'দিন', 'চেষ্টা', 'খুব', 'রাখা', 'উনি', 'ছাড়াও', 'দেন', 'হতে', 'হতেই', 'সহ', 'বলতে', 'নিজে', 'একই', 'তা', 'হয়েছেন', 'তবে', 'জানা', 'হয়েছিল', 'জনের', 'চেয়ে', 'নয়', 'নাহলে', 'অথচ', 'তাঁকে', 'বন', 'আমি', 'তাদের', 'যদিও', 'হওয়ার', 'কারও', 'কে', 'একবার', 'তোমার', 'উচিত', 'আর', 'মাধ্যমে', 'বদলে', 'সাধারণ', 'হলো', 'নাকি', 'সমস্ত', 'যারা', 'আজ', 'রকম', 'বাদে', 'নিশ্চিত', 'ইত্যাদি', 'থেকে', 'আসা', 'আরও', 'যাবে', 'সেখান', 'থাকবেন', 'করছেন', 'মধ্যে', 'উত্তর', 'পাচ', 'কখনও', 'স্বয়ং', 'হবে', 'পুরানো', 'যথেষ্ট', 'তাকে', 'এতে', 'কাউকে', 'নেওয়া', 'কয়েক', 'মধ্যেও', 'এখনও', 'গেছে', 'করেই', 'যা', 'আগে', 'হাজার', 'মোটেই', 'কিছুই', 'দিতে', 'জানিয়েছে', 'পরেই', 'কেননা', 'যেমন', 'এবং', 'তখন', 'সেটাই', 'ফলে', 'যত', 'উল্লেখযোগ্য', 'হয়েই', 'উপর', 'অনেক', 'প্রথম', 'নির্বাচন', 'জানতে', 'রেখে', 'পাওয়া', 'কেউ', 'প্রতিটি', 'আছে', 'তাই', 'দেওয়া', 'নিজেই', 'ও', 'আপনি', 'তাহলে', 'মধ্যভাগে', 'সি', 'পর', 'সে', 'এক্', 'জে', 'না', 'করতে', 'অবধি', 'ওই', 'প্রযন্ত', 'এখানে', 'জানিয়ে', 'কাজ', 'বি', 'পরের', 'পক্ষে', 'এখানেই', 'বেশি', 'সেটি', 'বসে', 'দেয়', 'নেই', 'এক', 'যেন', 'হন', 'যে', 'তেমন', 'দিয়েছেন', 'মতোই', 'নিজের', 'দুটো', 'গেলে', 'এঁরা', 'হয়তো', 'বক্তব্য', 'হিসাবে', 'পারে', 'তিনঐ', 'যিনি', 'ধরে', 'অনুযায়ী', 'কিছু', 'থাকবে', 'ছিল', 'তো', 'আমাকে', 'কমনে', 'এব', 'নাগাদ', 'এ', 'বিশেষ', 'দিকে', 'যদি', 'সেটা', 'নাই', 'নিজেদের', 'ছিলেন', 'হয়', 'পরেও', 'পরে', 'হল', 'বিনা', 'দু', 'আপনার', 'করলেন', 'করা', 'কয়েক', 'কেখা', 'উপরে', 'নিয়ে', 'দ্বারা', 'মাত্র', 'ভাবেই', 'হইবে', 'কোনো', 'জন্যওজে', 'কোটি', 'হইতে', 'কারণে', 'সর্বোচ্চ', 'এর', 'করিয়া', 'ঐ', 'জ্নজন', 'বা', 'সহিত', 'প্রায়', 'বার', 'চান', 'বিষয়টি', 'যাঁরা', 'বলেছেন', 'প্রভৃতি', 'আমার', 'করবেন', 'অধিক', 'হওয়া', 'ধামার', 'তার', 'এমনকী', 'কাজে', 'যাওয়ার', 'বলা', 'কয়েকটি', 'তারৈ', 'যায়', 'কোনও', 'নিয়ে', 'হয়েছে', 'পেয়্র্', 'এদের', 'চালু']
def remove_stopwords(text):
    words = nltk.word_tokenize(text)
    filtered_words = [word for word in words if word not in bn_stopwords]
    return ' '.join(filtered_words)

def remove_non_bangla_words(text):
    return ' '.join([word for word in text.split() if all('ঀ' <= c <= '৿' for c in word)])

def remove_null_characters(text):
    return text.replace('\x00', '')

def remove_urls(text):
    url_pattern = re.compile(r'https?://\S+|www\.\S+')
    return url_pattern.sub(r'', text)

def replace_emojis(text):
    for emoji, meaning in emoji_dict.items():
        text = text.replace(emoji, meaning)
    return text

def remove_bangla_digits(text):
    bangla_digit_pattern = r'[০-৯]'
    text = re.sub(bangla_digit_pattern, '', text)
    return text

def preprocess_text(text):
    text = replace_emojis(text)
    text = remove_stopwords(text)
    text = remove_non_bangla_words(text)
    text = remove_null_characters(text)
    text = remove_urls(text)
    text = remove_bangla_digits(text)
    return text
