**AWSee**
---
---
![AWSee](https://ualter.github.io/awsee-site/images/gif_01.gif)

Command line tool that helps handle multiple AWS Account Credentials (its Roles and MFAs), when working with AWSCLI sessions. 

It opens and controls AWS Sessions using a command-line tool, allowing performing one or all of the following tasks:
- Start session using a MFA Token
- Assume a Role
- Open a session in the same or another terminal window
- Keep track of session information (expiration)
- "Injects" alias/DOSKEY commands in your opened session, that's configurable. Entries in file, examples:
  - alias s3='aws s3 ls'
  - alias info='awsee -i'

Plus, it also tries (if allowed by your AWS Polices) automatically bring and save locally information about your MFA-Devices to be used later on. 

When not possible to retrieve account information automactically (due to security reasons), you still can register it locally using this tool. You can save and keep them updated, to help to deal with your AWS Sessions, like:
- MFA-Devices
- Roles

---

Save and mantain your credential profiles associated with their respective Roles and MFA Devices.
You can use the command "synchronize" to remotely bring this information (if allowed by your AWS Polices), check help documentation.
![AWSee](https://ualter.github.io/awsee-site/images/gif_02.gif)

---
The complete help/manual is available inside the AWSee tool itself, check it out:

```bash

# To show a short version...
$:~ awsee -h

# Show how to use, see below:
$:~ awsee -u
awsee [TOKEN-MFA] [-p profile] [-r role] [-nt or --new-term]
Examples:
  awsee 857946                   Open AWS Session with default profile with your six-digit MFA Token     
  awsee 857946 -p infra          Open AWS Session with the passed profile using your six-digit MFA Token
  awsee 857946 -p infra -r prod  Open AWS Session with the passed profile using your six-digit MFA Token
                                 and immediatelly assume the passed role at this new session
  awsee                          Open AWS Session with default profile, it will check if needs MFA
  awsee -p dev                   Open AWS Session with the passed profile, asks for MFA if needed
  awsee -r developer             Assume a Role inside the current AWS Session
  awsee -p dev  -r developer     Open AWS Session with the passed profile, and following assume the role
  awsee -p prod -r admin         Open AWS Session with the passed profile, and following assume the rol
  awsee -nt or --new-terminal    When opening an AWS Session, will do it in a new terminal
  awsee -h  or --help            Show this and all auxiliary functions (use --help for more information)
  awsee -u  or --usage           Show only how to use, not the auxiliary function
  awsee [FUNCTION]               Execute an auxiliary function, see below for all available options
                                    
# Use the awsee --help to see all the functions and their usage

# More things...
# At the folder ~/.awsee/ you'll find two files that you can customize a few more things:
# ~/.awsee/awsee.ini
### --> Colors on/off
### --> Emoticons on/off
### --> At Windows, the New Terminal to be used (CMD, CMDER or GitBash)
# ~/.awsee/alias/alias_awsee.txt
### --> Add/Remove here your ALIAS/DOSKEYS (Linux/Windows) for new opened sessions, things like:
### ----> DOSKEY ec2=aws ec2 describe-instances --query Reservations[*].Instances[*].InstanceId --output table
### ----> DOSKEY s3=aws s3 ls
### ----> DOSKEY ssmfrodo=aws ssm start-session --target "i-0452a94919225f816"
```

---

For more information and details, check here:

[AWSee](https://ualter.github.io/awsee-site/)