from numpy.linalg import norm
from qmeq.indexing import StateIndexing
from qmeq.leadstun import *

EPS = 1e-14


class ParametersDoubleDotSpinful(object):

    def __init__(self):
        tL, tR = 2.0, 1.0
        self.tleads = {(0,0): tL, (2,2): tL,
                       (1,1): tR, (3,3): tR,
                       (0,1): 0.3*tL, (2,3): 0.3*tL,
                       (1,0): 0.1*tR, (3,2): 0.1*tR}
        e1, e2, omega = 0.0, 0.0, 20.0
        self.hsingle = {(0,0):e1, (2,2):e1,
                        (1,1):e2, (3,3):e2,
                        (0,1):omega, (2,3):omega}
        uintra, uinter = 80.0, 40.0
        self.coulomb = {(0,2,2,0):uintra, (1,3,3,1):uintra,
                        (0,1,1,0):uinter, (0,3,3,0):uinter,
                        (1,2,2,1):uinter, (2,3,3,2):uinter}
        self.vecs = {'Lin':    [np.array([[1.0]]), np.array([[-0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.0, -0.7071067811865475, 0.7071067811865475, 0.0], [0.0, 0.7071067811865475, 0.7071067811865475, 0.0]]), np.array([[0.0, 1.0, 0.0, 0.0, 0.0, 0.0], [0.37174803446018445, 0.0, 0.0, 0.0, -0.7071067811865476, -0.6015009550075454], [-0.6015009550075456, 0.0, 0.0, -0.7071067811865475, 0.0, -0.37174803446018434], [-0.6015009550075456, 0.0, 0.0, 0.7071067811865476, 0.0, -0.37174803446018423], [0.37174803446018445, 0.0, 0.0, 0.0, 0.7071067811865476, -0.6015009550075455], [0.0, 0.0, 1.0, 0.0, 0.0, 0.0]]), np.array([[-0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.0, -0.7071067811865475, 0.7071067811865475, 0.0], [0.0, 0.7071067811865475, 0.7071067811865475, 0.0]]), np.array([[1.0]])],
                     'charge': [np.array([[1.0]]), np.array([[-0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.0, -0.7071067811865475, 0.7071067811865475, 0.0], [0.0, 0.7071067811865475, 0.7071067811865475, 0.0]]), np.array([[0.0, 1.0, 0.0, 0.0, 0.0, 0.0], [0.37174803446018445, 0.0, 0.0, 0.0, -0.7071067811865476, -0.6015009550075454], [-0.6015009550075456, 0.0, 0.0, -0.7071067811865475, 0.0, -0.37174803446018434], [-0.6015009550075456, 0.0, 0.0, 0.7071067811865476, 0.0, -0.37174803446018423], [0.37174803446018445, 0.0, 0.0, 0.0, 0.7071067811865476, -0.6015009550075455], [0.0, 0.0, 1.0, 0.0, 0.0, 0.0]]), np.array([[-0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.7071067811865475, 0.0, 0.0, 0.7071067811865475], [0.0, -0.7071067811865475, 0.7071067811865475, 0.0], [0.0, 0.7071067811865475, 0.7071067811865475, 0.0]]), np.array([[1.0]])],
                     'sz':     [[np.array([[1.0]])], [np.array([[-0.7071067811865475, 0.7071067811865475], [0.7071067811865475, 0.7071067811865475]]), np.array([[-0.7071067811865475, 0.7071067811865475], [0.7071067811865475, 0.7071067811865475]])], [np.array([[1.0]]), np.array([[0.37174803446018445, 0.0, -0.7071067811865476, -0.6015009550075454], [-0.6015009550075456, -0.7071067811865475, 0.0, -0.37174803446018434], [-0.6015009550075456, 0.7071067811865476, 0.0, -0.37174803446018423], [0.37174803446018445, 0.0, 0.7071067811865476, -0.6015009550075455]]), np.array([[1.0]])], [np.array([[-0.7071067811865475, 0.7071067811865475], [0.7071067811865475, 0.7071067811865475]]), np.array([[-0.7071067811865475, 0.7071067811865475], [0.7071067811865475, 0.7071067811865475]])], [np.array([[1.0]])]],
                     'ssq':    [[[np.array([[1.0]])]], [[np.array([[-0.7071067811865475, 0.7071067811865475], [0.7071067811865475, 0.7071067811865475]])], [np.array([[-0.7071067811865475, 0.7071067811865475], [0.7071067811865475, 0.7071067811865475]])]], [[np.array([[1.0]])], [np.array([[0.37174803446018434, -0.7071067811865475, -0.6015009550075459], [-0.6015009550075456, 0.0, -0.3717480344601844], [-0.6015009550075456, 0.0, -0.3717480344601844], [0.3717480344601844, 0.707106781186548, -0.6015009550075456]]), np.array([[0.0], [-0.7071067811865475], [0.7071067811865475], [0.0]])], [np.array([[1.0]])]], [[np.array([[-0.7071067811865475, 0.7071067811865475], [0.7071067811865475, 0.7071067811865475]])], [np.array([[0.7071067811865475, -0.7071067811865475], [-0.7071067811865475, -0.7071067811865475]])]], [[np.array([[1.0]])]]]}


def test_construct_Tba():
    data = {'Lin': [[[0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0], [0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0], [0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0], [0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0], [2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0], [0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0], [0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0], [0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0], [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0], [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0], [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1], [0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0], [0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0], [0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0], [0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0]], [[0.0, 0.6, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 2.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 2.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 2.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -0.6, 0.0]], [[0.0, 1.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.1, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.1, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.1, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.1], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, -1.0, 0.0]]],
            'charge': [[[0.0, 0.0, 0.0, 0.6, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 2.0, 0.0, 0.0, 0.0], [0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0], [0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0], [0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0], [0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0], [0.0, 0.0, 0.0, 2.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0], [0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -0.6, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 1.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0], [0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.1, 0.0, 0.0, 0.0], [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0], [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0], [0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0], [0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0], [0.0, 0.0, 0.0, 0.1, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1], [0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, -1.0, 0.0, 0.0, 0.0]], [[0.0, 0.6, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 2.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 2.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 2.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -0.6, 0.0]], [[0.0, 1.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.1, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.1, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.1, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.1], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, -1.0, 0.0]]],
            'sz': [[[0.0, 0.0, 0.0, 0.6, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 2.0, 0.0, 0.0, 0.0], [0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0], [0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0], [0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0], [0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0], [0.0, 0.0, 0.0, 2.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0], [0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -0.6, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 1.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0], [0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.1, 0.0, 0.0, 0.0], [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0], [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0], [0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0], [0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0], [0.0, 0.0, 0.0, 0.1, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1], [0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, -1.0, 0.0, 0.0, 0.0]], [[0.0, 0.6, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 2.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 2.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 2.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -0.6, 0.0]], [[0.0, 1.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.1, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.1, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.1, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.1], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, -1.0, 0.0]]],
            'ssq': [[[0.0, 0.0, 0.0, 0.6, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 2.0, 0.0, 0.0, 0.0], [0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0], [0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0], [0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0], [0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0], [0.0, 0.0, 0.0, 2.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0], [0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -0.6, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, 1.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0], [0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.1, 0.0, 0.0, 0.0], [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0], [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0], [0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0], [0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0], [0.0, 0.0, 0.0, 0.1, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1], [0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, -1.0, 0.0, 0.0, 0.0]], [[0.0, 0.6, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.6, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.0, 0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 2.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 2.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.0, 2.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, -0.6], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -0.6, 0.0]], [[0.0, 1.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.1, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.1, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, -0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.1, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.1], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.0, -1.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, -1.0, 0.0]]]}
    p = ParametersDoubleDotSpinful()
    for indexing in ['Lin', 'charge', 'sz', 'ssq']:
        si = StateIndexing(4, indexing=indexing)
        leads = LeadsTunneling(4, {}, si, {}, {}, {})
        Tba = construct_Tba(leads, p.tleads)
        assert Tba.tolist() == data[indexing]


def test_construct_full_pmtr():
    data = {'Lin':    np.array([[1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, -0.7071067811865475, 0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.37174803446018445, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865476, 0.0, -0.6015009550075454, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.6015009550075456, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.0, 0.0, -0.37174803446018434, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.0], [0.0, 0.0, 0.7071067811865475, 0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.6015009550075456, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865476, 0.0, 0.0, -0.37174803446018423, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.37174803446018445, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865476, 0.0, -0.6015009550075455, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.0, 0.7071067811865475, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.0, 0.7071067811865475, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0]]),
            'charge': np.array([[1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.7071067811865475, 0.0, 0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.7071067811865475, 0.0, 0.0, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.37174803446018445, 0.0, 0.0, 0.0, -0.7071067811865476, -0.6015009550075454, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.6015009550075456, 0.0, 0.0, -0.7071067811865475, 0.0, -0.37174803446018434, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.6015009550075456, 0.0, 0.0, 0.7071067811865476, 0.0, -0.37174803446018423, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.37174803446018445, 0.0, 0.0, 0.0, 0.7071067811865476, -0.6015009550075455, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.0, 0.0, 0.7071067811865475, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.0, 0.0, 0.7071067811865475, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0]]),
            'sz':     np.array([[1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.37174803446018445, 0.0, -0.7071067811865476, -0.6015009550075454, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6015009550075456, -0.7071067811865475, 0.0, -0.37174803446018434, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6015009550075456, 0.7071067811865476, 0.0, -0.37174803446018423, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.37174803446018445, 0.0, 0.7071067811865476, -0.6015009550075455, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.7071067811865475, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.7071067811865475, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0]]),
            'ssq':    np.array([[1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.37174803446018434, -0.7071067811865475, -0.6015009550075459, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6015009550075456, 0.0, -0.3717480344601844, -0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6015009550075456, 0.0, -0.3717480344601844, 0.7071067811865475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.3717480344601844, 0.707106781186548, -0.6015009550075456, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, 0.7071067811865475, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7071067811865475, -0.7071067811865475, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7071067811865475, -0.7071067811865475, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0]])}
    p = ParametersDoubleDotSpinful()
    for indexing in ['Lin', 'charge', 'sz', 'ssq']:
        si = StateIndexing(4, indexing=indexing)
        Pmtr = construct_full_pmtr(p.vecs[indexing], si)
        assert norm(Pmtr - data[indexing]) < EPS


def test_rotate_Tba():
    data = {'Lin':    [[[0.0, 0.0, 0.9899494936611665, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.9634673443298214, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3, 1.3, 0.0, -0.2274437873630345, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.9634673443298213, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.4223956051027782, 0.0, 0.0, -1.7892964966125253, 0.0, -0.2274437873630344, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0], [0.0, 0.0, -1.8384776310850235, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235], [0.0, 0.0, 0.0, -0.42239560510277824, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, 0.7, 0.0, -1.7892964966125247, 0.0, 0.0, 0.0], [0.0, -1.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, 0.0, 0.0, -0.7, 0.0, -1.3, 0.0, 0.0], [0.0, 1.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, 0.0, 0.0, 0.7, 0.0, -1.3, 0.0, 0.0], [0.0, 0.0, 0.0, -1.7892964966125255, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, 0.7, 0.0, 0.4223956051027781, 0.0, 0.0, 0.0], [0.0, -0.22744378736303472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.7892964966125247, 0.0, 0.0, 0.42239560510277796, 0.0, -0.9634673443298212, 0.0, 0.0], [0.0, 0.0, 0.0, -0.2274437873630345, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3, -1.3, 0.0, -0.963467344329821, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0]], [[0.0, 0.0, -0.6363961030678927, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.619371864212028, 0.0, 0.0, 0.0, 0.0, 0.0, -0.55, 0.55, 0.0, 0.14621386330480773, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.619371864212028, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809844, 0.0, 0.0, -0.7570100562591453, 0.0, 0.14621386330480785, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0], [0.0, 0.0, -0.7778174593052022, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022], [0.0, 0.0, 0.0, -0.17870583292809847, 0.0, 0.0, 0.0, 0.0, 0.0, -0.45, -0.45, 0.0, -0.7570100562591451, 0.0, 0.0, 0.0], [0.0, -0.55, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.45, 0.0, 0.0, 0.45, 0.0, -0.55, 0.0, 0.0], [0.0, 0.55, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.45, 0.0, 0.0, -0.45, 0.0, -0.55, 0.0, 0.0], [0.0, 0.0, 0.0, -0.7570100562591453, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, -0.45, 0.0, 0.17870583292809855, 0.0, 0.0, 0.0], [0.0, 0.1462138633048077, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7570100562591451, 0.0, 0.0, 0.17870583292809855, 0.0, 0.6193718642120277, 0.0, 0.0], [0.0, 0.0, 0.0, 0.1462138633048078, 0.0, 0.0, 0.0, 0.0, 0.0, -0.55, -0.55, 0.0, 0.6193718642120278, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0]], [[0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.9634673443298214, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3, -1.3, 0.0, 0.2274437873630344, 0.0, 0.0, 0.0], [0.0, 0.0, -0.9634673443298214, 0.0, 0.4223956051027782, 0.0, 0.0, 1.789296496612525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.22744378736303444, 0.0], [0.0, 0.0, 0.0, 0.42239560510277824, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, -0.7, 0.0, 1.7892964966125247, 0.0, 0.0, 0.0], [0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 1.8384776310850235, 0.0, 0.0], [0.0, 0.0, 0.0, 1.7892964966125255, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, -0.7, 0.0, -0.4223956051027783, 0.0, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, -1.3, 0.0, 0.7, 0.0, 0.0, -0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3, 0.0], [0.0, 0.0, -1.3, 0.0, -0.7, 0.0, 0.0, -0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.3, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235], [0.0, 0.0, 0.2274437873630345, 0.0, 1.7892964966125247, 0.0, 0.0, -0.4223956051027782, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9634673443298207, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665], [0.0, 0.0, 0.0, 0.2274437873630345, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3, 1.3, 0.0, 0.9634673443298208, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.9899494936611665, 0.0, 0.0]], [[0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.619371864212028, 0.0, 0.0, 0.0, 0.0, 0.0, -0.55, -0.55, 0.0, -0.1462138633048078, 0.0, 0.0, 0.0], [0.0, 0.0, 0.619371864212028, 0.0, 0.17870583292809844, 0.0, 0.0, 0.7570100562591453, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1462138633048078, 0.0], [0.0, 0.0, 0.0, 0.17870583292809847, 0.0, 0.0, 0.0, 0.0, 0.0, -0.45, 0.45, 0.0, 0.757010056259145, 0.0, 0.0, 0.0], [0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.7778174593052022, 0.0, 0.0], [0.0, 0.0, 0.0, 0.7570100562591453, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, 0.45, 0.0, -0.17870583292809847, 0.0, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, -0.55, 0.0, -0.45, 0.0, 0.0, 0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.55, 0.0], [0.0, 0.0, -0.55, 0.0, 0.45, 0.0, 0.0, 0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.55, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022], [0.0, 0.0, -0.14621386330480782, 0.0, 0.757010056259145, 0.0, 0.0, -0.17870583292809844, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6193718642120278, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927], [0.0, 0.0, 0.0, -0.1462138633048078, 0.0, 0.0, 0.0, 0.0, 0.0, -0.55, 0.55, 0.0, -0.6193718642120278, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, -0.6363961030678927, 0.0, 0.0]]],
            'charge': [[[0.0, 0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.9634673443298214, 0.0, 0.0, -1.3, 1.3, -0.2274437873630345, 0.0, 0.0, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.42239560510277824, 0.0, 0.0, 0.7, 0.7, -1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.9634673443298214, 0.0, 0.0, -0.42239560510277824, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.7892964966125253, -0.2274437873630344, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 1.8384776310850235, 0.0], [0.0, 0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -1.3, 0.0, 0.0, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, -1.3, 0.0, 0.0], [0.0, 1.3, 0.0, 0.0, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, -1.3, 0.0, 0.0], [0.0, -0.2274437873630345, 0.0, 0.0, -1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.42239560510277796, -0.9634673443298212, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235], [0.0, 0.0, 0.0, 0.0, 0.0, -1.7892964966125253, 0.0, 0.0, -0.7, 0.7, 0.42239560510277796, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.2274437873630344, 0.0, 0.0, -1.3, -1.3, -0.9634673443298212, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.9899494936611665, 0.0]], [[0.0, 0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.619371864212028, 0.0, 0.0, -0.55, 0.55, 0.14621386330480773, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809847, 0.0, 0.0, -0.45, -0.45, -0.7570100562591451, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.619371864212028, 0.0, 0.0, -0.17870583292809847, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7570100562591453, 0.14621386330480785, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.7778174593052022, 0.0], [0.0, 0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.55, 0.0, 0.0, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, -0.55, 0.0, 0.0], [0.0, 0.55, 0.0, 0.0, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.45, -0.55, 0.0, 0.0], [0.0, 0.14621386330480773, 0.0, 0.0, -0.7570100562591451, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17870583292809855, 0.6193718642120277, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022], [0.0, 0.0, 0.0, 0.0, 0.0, -0.7570100562591453, 0.0, 0.0, 0.45, -0.45, 0.17870583292809855, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.14621386330480785, 0.0, 0.0, -0.55, -0.55, 0.6193718642120277, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, -0.6363961030678927, 0.0]], [[0.0, 0.9899494936611665, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.9634673443298214, 0.0, 0.0, -1.3, -1.3, 0.2274437873630344, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.42239560510277824, 0.0, 0.0, 0.7, -0.7, 1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, -0.9634673443298214, 0.42239560510277824, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, 0.0, 0.0, 0.22744378736303444, 0.0], [0.0, -1.8384776310850235, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0], [0.0, 0.0, -1.3, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, 0.0, 0.0, -1.3, 0.0], [0.0, 0.0, -1.3, -0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, 0.0, 0.0, 1.3, 0.0], [0.0, 0.0, 0.2274437873630344, 1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.4223956051027782, 0.0, 0.0, 0.9634673443298207, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, 0.0, 0.0, -0.7, -0.7, -0.4223956051027782, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665], [0.0, 0.0, 0.0, 0.0, 0.0, 0.22744378736303444, 0.0, 0.0, -1.3, 1.3, 0.9634673443298207, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0]], [[0.0, -0.6363961030678927, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.619371864212028, 0.0, 0.0, -0.55, -0.55, -0.1462138633048078, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.17870583292809847, 0.0, 0.0, -0.45, 0.45, 0.757010056259145, 0.0, 0.0, 0.0, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.619371864212028, 0.17870583292809847, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, 0.0, 0.0, -0.1462138633048078, 0.0], [0.0, -0.7778174593052022, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0], [0.0, 0.0, -0.55, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, 0.0, 0.0, -0.55, 0.0], [0.0, 0.0, -0.55, 0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, 0.0, 0.0, 0.55, 0.0], [0.0, 0.0, -0.1462138633048078, 0.757010056259145, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809844, 0.0, 0.0, -0.6193718642120278, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, 0.0, 0.0, 0.45, 0.45, -0.17870583292809844, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927], [0.0, 0.0, 0.0, 0.0, 0.0, -0.1462138633048078, 0.0, 0.0, -0.55, 0.55, -0.6193718642120278, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0]]],
            'sz':     [[[0.0, 0.0, 0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9634673443298214, -1.3, 1.3, -0.2274437873630345, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.42239560510277824, 0.7, 0.7, -1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0, 0.0], [0.0, 0.9634673443298214, -0.42239560510277824, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.7892964966125253, -0.2274437873630344, 0.0], [0.0, -1.3, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, -1.3, 0.0], [0.0, 1.3, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, -1.3, 0.0], [0.0, -0.2274437873630345, -1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.42239560510277796, -0.9634673443298212, 0.0], [0.0, 0.0, 0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235], [0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.7892964966125253, -0.7, 0.7, 0.42239560510277796, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.2274437873630344, -1.3, -1.3, -0.9634673443298212, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.619371864212028, -0.55, 0.55, 0.14621386330480773, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809847, -0.45, -0.45, -0.7570100562591451, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0, 0.0], [0.0, -0.619371864212028, -0.17870583292809847, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7570100562591453, 0.14621386330480785, 0.0], [0.0, -0.55, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, -0.55, 0.0], [0.0, 0.55, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.45, -0.55, 0.0], [0.0, 0.14621386330480773, -0.7570100562591451, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17870583292809855, 0.6193718642120277, 0.0], [0.0, 0.0, 0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022], [0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7570100562591453, 0.45, -0.45, 0.17870583292809855, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.14621386330480785, -0.55, -0.55, 0.6193718642120277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0, 0.0]], [[0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9634673443298214, -1.3, -1.3, 0.2274437873630344, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.42239560510277824, 0.7, -0.7, 1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.9634673443298214, 0.42239560510277824, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, 0.22744378736303444, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -1.3, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, -1.3, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -1.3, -0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, 1.3, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.2274437873630344, 1.7892964966125247, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.4223956051027782, 0.9634673443298207, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 1.8384776310850235, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, -0.7, -0.7, -0.4223956051027782, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.22744378736303444, -1.3, 1.3, 0.9634673443298207, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.9899494936611665, 0.0]], [[0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.619371864212028, -0.55, -0.55, -0.1462138633048078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17870583292809847, -0.45, 0.45, 0.757010056259145, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.619371864212028, 0.17870583292809847, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, -0.1462138633048078, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.55, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, -0.55, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.55, 0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, 0.55, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.1462138633048078, 0.757010056259145, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809844, -0.6193718642120278, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.7778174593052022, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, 0.45, 0.45, -0.17870583292809844, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.1462138633048078, -0.55, 0.55, -0.6193718642120278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, -0.6363961030678927, 0.0]]],
            'ssq':    [[[0.0, 0.0, 0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9634673443298214, 1.3, -0.22744378736303428, -1.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.4223956051027784, 0.7, -1.789296496612525, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0, 0.0], [0.0, 0.9634673443298214, -0.4223956051027784, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, 0.2274437873630345, 0.0], [0.0, 1.3, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, 1.3, 0.0], [0.0, -0.22744378736303428, -1.789296496612525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.4223956051027786, 0.9634673443298214, 0.0], [0.0, -1.3, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7, 1.3, 0.0], [0.0, 0.0, 0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235], [0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, -0.7, -0.4223956051027786, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.2274437873630345, 1.3, 0.9634673443298214, 1.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0, 0.0]], [[0.0, 0.0, 0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.619371864212028, 0.55, 0.146213863304808, -0.55, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809852, -0.45, -0.7570100562591454, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0, 0.0], [0.0, -0.619371864212028, -0.17870583292809852, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, -0.14621386330480785, 0.0], [0.0, 0.55, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, 0.55, 0.0], [0.0, 0.146213863304808, -0.7570100562591454, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809852, -0.6193718642120278, 0.0], [0.0, -0.55, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.45, 0.55, 0.0], [0.0, 0.0, 0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022], [0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, 0.45, -0.17870583292809852, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.14621386330480785, 0.55, -0.6193718642120278, 0.55, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0, 0.0]], [[0.0, 0.9899494936611665, 1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.9899494936611665, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.8384776310850235, 0.0, 0.0, 0.0, 0.0, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9634673443298214, -1.3, 0.22744378736303428, -1.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.4223956051027784, -0.7, 1.789296496612525, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -1.8384776310850235, 0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.9634673443298214, 0.4223956051027784, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, 0.22744378736303444, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -1.3, -0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, 1.3, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.22744378736303428, 1.789296496612525, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.42239560510277857, 0.9634673443298214, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -1.3, 0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7, -1.3, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9899494936611665, -1.8384776310850235, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.789296496612525, -0.7, -0.42239560510277857, -0.7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.22744378736303444, 1.3, 0.9634673443298214, -1.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.9899494936611665, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.8384776310850235, 0.0, 0.0, 0.0, 0.0, -0.9899494936611665], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.8384776310850235, -0.9899494936611665, 0.0]], [[0.0, -0.6363961030678927, 0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.6363961030678927, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.7778174593052022, 0.0, 0.0, 0.0, 0.0, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.619371864212028, -0.55, -0.146213863304808, -0.55, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.17870583292809852, 0.45, 0.7570100562591454, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.7778174593052022, -0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.619371864212028, 0.17870583292809852, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, -0.14621386330480785, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.55, 0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, 0.55, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.146213863304808, 0.7570100562591454, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.17870583292809855, -0.6193718642120278, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, -0.55, -0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.45, -0.55, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6363961030678927, -0.7778174593052022, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7570100562591453, 0.45, -0.17870583292809855, 0.45, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.14621386330480785, 0.55, -0.6193718642120278, -0.55, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6363961030678927, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.7778174593052022, 0.0, 0.0, 0.0, 0.0, 0.6363961030678927], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7778174593052022, 0.6363961030678927, 0.0]]]}
    p = ParametersDoubleDotSpinful()
    for indexing in ['Lin', 'charge', 'sz', 'ssq']:  # 'Lin', 'charge', 'sz', 'ssq'
        si = StateIndexing(4, indexing=indexing)
        leads = LeadsTunneling(4, {}, si, {}, {}, {})
        Tba0 = construct_Tba(leads, p.tleads)
        Tba = rotate_Tba(Tba0, p.vecs[indexing], si)
        assert norm(Tba - data[indexing]) < EPS


def test_make_tleads_mtr_and_dict():
    nsingle = 4
    nleads = 4
    si = StateIndexing(nsingle)
    si.nleads = nleads
    #
    tL, tR = 2.0, 1.0
    tleads_dict = {(0,0): tL, (2,2): tL, (1,1): tR, (3,3): tR, (0,1): 0.3*tL, (2,3): 0.3*tL, (1,0): 0.1*tR, (3,2): 0.1*tR}
    tleads_list = [[0,0,tL], [2,2,tL], [1,1,tR], [3,3,tR], [0,1,0.3*tL], [2,3,0.3*tL], [1,0,0.1*tR], [3,2,0.1*tR]]
    tleads_mtr = [[tL, 0.3*tL, 0.0, 0.0], [0.1*tR, tR, 0.0, 0.0], [0.0, 0.0, tL, 0.3*tL], [0.0, 0.0, 0.1*tR, tR]]
    assert make_tleads_mtr(tleads_dict, nleads, nsingle, mtype=float).tolist()  == tleads_mtr
    assert make_tleads_mtr(tleads_list, nleads, nsingle, mtype=float).tolist()  == tleads_mtr
    assert make_tleads_dict(tleads_list, si) == tleads_dict
    assert make_tleads_dict(np.array(tleads_mtr), si) == tleads_dict
    assert make_tleads_dict(tleads_dict, si) == tleads_dict


def test_make_array():
    si = StateIndexing(0)
    si.nleads = 7
    si.nleads_sym = 7
    assert make_array(None, {0:0.3, 1:0.2, 2:0.1, 3:0.01, 6:1.0}, si).tolist() == [0.3, 0.2, 0.1, 0.01, 0., 0., 1.]
    assert make_array(None, 2, si).tolist() == [2, 2, 2, 2, 2, 2, 2]
    assert make_array_dlst(None, {0:0.3, 1:0.2, 2:0.1, 3:0.01, 6:1.0}, si).tolist() == [[-0.3,0.3], [-0.2,0.2], [-0.1,0.1], [-0.01,0.01], [0.,0.], [0.,0.], [-1.,1.]]


def test_LeadsTunneling():
    nsingle = 2
    nleads = 4
    t0, vbias, temp, dband = 0.1, 0.5, 1.0, 60.0
    mulst = {0: vbias/2, 1: -vbias/2, 2: vbias/2, 3: -vbias/2}
    tlst  = {0: temp,    1: temp,     2: temp,    3: temp}
    dlst  = {0: dband,   1: dband,    2: dband,   3: dband}
    tleads = np.array([[t0,0], [t0,0], [0,t0], [0,t0]])
    si = StateIndexing(nsingle)
    leads = LeadsTunneling(nleads, tleads, si, mulst, tlst, dlst)
    #
    assert leads.tleads == {(0,0):t0, (1,0):t0, (2,1):t0, (3,1):t0}
    assert leads.si.nleads == 4
    assert leads.mulst.tolist() == [vbias/2, -vbias/2, vbias/2, -vbias/2]
    assert leads.tlst.tolist() == [temp, temp, temp, temp]
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-dband,dband], [-dband,dband]]
    #
    leads.add(tleads={(0,0):1.0, (1,0):2.0, (2,1):3.0, (3,1):4.0},
              mulst={0:0.1, 1:0.2, 2:0.3, 3:0.4},
              tlst={0:1.0, 1:2.0, 2:3.0, 3:4.0},
              dlst={0:10.0, 1:20.0, 2:30.0, 3:40.0})
    assert leads.tleads == {(0,0):t0+1.0, (1,0):t0+2.0, (2,1):t0+3.0, (3,1):t0+4.0}
    assert leads.mulst.tolist() == [vbias/2+0.1, -vbias/2+0.2, vbias/2+0.3, -vbias/2+0.4]
    assert leads.tlst.tolist() == [temp+1.0, temp+2.0, temp+3.0, temp+4.0]
    assert leads.dlst.tolist() == [[-dband-10.0,dband+10.0], [-dband-20.0,dband+20.0], [-dband-30.0,dband+30.0], [-dband-40.0,dband+40.0]]
    #
    leads.change(tleads={(0,0):t0, (1,0):t0, (2,1):t0, (3,1):t0},
                 mulst=[vbias/2, -vbias/2, vbias/2, -vbias/2],
                 tlst=[temp, temp, temp, temp],
                 dlst=[dband, dband, dband, dband])
    # The change function introduces numerical errors to tleads
    assert norm( make_tleads_mtr(leads.tleads, 4, 2) - make_tleads_mtr({(0,0):t0, (1,0):t0, (2,1):t0, (3,1):t0}, 4, 2) ) < EPS
    assert leads.mulst.tolist() == [vbias/2, -vbias/2, vbias/2, -vbias/2]
    assert leads.tlst.tolist() == [temp, temp, temp, temp]
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-dband,dband], [-dband,dband]]
    #
    leads.change(mulst={0: 1.23}, tlst={1: 2.13}, dlst={2: 3.21})
    assert leads.mulst.tolist() == [1.23, -vbias/2, vbias/2, -vbias/2]
    assert leads.tlst.tolist() == [temp, 2.13, temp, temp]
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-3.21,3.21], [-dband,dband]]
    leads.add(mulst={0: 1.23}, tlst={1: 2.13}, dlst={2: 3.21})
    assert leads.mulst.tolist() == [2*1.23, -vbias/2, vbias/2, -vbias/2]
    assert leads.tlst.tolist() == [temp, 2*2.13, temp, temp]
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-2*3.21,2*3.21], [-dband,dband]]
    #
    leads.change(mulst=1, tlst=2, dlst=3)
    assert leads.mulst.tolist() == [1, 1, 1, 1]
    assert leads.tlst.tolist() == [2, 2, 2, 2]
    assert leads.dlst.tolist() == [[-3,3], [-3,3], [-3,3], [-3,3]]
    leads.change(mulst=[vbias/2, -vbias/2, vbias/2, -vbias/2],
                 tlst=[temp, temp, temp, temp],
                 dlst=[dband, dband, dband, dband])
    leads.add(mulst=1, tlst=2, dlst=3)
    assert leads.mulst.tolist() == [vbias/2+1, -vbias/2+1, vbias/2+1, -vbias/2+1]
    assert leads.tlst.tolist() == [temp+2, temp+2, temp+2, temp+2]
    assert leads.dlst.tolist() == [[-dband-3,dband+3], [-dband-3,dband+3],
                                   [-dband-3,dband+3], [-dband-3,dband+3]]
    #
    leads.change(dlst=dband-10.0)
    leads.add(dlst=10.0)
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-dband,dband], [-dband,dband]]
    leads.change(dlst={0:(1,1), 3:(2,2)})
    assert leads.dlst.tolist() == [[1,1], [-dband,dband], [-dband,dband], [2,2]]
    leads.add(dlst={0:(1,1), 3:(2,2)})
    assert leads.dlst.tolist() == [[2,2], [-dband,dband], [-dband,dband], [4,4]]
    #
    Tba_tmp = np.array(leads.Tba)
    leads.Tba.fill(0.0)
    leads.use_Tba0()
    assert norm(leads.Tba - Tba_tmp) < EPS


def test_LeadsTunneling_spin():
    nsingle = 2
    nleads = 4
    t0, vbias, temp, dband = 0.1, 0.5, 1.0, 60.0
    mulst = {0: vbias/2, 1: -vbias/2}
    tlst  = {0: temp,    1: temp}
    dlst  = {0: dband,   1: dband}
    tleads = np.array([[t0,0], [t0,0]])
    si = StateIndexing(nsingle, symmetry='spin')
    leads = LeadsTunneling(nleads, tleads, si, mulst, tlst, dlst)
    #
    assert leads.tleads == {(0,0):t0, (1,0):t0, (2,1):t0, (3,1):t0}
    assert leads.si.nleads == 4
    assert leads.mulst.tolist() == [vbias/2, -vbias/2, vbias/2, -vbias/2]
    assert leads.tlst.tolist() == [temp, temp, temp, temp]
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-dband,dband], [-dband,dband]]
    #
    leads.add(tleads={(0,0):1.0, (1,0):2.0},
              mulst={0:0.1, 1:0.2},
              tlst={0:1.0, 1:2.0},
              dlst={0:10.0, 1:20.0})
    assert leads.tleads == {(0,0):t0+1.0, (1,0):t0+2.0, (2,1):t0+1.0, (3,1):t0+2.0}
    assert leads.mulst.tolist() == [vbias/2+0.1, -vbias/2+0.2, vbias/2+0.1, -vbias/2+0.2]
    assert leads.tlst.tolist() == [temp+1.0, temp+2.0, temp+1.0, temp+2.0]
    assert leads.dlst.tolist() == [[-dband-10.0,dband+10.0], [-dband-20.0,dband+20.0], [-dband-10.0,dband+10.0], [-dband-20.0,dband+20.0]]
    #
    leads.change(tleads={(0,0):t0, (1,0):t0},
                 mulst=[vbias/2, -vbias/2],
                 tlst=[temp, temp],
                 dlst=[dband, dband])
    # The change function introduces numerical errors to tleads
    assert norm( make_tleads_mtr(leads.tleads, 4, 2) - make_tleads_mtr({(0,0):t0, (1,0):t0, (2,1):t0, (3,1):t0}, 4, 2) ) < EPS
    assert leads.mulst.tolist() == [vbias/2, -vbias/2, vbias/2, -vbias/2]
    assert leads.tlst.tolist() == [temp, temp, temp, temp]
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-dband,dband], [-dband,dband]]
    #
    leads.change(mulst={0: 1.23}, tlst={1: 2.13}, dlst={1: 3.21})
    assert leads.mulst.tolist() == [1.23, -vbias/2, 1.23, -vbias/2]
    assert leads.tlst.tolist() == [temp, 2.13, temp, 2.13]
    assert leads.dlst.tolist() == [[-dband,dband], [-3.21,3.21], [-dband,dband], [-3.21,3.21]]
    leads.add(mulst={0: 1.23}, tlst={1: 2.13}, dlst={1: 3.21})
    assert leads.mulst.tolist() == [2*1.23, -vbias/2, 2*1.23, -vbias/2]
    assert leads.tlst.tolist() == [temp, 2*2.13, temp, 2*2.13]
    assert leads.dlst.tolist() == [[-dband,dband], [-2*3.21,2*3.21], [-dband,dband], [-2*3.21,2*3.21]]
    #
    leads.change(mulst=1, tlst=2, dlst=3)
    assert leads.mulst.tolist() == [1, 1, 1, 1]
    assert leads.tlst.tolist() == [2, 2, 2, 2]
    assert leads.dlst.tolist() == [[-3,3], [-3,3], [-3,3], [-3,3]]
    leads.change(mulst=[vbias/2, -vbias/2],
                 tlst=[temp, temp],
                 dlst=[dband, dband])
    leads.add(mulst=1, tlst=2, dlst=3)
    assert leads.mulst.tolist() == [vbias/2+1, -vbias/2+1, vbias/2+1, -vbias/2+1]
    assert leads.tlst.tolist() == [temp+2, temp+2, temp+2, temp+2]
    assert leads.dlst.tolist() == [[-dband-3,dband+3], [-dband-3,dband+3],
                                   [-dband-3,dband+3], [-dband-3,dband+3]]
    #
    leads.change(dlst=dband-10.0)
    leads.add(dlst=10.0)
    assert leads.dlst.tolist() == [[-dband,dband], [-dband,dband], [-dband,dband], [-dband,dband]]
    leads.change(dlst={0:(1,1), 1:(2,2)})
    assert leads.dlst.tolist() == [[1,1], [2,2], [1,1], [2,2]]
    leads.add(dlst={0:(1,1), 1:(2,2)})
    assert leads.dlst.tolist() == [[2,2], [4,4], [2,2], [4,4]]
    #
    Tba_tmp = np.array(leads.Tba)
    leads.Tba.fill(0.0)
    leads.use_Tba0()
    assert norm(leads.Tba - Tba_tmp) < EPS
