import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProcedureGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of the argument data types for the procedure (must be present if procedure has arguments and procedure_name is present)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#argument_data_types ProcedureGrant#argument_data_types}
    */
    readonly argumentDataTypes?: string[];
    /**
    * The name of the database containing the current or future procedures on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#database_name ProcedureGrant#database_name}
    */
    readonly databaseName: string;
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#enable_multiple_grants ProcedureGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#id ProcedureGrant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When this is set to true and a schema_name is provided, apply this grant on all future procedures in the given schema. When this is true and no schema_name is provided apply this grant on all future procedures in the given database. The procedure_name and shares fields must be unset in order to use on_future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#on_future ProcedureGrant#on_future}
    */
    readonly onFuture?: boolean | cdktf.IResolvable;
    /**
    * The privilege to grant on the current or future procedure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#privilege ProcedureGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * The name of the procedure on which to grant privileges immediately (only valid if on_future is false).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#procedure_name ProcedureGrant#procedure_name}
    */
    readonly procedureName?: string;
    /**
    * The return type of the procedure (must be present if procedure_name is present)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#return_type ProcedureGrant#return_type}
    */
    readonly returnType?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#roles ProcedureGrant#roles}
    */
    readonly roles: string[];
    /**
    * The name of the schema containing the current or future procedures on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#schema_name ProcedureGrant#schema_name}
    */
    readonly schemaName?: string;
    /**
    * Grants privilege to these shares (only valid if on_future is false).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#shares ProcedureGrant#shares}
    */
    readonly shares?: string[];
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#with_grant_option ProcedureGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#arguments ProcedureGrant#arguments}
    */
    readonly arguments?: ProcedureGrantArguments[] | cdktf.IResolvable;
}
export interface ProcedureGrantArguments {
    /**
    * The argument name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#name ProcedureGrant#name}
    */
    readonly name: string;
    /**
    * The argument type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant#type ProcedureGrant#type}
    */
    readonly type: string;
}
export declare function procedureGrantArgumentsToTerraform(struct?: ProcedureGrantArguments | cdktf.IResolvable): any;
export declare class ProcedureGrantArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureGrantArguments | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureGrantArguments | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ProcedureGrantArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureGrantArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureGrantArgumentsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant snowflake_procedure_grant}
*/
export declare class ProcedureGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_procedure_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/procedure_grant snowflake_procedure_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProcedureGrantConfig
    */
    constructor(scope: Construct, id: string, config: ProcedureGrantConfig);
    private _argumentDataTypes?;
    get argumentDataTypes(): string[];
    set argumentDataTypes(value: string[]);
    resetArgumentDataTypes(): void;
    get argumentDataTypesInput(): string[] | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _onFuture?;
    get onFuture(): boolean | cdktf.IResolvable;
    set onFuture(value: boolean | cdktf.IResolvable);
    resetOnFuture(): void;
    get onFutureInput(): boolean | cdktf.IResolvable | undefined;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _procedureName?;
    get procedureName(): string;
    set procedureName(value: string);
    resetProcedureName(): void;
    get procedureNameInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    resetReturnType(): void;
    get returnTypeInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    resetSchemaName(): void;
    get schemaNameInput(): string | undefined;
    private _shares?;
    get shares(): string[];
    set shares(value: string[]);
    resetShares(): void;
    get sharesInput(): string[] | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    private _arguments;
    get arguments(): ProcedureGrantArgumentsList;
    putArguments(value: ProcedureGrantArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | ProcedureGrantArguments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
