"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleOwnershipGrant = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/role_ownership_grant snowflake_role_ownership_grant}
*/
class RoleOwnershipGrant extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/role_ownership_grant snowflake_role_ownership_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleOwnershipGrantConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_role_ownership_grant',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.58.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._currentGrants = config.currentGrants;
        this._id = config.id;
        this._onRoleName = config.onRoleName;
        this._revertOwnershipToRoleName = config.revertOwnershipToRoleName;
        this._toRoleName = config.toRoleName;
    }
    get currentGrants() {
        return this.getStringAttribute('current_grants');
    }
    set currentGrants(value) {
        this._currentGrants = value;
    }
    resetCurrentGrants() {
        this._currentGrants = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get currentGrantsInput() {
        return this._currentGrants;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get onRoleName() {
        return this.getStringAttribute('on_role_name');
    }
    set onRoleName(value) {
        this._onRoleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get onRoleNameInput() {
        return this._onRoleName;
    }
    get revertOwnershipToRoleName() {
        return this.getStringAttribute('revert_ownership_to_role_name');
    }
    set revertOwnershipToRoleName(value) {
        this._revertOwnershipToRoleName = value;
    }
    resetRevertOwnershipToRoleName() {
        this._revertOwnershipToRoleName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get revertOwnershipToRoleNameInput() {
        return this._revertOwnershipToRoleName;
    }
    get toRoleName() {
        return this.getStringAttribute('to_role_name');
    }
    set toRoleName(value) {
        this._toRoleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get toRoleNameInput() {
        return this._toRoleName;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            current_grants: cdktf.stringToTerraform(this._currentGrants),
            id: cdktf.stringToTerraform(this._id),
            on_role_name: cdktf.stringToTerraform(this._onRoleName),
            revert_ownership_to_role_name: cdktf.stringToTerraform(this._revertOwnershipToRoleName),
            to_role_name: cdktf.stringToTerraform(this._toRoleName),
        };
    }
}
exports.RoleOwnershipGrant = RoleOwnershipGrant;
_a = JSII_RTTI_SYMBOL_1;
RoleOwnershipGrant[_a] = { fqn: "@cdktf/provider-snowflake.roleOwnershipGrant.RoleOwnershipGrant", version: "5.0.4" };
// =================
// STATIC PROPERTIES
// =================
RoleOwnershipGrant.tfResourceType = "snowflake_role_ownership_grant";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcm9sZS1vd25lcnNoaXAtZ3JhbnQvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFJQSwrQkFBK0I7QUFzQy9COztFQUVFO0FBQ0YsTUFBYSxrQkFBbUIsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBTzdELGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQWdDO1FBQy9FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsZ0NBQWdDO1lBQ3ZELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsV0FBVztnQkFDekIsZUFBZSxFQUFFLFFBQVE7Z0JBQ3pCLHlCQUF5QixFQUFFLFVBQVU7YUFDdEM7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsWUFBWSxFQUFFLE1BQU0sQ0FBQyxZQUFZO1lBQ2pDLFVBQVUsRUFBRSxNQUFNLENBQUMsVUFBVTtZQUM3QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU87U0FDeEIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxHQUFHLEdBQUcsTUFBTSxDQUFDLEVBQUUsQ0FBQztRQUNyQixJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztRQUNuRSxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7SUFDdkMsQ0FBQztJQVFELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFhO1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFDTSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLGNBQWMsR0FBRyxTQUFTLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUlELElBQVcsRUFBRTtRQUNYLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxJQUFXLEVBQUUsQ0FBQyxLQUFhO1FBQ3pCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFDTSxPQUFPO1FBQ1osSUFBSSxDQUFDLEdBQUcsR0FBRyxTQUFTLENBQUM7SUFDdkIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDO0lBQ2xCLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWE7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO0lBQ2xFLENBQUM7SUFDRCxJQUFXLHlCQUF5QixDQUFDLEtBQWE7UUFDaEQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQztJQUMxQyxDQUFDO0lBQ00sOEJBQThCO1FBQ25DLElBQUksQ0FBQywwQkFBMEIsR0FBRyxTQUFTLENBQUM7SUFDOUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDhCQUE4QjtRQUN2QyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxjQUFjLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDNUQsRUFBRSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1lBQ3JDLFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUN2RCw2QkFBNkIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDO1lBQ3ZGLFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztTQUN4RCxDQUFDO0lBQ0osQ0FBQzs7QUFuSUgsZ0RBb0lDOzs7QUFsSUMsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyxpQ0FBYyxHQUFHLGdDQUFnQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL3JvbGVfb3duZXJzaGlwX2dyYW50XG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgUm9sZU93bmVyc2hpcEdyYW50Q29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB3aGV0aGVyIHRvIHJlbW92ZSBvciB0cmFuc2ZlciBhbGwgZXhpc3Rpbmcgb3V0Ym91bmQgcHJpdmlsZWdlcyBvbiB0aGUgb2JqZWN0IHdoZW4gb3duZXJzaGlwIGlzIHRyYW5zZmVycmVkIHRvIGEgbmV3IHJvbGUuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvc25vd2ZsYWtlL3Ivcm9sZV9vd25lcnNoaXBfZ3JhbnQjY3VycmVudF9ncmFudHMgUm9sZU93bmVyc2hpcEdyYW50I2N1cnJlbnRfZ3JhbnRzfVxuICAqL1xuICByZWFkb25seSBjdXJyZW50R3JhbnRzPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9yb2xlX293bmVyc2hpcF9ncmFudCNpZCBSb2xlT3duZXJzaGlwR3JhbnQjaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBuYW1lIG9mIHRoZSByb2xlIG93bmVyc2hpcCBpcyBncmFudGVkIG9uLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL3JvbGVfb3duZXJzaGlwX2dyYW50I29uX3JvbGVfbmFtZSBSb2xlT3duZXJzaGlwR3JhbnQjb25fcm9sZV9uYW1lfVxuICAqL1xuICByZWFkb25seSBvblJvbGVOYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBuYW1lIG9mIHRoZSByb2xlIHRvIHJldmVydCBvd25lcnNoaXAgdG8gb24gZGVzdHJveS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9yb2xlX293bmVyc2hpcF9ncmFudCNyZXZlcnRfb3duZXJzaGlwX3RvX3JvbGVfbmFtZSBSb2xlT3duZXJzaGlwR3JhbnQjcmV2ZXJ0X293bmVyc2hpcF90b19yb2xlX25hbWV9XG4gICovXG4gIHJlYWRvbmx5IHJldmVydE93bmVyc2hpcFRvUm9sZU5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBuYW1lIG9mIHRoZSByb2xlIHRvIGdyYW50IG93bmVyc2hpcC4gUGxlYXNlIGVuc3VyZSB0aGF0IHRoZSByb2xlIHRoYXQgdGVycmFmb3JtIGlzIHVzaW5nIGlzIGdyYW50ZWQgYWNjZXNzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL3JvbGVfb3duZXJzaGlwX2dyYW50I3RvX3JvbGVfbmFtZSBSb2xlT3duZXJzaGlwR3JhbnQjdG9fcm9sZV9uYW1lfVxuICAqL1xuICByZWFkb25seSB0b1JvbGVOYW1lOiBzdHJpbmc7XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9zbm93Zmxha2Uvci9yb2xlX293bmVyc2hpcF9ncmFudCBzbm93Zmxha2Vfcm9sZV9vd25lcnNoaXBfZ3JhbnR9XG4qL1xuZXhwb3J0IGNsYXNzIFJvbGVPd25lcnNoaXBHcmFudCBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJzbm93Zmxha2Vfcm9sZV9vd25lcnNoaXBfZ3JhbnRcIjtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIC8qKlxuICAqIENyZWF0ZSBhIG5ldyB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3Nub3dmbGFrZS9yL3JvbGVfb3duZXJzaGlwX2dyYW50IHNub3dmbGFrZV9yb2xlX293bmVyc2hpcF9ncmFudH0gUmVzb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgUm9sZU93bmVyc2hpcEdyYW50Q29uZmlnXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IFJvbGVPd25lcnNoaXBHcmFudENvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnc25vd2ZsYWtlX3JvbGVfb3duZXJzaGlwX2dyYW50JyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ3Nub3dmbGFrZScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzAuNTguMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICcgfj4gMC40MCdcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZSxcbiAgICAgIHByb3Zpc2lvbmVyczogY29uZmlnLnByb3Zpc2lvbmVycyxcbiAgICAgIGNvbm5lY3Rpb246IGNvbmZpZy5jb25uZWN0aW9uLFxuICAgICAgZm9yRWFjaDogY29uZmlnLmZvckVhY2hcbiAgICB9KTtcbiAgICB0aGlzLl9jdXJyZW50R3JhbnRzID0gY29uZmlnLmN1cnJlbnRHcmFudHM7XG4gICAgdGhpcy5faWQgPSBjb25maWcuaWQ7XG4gICAgdGhpcy5fb25Sb2xlTmFtZSA9IGNvbmZpZy5vblJvbGVOYW1lO1xuICAgIHRoaXMuX3JldmVydE93bmVyc2hpcFRvUm9sZU5hbWUgPSBjb25maWcucmV2ZXJ0T3duZXJzaGlwVG9Sb2xlTmFtZTtcbiAgICB0aGlzLl90b1JvbGVOYW1lID0gY29uZmlnLnRvUm9sZU5hbWU7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGN1cnJlbnRfZ3JhbnRzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2N1cnJlbnRHcmFudHM/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGN1cnJlbnRHcmFudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjdXJyZW50X2dyYW50cycpO1xuICB9XG4gIHB1YmxpYyBzZXQgY3VycmVudEdyYW50cyh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY3VycmVudEdyYW50cyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEN1cnJlbnRHcmFudHMoKSB7XG4gICAgdGhpcy5fY3VycmVudEdyYW50cyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY3VycmVudEdyYW50c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jdXJyZW50R3JhbnRzO1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SWQoKSB7XG4gICAgdGhpcy5faWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkO1xuICB9XG5cbiAgLy8gb25fcm9sZV9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX29uUm9sZU5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG9uUm9sZU5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdvbl9yb2xlX25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG9uUm9sZU5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX29uUm9sZU5hbWUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgb25Sb2xlTmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9vblJvbGVOYW1lO1xuICB9XG5cbiAgLy8gcmV2ZXJ0X293bmVyc2hpcF90b19yb2xlX25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmV2ZXJ0T3duZXJzaGlwVG9Sb2xlTmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcmV2ZXJ0T3duZXJzaGlwVG9Sb2xlTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JldmVydF9vd25lcnNoaXBfdG9fcm9sZV9uYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCByZXZlcnRPd25lcnNoaXBUb1JvbGVOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXZlcnRPd25lcnNoaXBUb1JvbGVOYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmV2ZXJ0T3duZXJzaGlwVG9Sb2xlTmFtZSgpIHtcbiAgICB0aGlzLl9yZXZlcnRPd25lcnNoaXBUb1JvbGVOYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXZlcnRPd25lcnNoaXBUb1JvbGVOYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JldmVydE93bmVyc2hpcFRvUm9sZU5hbWU7XG4gIH1cblxuICAvLyB0b19yb2xlX25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfdG9Sb2xlTmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdG9Sb2xlTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3RvX3JvbGVfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgdG9Sb2xlTmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdG9Sb2xlTmFtZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0b1JvbGVOYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RvUm9sZU5hbWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGN1cnJlbnRfZ3JhbnRzOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jdXJyZW50R3JhbnRzKSxcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBvbl9yb2xlX25hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX29uUm9sZU5hbWUpLFxuICAgICAgcmV2ZXJ0X293bmVyc2hpcF90b19yb2xlX25hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3JldmVydE93bmVyc2hpcFRvUm9sZU5hbWUpLFxuICAgICAgdG9fcm9sZV9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl90b1JvbGVOYW1lKSxcbiAgICB9O1xuICB9XG59XG4iXX0=