"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration}
*/
class SamlIntegration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIntegrationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_saml_integration',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.58.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._enabled = config.enabled;
        this._id = config.id;
        this._name = config.name;
        this._saml2EnableSpInitiated = config.saml2EnableSpInitiated;
        this._saml2ForceAuthn = config.saml2ForceAuthn;
        this._saml2Issuer = config.saml2Issuer;
        this._saml2PostLogoutRedirectUrl = config.saml2PostLogoutRedirectUrl;
        this._saml2Provider = config.saml2Provider;
        this._saml2RequestedNameidFormat = config.saml2RequestedNameidFormat;
        this._saml2SignRequest = config.saml2SignRequest;
        this._saml2SnowflakeAcsUrl = config.saml2SnowflakeAcsUrl;
        this._saml2SnowflakeIssuerUrl = config.saml2SnowflakeIssuerUrl;
        this._saml2SnowflakeX509Cert = config.saml2SnowflakeX509Cert;
        this._saml2SpInitiatedLoginPageLabel = config.saml2SpInitiatedLoginPageLabel;
        this._saml2SsoUrl = config.saml2SsoUrl;
        this._saml2X509Cert = config.saml2X509Cert;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // saml2_digest_methods_used - computed: true, optional: false, required: false
    get saml2DigestMethodsUsed() {
        return this.getStringAttribute('saml2_digest_methods_used');
    }
    get saml2EnableSpInitiated() {
        return this.getBooleanAttribute('saml2_enable_sp_initiated');
    }
    set saml2EnableSpInitiated(value) {
        this._saml2EnableSpInitiated = value;
    }
    resetSaml2EnableSpInitiated() {
        this._saml2EnableSpInitiated = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2EnableSpInitiatedInput() {
        return this._saml2EnableSpInitiated;
    }
    get saml2ForceAuthn() {
        return this.getBooleanAttribute('saml2_force_authn');
    }
    set saml2ForceAuthn(value) {
        this._saml2ForceAuthn = value;
    }
    resetSaml2ForceAuthn() {
        this._saml2ForceAuthn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ForceAuthnInput() {
        return this._saml2ForceAuthn;
    }
    get saml2Issuer() {
        return this.getStringAttribute('saml2_issuer');
    }
    set saml2Issuer(value) {
        this._saml2Issuer = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2IssuerInput() {
        return this._saml2Issuer;
    }
    get saml2PostLogoutRedirectUrl() {
        return this.getStringAttribute('saml2_post_logout_redirect_url');
    }
    set saml2PostLogoutRedirectUrl(value) {
        this._saml2PostLogoutRedirectUrl = value;
    }
    resetSaml2PostLogoutRedirectUrl() {
        this._saml2PostLogoutRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2PostLogoutRedirectUrlInput() {
        return this._saml2PostLogoutRedirectUrl;
    }
    get saml2Provider() {
        return this.getStringAttribute('saml2_provider');
    }
    set saml2Provider(value) {
        this._saml2Provider = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ProviderInput() {
        return this._saml2Provider;
    }
    get saml2RequestedNameidFormat() {
        return this.getStringAttribute('saml2_requested_nameid_format');
    }
    set saml2RequestedNameidFormat(value) {
        this._saml2RequestedNameidFormat = value;
    }
    resetSaml2RequestedNameidFormat() {
        this._saml2RequestedNameidFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2RequestedNameidFormatInput() {
        return this._saml2RequestedNameidFormat;
    }
    get saml2SignRequest() {
        return this.getBooleanAttribute('saml2_sign_request');
    }
    set saml2SignRequest(value) {
        this._saml2SignRequest = value;
    }
    resetSaml2SignRequest() {
        this._saml2SignRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SignRequestInput() {
        return this._saml2SignRequest;
    }
    // saml2_signature_methods_used - computed: true, optional: false, required: false
    get saml2SignatureMethodsUsed() {
        return this.getStringAttribute('saml2_signature_methods_used');
    }
    get saml2SnowflakeAcsUrl() {
        return this.getStringAttribute('saml2_snowflake_acs_url');
    }
    set saml2SnowflakeAcsUrl(value) {
        this._saml2SnowflakeAcsUrl = value;
    }
    resetSaml2SnowflakeAcsUrl() {
        this._saml2SnowflakeAcsUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeAcsUrlInput() {
        return this._saml2SnowflakeAcsUrl;
    }
    get saml2SnowflakeIssuerUrl() {
        return this.getStringAttribute('saml2_snowflake_issuer_url');
    }
    set saml2SnowflakeIssuerUrl(value) {
        this._saml2SnowflakeIssuerUrl = value;
    }
    resetSaml2SnowflakeIssuerUrl() {
        this._saml2SnowflakeIssuerUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeIssuerUrlInput() {
        return this._saml2SnowflakeIssuerUrl;
    }
    // saml2_snowflake_metadata - computed: true, optional: false, required: false
    get saml2SnowflakeMetadata() {
        return this.getStringAttribute('saml2_snowflake_metadata');
    }
    get saml2SnowflakeX509Cert() {
        return this.getStringAttribute('saml2_snowflake_x509_cert');
    }
    set saml2SnowflakeX509Cert(value) {
        this._saml2SnowflakeX509Cert = value;
    }
    resetSaml2SnowflakeX509Cert() {
        this._saml2SnowflakeX509Cert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeX509CertInput() {
        return this._saml2SnowflakeX509Cert;
    }
    get saml2SpInitiatedLoginPageLabel() {
        return this.getStringAttribute('saml2_sp_initiated_login_page_label');
    }
    set saml2SpInitiatedLoginPageLabel(value) {
        this._saml2SpInitiatedLoginPageLabel = value;
    }
    resetSaml2SpInitiatedLoginPageLabel() {
        this._saml2SpInitiatedLoginPageLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SpInitiatedLoginPageLabelInput() {
        return this._saml2SpInitiatedLoginPageLabel;
    }
    get saml2SsoUrl() {
        return this.getStringAttribute('saml2_sso_url');
    }
    set saml2SsoUrl(value) {
        this._saml2SsoUrl = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SsoUrlInput() {
        return this._saml2SsoUrl;
    }
    get saml2X509Cert() {
        return this.getStringAttribute('saml2_x509_cert');
    }
    set saml2X509Cert(value) {
        this._saml2X509Cert = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2X509CertInput() {
        return this._saml2X509Cert;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enabled: cdktf.booleanToTerraform(this._enabled),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            saml2_enable_sp_initiated: cdktf.booleanToTerraform(this._saml2EnableSpInitiated),
            saml2_force_authn: cdktf.booleanToTerraform(this._saml2ForceAuthn),
            saml2_issuer: cdktf.stringToTerraform(this._saml2Issuer),
            saml2_post_logout_redirect_url: cdktf.stringToTerraform(this._saml2PostLogoutRedirectUrl),
            saml2_provider: cdktf.stringToTerraform(this._saml2Provider),
            saml2_requested_nameid_format: cdktf.stringToTerraform(this._saml2RequestedNameidFormat),
            saml2_sign_request: cdktf.booleanToTerraform(this._saml2SignRequest),
            saml2_snowflake_acs_url: cdktf.stringToTerraform(this._saml2SnowflakeAcsUrl),
            saml2_snowflake_issuer_url: cdktf.stringToTerraform(this._saml2SnowflakeIssuerUrl),
            saml2_snowflake_x509_cert: cdktf.stringToTerraform(this._saml2SnowflakeX509Cert),
            saml2_sp_initiated_login_page_label: cdktf.stringToTerraform(this._saml2SpInitiatedLoginPageLabel),
            saml2_sso_url: cdktf.stringToTerraform(this._saml2SsoUrl),
            saml2_x509_cert: cdktf.stringToTerraform(this._saml2X509Cert),
        };
    }
}
exports.SamlIntegration = SamlIntegration;
_a = JSII_RTTI_SYMBOL_1;
SamlIntegration[_a] = { fqn: "@cdktf/provider-snowflake.samlIntegration.SamlIntegration", version: "5.0.4" };
// =================
// STATIC PROPERTIES
// =================
SamlIntegration.tfResourceType = "snowflake_saml_integration";
//# sourceMappingURL=data:application/json;base64,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