import { Construct } from '@aws-cdk/core';
import { DatadogCredentials } from '../common/properties';
/**
 * @stability stable
 */
export interface DatadogDowntimeProps {
    /**
     * Credentials for the Datadog API.
     *
     * @stability stable
     */
    readonly datadogCredentials: DatadogCredentials;
    /**
     * Whether or not this downtime is currently active.
     *
     * @stability stable
     */
    readonly active?: boolean;
    /**
     * POSIX Timestamp of cancellation of this downtime (null if not canceled).
     *
     * @stability stable
     */
    readonly canceled?: number;
    /**
     * Id of the user who created this downtime.
     *
     * @stability stable
     */
    readonly creatorId?: number;
    /**
     * Whether or not this downtime is disabled.
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * Type of this downtime.
     *
     * @stability stable
     */
    readonly downtimeType?: number;
    /**
     * POSIX timestamp to end the downtime.
     *
     * If not provided, the downtime is in effect indefinitely (i.e. until you cancel it).
     *
     * @stability stable
     */
    readonly end?: number;
    /**
     * Id of this downtime.
     *
     * @stability stable
     */
    readonly id?: number;
    /**
     * Message on the downtime.
     *
     * @stability stable
     */
    readonly message?: string;
    /**
     * A single monitor to which the downtime applies.
     *
     * If not provided, the downtime applies to all monitors.
     *
     * @stability stable
     */
    readonly monitorId?: number;
    /**
     * A comma-separated list of monitor tags, to which the downtime applies.
     *
     * The resulting downtime applies to monitors that match ALL provided monitor tags.
     *
     * @stability stable
     */
    readonly monitorTags?: string[];
    /**
     * The ID of the parent downtime to this one.
     *
     * @stability stable
     */
    readonly parentId?: number;
    /**
     * The scope(s) to which the downtime applies.
     *
     * @stability stable
     */
    readonly scope: string[];
    /**
     * POSIX timestamp to start the downtime.
     *
     * If not provided, the downtime starts the moment it is created.
     *
     * @stability stable
     */
    readonly start?: number;
    /**
     * The timezone for the downtime.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * Id of the user who updated this downtime.
     *
     * @stability stable
     */
    readonly updaterId?: number;
}
/**
 * Datadog Monitor Downtime 2.0.0.
 *
 * @stability stable
 */
export declare class DatadogDowntime {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DatadogDowntimeProps);
}
