DROP TABLE IF EXISTS `GeneticCode`;
CREATE TABLE IF NOT EXISTS `GeneticCode`(
	GENETIC_CODE_ID INT(11) NOT NULL AUTO_INCREMENT,
	NCBI_GENETIC_CODE_ID INT(11) NOT NULL,
	ABBREVIATION VARCHAR(255) NULL,
	NAME VARCHAR(255) NULL,
	CODE VARCHAR(255) NOT NULL,
	STARTS VARCHAR(255) NOT NULL,
	MODIFICATION_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (GENETIC_CODE_ID)
) ENGINE=InnoDB AUTO_INCREMENT = 1;

DROP TABLE IF EXISTS `Taxon`;
CREATE TABLE IF NOT EXISTS `Taxon` (
	NCBI_TAXON_ID INT(11) NOT NULL,
	PARENT_ID INT(11) DEFAULT NULL,
	TAXON_NAME VARCHAR(255) NOT NULL,
	TAXON_STRAIN VARCHAR(255) NULL,
	`RANK` VARCHAR(255) NOT NULL,
	GENETIC_CODE_ID INT(11) NOT NULL,
	MITOCHONDRIAL_GENETIC_CODE_ID INT(11) NOT NULL,
	MODIFICATION_DATE DATE,
	PRIMARY KEY (NCBI_TAXON_ID),
    FOREIGN KEY (GENETIC_CODE_ID) REFERENCES GeneticCode(GENETIC_CODE_ID),
    FOREIGN KEY (MITOCHONDRIAL_GENETIC_CODE_ID) REFERENCES GeneticCode(GENETIC_CODE_ID)
)ENGINE=InnoDB AUTO_INCREMENT = 1;

DROP TABLE IF EXISTS `GOTerm`;
CREATE TABLE IF NOT EXISTS `GOTerm`(
    GO_ID INT(11),
    NAME VARCHAR(255) NOT NULL,
    TERM_TYPE VARCHAR(50) NULL,
    ACC VARCHAR(255) NOT NULL,
    IS_OBSOLETE INT(10) NOT NULL,
    IS_ROOT INT(10) NOT NULL,
    IS_RELATION INT(10) NOT NULL,
    PRIMARY KEY (GO_ID)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS `GOEvidenceCode`;
CREATE TABLE IF NOT EXISTS `GOEvidenceCode`(
    GO_EVIDENCE_CODE_ID INT(11) NOT NULL AUTO_INCREMENT,
    NAME VARCHAR(50) NOT NULL,
    DESCRIPTION VARCHAR(255) NULL,
    MODIFICATION_DATE DATE NOT NULL,
    PRIMARY KEY (GO_EVIDENCE_CODE_ID)
)ENGINE=InnoDB AUTO_INCREMENT=1;


DROP TABLE IF EXISTS `Author`;
CREATE TABLE IF NOT EXISTS `Author`(
    AUTHOR_ID INT(11),
    TITLE VARCHAR(10),
    FIRST_NAME VARCHAR(50),
    MIDDLE_NAME VARCHAR(50),
    LAST_NAME VARCHAR(50),
    MODIFICATION_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY(AUTHOR_ID)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS `Contact`;
CREATE TABLE IF NOT EXISTS `Contact`(
    CONTACT_ID INT(11) NOT NULL,
    AFFILIATION_ID INT(11) NOT NULL,
    EXTERNAL_DATABASE_ID INT(11) NOT NULL,
    SOURCE_ID INT(11) NOT NULL,
    FIRST_NAME VARCHAR(100),
    MIDDLE_NAME VARCHAR(100),
    LAST_NAME VARCHAR(100),
    CITY VARCHAR(100),
    STATE VARCHAR(100),
    COUNTRY VARCHAR(100),
    ZIP INT(11),
    EMAIL VARCHAR(100),
    PHONE INT(11),
    MODIFICATION_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY(CONTACT_ID)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS `BibliographicReference`;
CREATE TABLE IF NOT EXISTS `BibliographicReference`(
    BIBLIOGRAPHIC_REFERENCE_ID INT(11) NOT NULL,
    TITLE VARCHAR(255) NOT NULL,
    AUTHORS VARCHAR(500) NULL,
    PUBLICATION VARCHAR(255) NULL,
    EDITOR VARCHAR(255) NULL,
    YEAR INT(5) NULL,
    VOLUME VARCHAR(100) NULL,
    ISSUE VARCHAR(100) NULL,
    PAGES VARCHAR(100) NULL,
    URI VARCHAR(255) NULL,
    SOURCE_ID INT(11) NULL,
    CONTACT_ID INT(11) NULL,
    MODIFICATION_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY(BIBLIOGRAPHIC_REFERENCE_ID)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS `Abstract`;
CREATE TABLE IF NOT EXISTS `Abstract`(
    ABSTRACT_ID INT(11) NOT NULL,
    BIBLIOGRAPHIC_REFERENCE_ID INT(11) NOT NULL,
    ABSTRACT VARCHAR(255) NULL,
    MODIFICATION_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY(ABSTRACT_ID),
    FOREIGN KEY (BIBLIOGRAPHIC_REFERENCE_ID) REFERENCES BibliographicReference(BIBLIOGRAPHIC_REFERENCE_ID)
)ENGINE=InnoDB;


DROP TABLE IF EXISTS `ExternalDatabase`;
CREATE TABLE IF NOT EXISTS `ExternalDatabase`(
    EXTERNAL_DATABASE_ID INT(11),
    RELEASE_DATE DATE ,
    VERSION VARCHAR(50) NULL,
    DOWNLOAD_URL VARCHAR(255) NULL,
    NAME VARCHAR(255) NOT NULL,
    DESCRIPTION VARCHAR(255) NULL,
    PRIMARY KEY (EXTERNAL_DATABASE_ID)
)ENGINE=InnoDB;


DROP TABLE IF EXISTS `ReviewStatus`;
CREATE TABLE IF NOT EXISTS `ReviewStatus`(
    REVIEW_STATUS_ID INT(11) NOT NULL,
    NAME VARCHAR(100) NOT NULL,
    DESCRIPTION VARCHAR(255) NULL,
    EMAIL_ID VARCHAR(100) NULL,
    MODIFICATION_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (REVIEW_STATUS_ID)
)ENGINE=InnoDB;

DROP TABLE IF EXISTS `GramStrain`;
CREATE TABLE IF NOT EXISTS `GramStrain`(
    GRAM_STRAIN_ID INT(11) NOT NULL AUTO_INCREMENT,
    ORGANISM VARCHAR(255) NOT NULL,
    TAXON_ID INT(11) NOT NULL,
    STRAIN_TYPE VARCHAR(100) NOT NULL,
    MEMBRANE_type VARCHAR(100) NULL,
    MODIFICATION_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (GRAM_STRAIN_ID)
)ENGINE=InnoDB AUTO_INCREMENT = 1;
