
"""
Contains the best fit values as in Salcido et al. (2022).
"""


best_fit_vals = {}
best_fit_vals['200'] = {'alpha': [15.274930840056541,-1.245047539257722,0.14540677973676638],
                        'beta': [14.930101598751966,-1.062673017386771,0.12120874422958225],
                        'gamma': [0.973317059802909,-0.3341132933728971,0.147971236001855],
                        'lambda_a': [0.03257049282030497,-0.012994181725415443,0.0016012935859615331],
                        'lambda_b': [2.936213543501669,0.4647835283419599,0.015469588056462733],
                        'mu_a': [0.7185313695191637,-0.17419453040304703,0.04344834913957274],
                        'mu_b': [7.061473347061119,-2.6451585009317475,0.693874112309198],
                        'mu_c': [9.72782645402674,-6.692331015886623,1.3184537648431263],
                        'nu_a': [659.6062166482205,190.65546760275708,25.12315520958482],
                        'nu_b': [-10.627984535501893,0.38934321021631624,0.2461189904914769],
                        'nu_c': [3.153654283048472,-0.13183283346451197,-0.07021924767085688]}

best_fit_vals['500'] = {'alpha': [14.76469953943553,-0.9861664024147414,0.11918239669227224],
                        'beta': [14.61129247278941,-0.9086389425569597,0.10810207298747473],
                        'gamma': [0.8419196246836991,0.06967440823217347,0.014730497492187217],
                        'lambda_a': [0.019909493214134613,-0.006723408341682784,0.0007220653696607669],
                        'lambda_b': [3.04279503307814,0.5256217945904988,0.00660016011437811],
                        'mu_a': [0.6875723754738109,-0.15501931108472428,0.04106325613876646],
                        'mu_b': [4.372736593576084,0.4034162144260609,-0.02740227359038959],
                        'mu_c': [5.514096648948588,-2.8918746793434114,0.5961162742741664],
                        'nu_a': [585.1128565518618,867.0756296967672,38.90230731032294],
                        'nu_b': [-11.243766644267883,-0.09618413993416547,0.3767515346494691],
                        'nu_c': [3.3546510607155344,-0.12716883213945795,-0.08194814244409948]}


limits = {}
limits['200'] = {'z': [0.0, 0.125, 0.5, 1.0, 2.0, 3.0],
                 'min_x0': [63.59373179416563, 59.88726319810792, 56.365373020207954, 39.64033211739476, 91.48777680660496, 45.013496639467114],
                 'min_x1': [-9.731727022847117, -9.176876134517682, -8.677101127391419, -6.141984569473165, -14.545324008239655, -7.155837194116757],
                 'min_x2': [0.36717360571115487, 0.34646698848026913, 0.32901138538950075, 0.23315608004243354, 0.5737424941339003, 0.280547072910215],
                 'max_x0': [18.37309024305502, 19.39185050748328, 23.581135709114342, 9.921243320018773, 5.886510333331434, 3.2505595228962156],
                 'max_x1': [-2.759876785639794, -2.9057029039529163, -3.5325526537664476, -1.4680671748329108, -0.8608020248618151, -0.4637637299766807],
                 'max_x2': [0.10310665850449997, 0.10833932967483784, 0.13187267761804813, 0.05397858264481507, 0.031183646792386614, 0.016278390350696954]}

limits['500'] = {'z': [0.0, 0.125, 0.5, 1.0, 2.0, 3.0], 
                 'min_x0': [75.5677443552107, 79.78651701865594, 12.453646158973672, 119.15086918977593, -44.84238282598863, -7.6276638395020955], 
                 'min_x1': [-11.520848743752344, -12.198643828164334, -2.0331966873703737, -18.404036176901812, 7.0469849096252615, 1.391204616961], 
                 'min_x2': [0.4340110697019119, 0.4611079754178873, 0.07774265268071975, 0.705717707613519, -0.2811444520707123, -0.06643766025515274], 
                 'max_x0': [29.7098168708338, 34.60582857431024, 43.06158434616325, 20.02440685404008, 10.119926258411336, 7.046905277066627], 
                 'max_x1': [-4.468289444788325, -5.194226654546699, -6.461887652137118, -2.9536733023513286, -1.4994660666136326, -1.020435592470318], 
                 'max_x2': [0.16735646291136727, 0.1942560839764333, 0.2418483292735806, 0.10842596379693702, 0.055362809275934344, 0.0367046507001731]}
