# Contributing to Helical

We welcome all kinds of contributions, including code, documentation, bug reports, and feature suggestions. Please read the following guidelines to help us keep the project organized and collaborative.

## Support expectations

The Helical team aims to be responsive and engaged with the community. While we do our best to reply promptly to issues, pull requests, and questions, there may be times when responses take some time, as we balance open source contributions with other work. We appreciate your patience and understanding, and we always welcome community support and collaboration.

## New features

If you'd like to see a new feature added, the best way to move it forward is to implement it and open a pull request. For more substantial changes, especially those that affect core functionality or involve design decisions, please start by opening an issue to discuss the idea first. This helps ensure alignment with the project's direction before significant work is done.

While the Helical team actively works to support and integrate new foundation models as quickly as possible, decisions about which models to add and when will be made at the team's discretion, based on technical fit, demand, and project priorities.

## Submitting a Pull Request

1. Ensure your code builds and passes existing tests.
2. Link related issue(s) in your PR description, if applicable.
3. Be ready for constructive feedback and revision requests.
4. Squash commits if needed before final merge.
5. Make sure to open your pull request against the `main` branch. By default, GitHub may select the `release` branch as the base, so you'll need to manually switch it to `main`. The `release` branch is updated periodically by the team and should not be used for contributions.

## Reporting Bugs

When reporting a bug, please provide a clear description of the issue, the steps to reproduce it, and any relevant environment details (e.g., OS, version, browser). If the problem can't be easily reproduced, the team may ask for a minimal code snippet or example that demonstrates the issue end to end.

## Before You Start

1. Look through existing issues to see if your idea or bug is already being addressed.
2. If you want to propose a major change or fix a bug, open an issue first to discuss.
3. Write clear, descriptive commit messages. 