"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Certificate = exports.CertificateProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cas_generated_1 = require("./cas.generated");
Object.defineProperty(exports, "CertificateProperty", { enumerable: true, get: function () { return cas_generated_1.RosCertificate; } });
/**
 * A ROS resource type:  `ALIYUN::CAS::Certificate`
 */
class Certificate extends ros.Resource {
    /**
     * Create a new `ALIYUN::CAS::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCertificate = new cas_generated_1.RosCertificate(this, id, {
            sourceIp: props.sourceIp,
            lang: props.lang,
            cert: props.cert,
            key: props.key,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCertificate;
        this.attrCertId = rosCertificate.attrCertId;
    }
}
exports.Certificate = Certificate;
//# sourceMappingURL=data:application/json;base64,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