import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeFunctionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/functions#database DataSnowflakeFunctions#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the functions from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/functions#schema DataSnowflakeFunctions#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeFunctionsFunctions extends cdktf.ComplexComputedList {
    get argumentTypes(): string[];
    get comment(): string;
    get database(): string;
    get name(): string;
    get returnType(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/functions snowflake_functions}
*/
export declare class DataSnowflakeFunctions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/functions snowflake_functions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeFunctionsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeFunctionsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    functions(index: string): DataSnowflakeFunctionsFunctions;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
