"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration snowflake_notification_integration}
*/
class NotificationIntegration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration snowflake_notification_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotificationIntegrationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_notification_integration',
            terraformGeneratorMetadata: {
                providerName: 'snowflake'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._awsSnsRoleArn = config.awsSnsRoleArn;
        this._awsSnsTopicArn = config.awsSnsTopicArn;
        this._awsSqsArn = config.awsSqsArn;
        this._awsSqsRoleArn = config.awsSqsRoleArn;
        this._azureStorageQueuePrimaryUri = config.azureStorageQueuePrimaryUri;
        this._azureTenantId = config.azureTenantId;
        this._comment = config.comment;
        this._direction = config.direction;
        this._enabled = config.enabled;
        this._gcpPubsubSubscriptionName = config.gcpPubsubSubscriptionName;
        this._name = config.name;
        this._notificationProvider = config.notificationProvider;
        this._type = config.type;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // aws_sns_external_id - computed: true, optional: false, required: false
    get awsSnsExternalId() {
        return this.getStringAttribute('aws_sns_external_id');
    }
    // aws_sns_iam_user_arn - computed: true, optional: false, required: false
    get awsSnsIamUserArn() {
        return this.getStringAttribute('aws_sns_iam_user_arn');
    }
    get awsSnsRoleArn() {
        return this.getStringAttribute('aws_sns_role_arn');
    }
    set awsSnsRoleArn(value) {
        this._awsSnsRoleArn = value;
    }
    resetAwsSnsRoleArn() {
        this._awsSnsRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSnsRoleArnInput() {
        return this._awsSnsRoleArn;
    }
    get awsSnsTopicArn() {
        return this.getStringAttribute('aws_sns_topic_arn');
    }
    set awsSnsTopicArn(value) {
        this._awsSnsTopicArn = value;
    }
    resetAwsSnsTopicArn() {
        this._awsSnsTopicArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSnsTopicArnInput() {
        return this._awsSnsTopicArn;
    }
    get awsSqsArn() {
        return this.getStringAttribute('aws_sqs_arn');
    }
    set awsSqsArn(value) {
        this._awsSqsArn = value;
    }
    resetAwsSqsArn() {
        this._awsSqsArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSqsArnInput() {
        return this._awsSqsArn;
    }
    // aws_sqs_external_id - computed: true, optional: false, required: false
    get awsSqsExternalId() {
        return this.getStringAttribute('aws_sqs_external_id');
    }
    // aws_sqs_iam_user_arn - computed: true, optional: false, required: false
    get awsSqsIamUserArn() {
        return this.getStringAttribute('aws_sqs_iam_user_arn');
    }
    get awsSqsRoleArn() {
        return this.getStringAttribute('aws_sqs_role_arn');
    }
    set awsSqsRoleArn(value) {
        this._awsSqsRoleArn = value;
    }
    resetAwsSqsRoleArn() {
        this._awsSqsRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get awsSqsRoleArnInput() {
        return this._awsSqsRoleArn;
    }
    get azureStorageQueuePrimaryUri() {
        return this.getStringAttribute('azure_storage_queue_primary_uri');
    }
    set azureStorageQueuePrimaryUri(value) {
        this._azureStorageQueuePrimaryUri = value;
    }
    resetAzureStorageQueuePrimaryUri() {
        this._azureStorageQueuePrimaryUri = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureStorageQueuePrimaryUriInput() {
        return this._azureStorageQueuePrimaryUri;
    }
    get azureTenantId() {
        return this.getStringAttribute('azure_tenant_id');
    }
    set azureTenantId(value) {
        this._azureTenantId = value;
    }
    resetAzureTenantId() {
        this._azureTenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureTenantIdInput() {
        return this._azureTenantId;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    get direction() {
        return this.getStringAttribute('direction');
    }
    set direction(value) {
        this._direction = value;
    }
    resetDirection() {
        this._direction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get directionInput() {
        return this._direction;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get gcpPubsubSubscriptionName() {
        return this.getStringAttribute('gcp_pubsub_subscription_name');
    }
    set gcpPubsubSubscriptionName(value) {
        this._gcpPubsubSubscriptionName = value;
    }
    resetGcpPubsubSubscriptionName() {
        this._gcpPubsubSubscriptionName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gcpPubsubSubscriptionNameInput() {
        return this._gcpPubsubSubscriptionName;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get notificationProvider() {
        return this.getStringAttribute('notification_provider');
    }
    set notificationProvider(value) {
        this._notificationProvider = value;
    }
    resetNotificationProvider() {
        this._notificationProvider = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationProviderInput() {
        return this._notificationProvider;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            aws_sns_role_arn: cdktf.stringToTerraform(this._awsSnsRoleArn),
            aws_sns_topic_arn: cdktf.stringToTerraform(this._awsSnsTopicArn),
            aws_sqs_arn: cdktf.stringToTerraform(this._awsSqsArn),
            aws_sqs_role_arn: cdktf.stringToTerraform(this._awsSqsRoleArn),
            azure_storage_queue_primary_uri: cdktf.stringToTerraform(this._azureStorageQueuePrimaryUri),
            azure_tenant_id: cdktf.stringToTerraform(this._azureTenantId),
            comment: cdktf.stringToTerraform(this._comment),
            direction: cdktf.stringToTerraform(this._direction),
            enabled: cdktf.booleanToTerraform(this._enabled),
            gcp_pubsub_subscription_name: cdktf.stringToTerraform(this._gcpPubsubSubscriptionName),
            name: cdktf.stringToTerraform(this._name),
            notification_provider: cdktf.stringToTerraform(this._notificationProvider),
            type: cdktf.stringToTerraform(this._type),
        };
    }
}
exports.NotificationIntegration = NotificationIntegration;
_a = JSII_RTTI_SYMBOL_1;
NotificationIntegration[_a] = { fqn: "@cdktf/provider-snowflake.NotificationIntegration", version: "0.0.15" };
// =================
// STATIC PROPERTIES
// =================
NotificationIntegration.tfResourceType = "snowflake_notification_integration";
//# sourceMappingURL=data:application/json;base64,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