"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OauthIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration snowflake_oauth_integration}
*/
class OauthIntegration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/oauth_integration snowflake_oauth_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OauthIntegrationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_oauth_integration',
            terraformGeneratorMetadata: {
                providerName: 'snowflake'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._blockedRolesList = config.blockedRolesList;
        this._comment = config.comment;
        this._enabled = config.enabled;
        this._name = config.name;
        this._oauthClient = config.oauthClient;
        this._oauthIssueRefreshTokens = config.oauthIssueRefreshTokens;
        this._oauthRefreshTokenValidity = config.oauthRefreshTokenValidity;
        this._oauthUseSecondaryRoles = config.oauthUseSecondaryRoles;
    }
    get blockedRolesList() {
        return cdktf.Fn.tolist(this.getListAttribute('blocked_roles_list'));
    }
    set blockedRolesList(value) {
        this._blockedRolesList = value;
    }
    resetBlockedRolesList() {
        this._blockedRolesList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blockedRolesListInput() {
        return this._blockedRolesList;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get oauthClient() {
        return this.getStringAttribute('oauth_client');
    }
    set oauthClient(value) {
        this._oauthClient = value;
    }
    // Temporarily expose input value. Use with caution.
    get oauthClientInput() {
        return this._oauthClient;
    }
    get oauthIssueRefreshTokens() {
        return this.getBooleanAttribute('oauth_issue_refresh_tokens');
    }
    set oauthIssueRefreshTokens(value) {
        this._oauthIssueRefreshTokens = value;
    }
    resetOauthIssueRefreshTokens() {
        this._oauthIssueRefreshTokens = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthIssueRefreshTokensInput() {
        return this._oauthIssueRefreshTokens;
    }
    get oauthRefreshTokenValidity() {
        return this.getNumberAttribute('oauth_refresh_token_validity');
    }
    set oauthRefreshTokenValidity(value) {
        this._oauthRefreshTokenValidity = value;
    }
    resetOauthRefreshTokenValidity() {
        this._oauthRefreshTokenValidity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthRefreshTokenValidityInput() {
        return this._oauthRefreshTokenValidity;
    }
    get oauthUseSecondaryRoles() {
        return this.getStringAttribute('oauth_use_secondary_roles');
    }
    set oauthUseSecondaryRoles(value) {
        this._oauthUseSecondaryRoles = value;
    }
    resetOauthUseSecondaryRoles() {
        this._oauthUseSecondaryRoles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oauthUseSecondaryRolesInput() {
        return this._oauthUseSecondaryRoles;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            blocked_roles_list: cdktf.listMapper(cdktf.stringToTerraform)(this._blockedRolesList),
            comment: cdktf.stringToTerraform(this._comment),
            enabled: cdktf.booleanToTerraform(this._enabled),
            name: cdktf.stringToTerraform(this._name),
            oauth_client: cdktf.stringToTerraform(this._oauthClient),
            oauth_issue_refresh_tokens: cdktf.booleanToTerraform(this._oauthIssueRefreshTokens),
            oauth_refresh_token_validity: cdktf.numberToTerraform(this._oauthRefreshTokenValidity),
            oauth_use_secondary_roles: cdktf.stringToTerraform(this._oauthUseSecondaryRoles),
        };
    }
}
exports.OauthIntegration = OauthIntegration;
_a = JSII_RTTI_SYMBOL_1;
OauthIntegration[_a] = { fqn: "@cdktf/provider-snowflake.OauthIntegration", version: "0.0.15" };
// =================
// STATIC PROPERTIES
// =================
OauthIntegration.tfResourceType = "snowflake_oauth_integration";
//# sourceMappingURL=data:application/json;base64,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