import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PipeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a auto_ingest param for the pipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#auto_ingest Pipe#auto_ingest}
    */
    readonly autoIngest?: boolean | cdktf.IResolvable;
    /**
    * Specifies the Amazon Resource Name (ARN) for the SNS topic for your S3 bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#aws_sns_topic_arn Pipe#aws_sns_topic_arn}
    */
    readonly awsSnsTopicArn?: string;
    /**
    * Specifies a comment for the pipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#comment Pipe#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the copy statement for the pipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#copy_statement Pipe#copy_statement}
    */
    readonly copyStatement: string;
    /**
    * The database in which to create the pipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#database Pipe#database}
    */
    readonly database: string;
    /**
    * Specifies the name of the notification integration used for error notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#error_integration Pipe#error_integration}
    */
    readonly errorIntegration?: string;
    /**
    * Specifies an integration for the pipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#integration Pipe#integration}
    */
    readonly integration?: string;
    /**
    * Specifies the identifier for the pipe; must be unique for the database and schema in which the pipe is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#name Pipe#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the pipe.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/pipe#schema Pipe#schema}
    */
    readonly schema: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/pipe snowflake_pipe}
*/
export declare class Pipe extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/pipe snowflake_pipe} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PipeConfig
    */
    constructor(scope: Construct, id: string, config: PipeConfig);
    private _autoIngest?;
    get autoIngest(): boolean | cdktf.IResolvable;
    set autoIngest(value: boolean | cdktf.IResolvable);
    resetAutoIngest(): void;
    get autoIngestInput(): boolean | cdktf.IResolvable | undefined;
    private _awsSnsTopicArn?;
    get awsSnsTopicArn(): string;
    set awsSnsTopicArn(value: string);
    resetAwsSnsTopicArn(): void;
    get awsSnsTopicArnInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _copyStatement?;
    get copyStatement(): string;
    set copyStatement(value: string);
    get copyStatementInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _errorIntegration?;
    get errorIntegration(): string;
    set errorIntegration(value: string);
    resetErrorIntegration(): void;
    get errorIntegrationInput(): string | undefined;
    get id(): string;
    private _integration?;
    get integration(): string;
    set integration(value: string);
    resetIntegration(): void;
    get integrationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notificationChannel(): string;
    get owner(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
