"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeVoiceConnector = exports.Protocol = exports.NotificationTargetType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const voiceConnectorValidator_1 = require("./voiceConnectorValidator");
var NotificationTargetType;
(function (NotificationTargetType) {
    NotificationTargetType["EVENTBRIDGE"] = "EventBridge";
    NotificationTargetType["SNS"] = "SNS";
    NotificationTargetType["SQS"] = "SQS";
})(NotificationTargetType = exports.NotificationTargetType || (exports.NotificationTargetType = {}));
var Protocol;
(function (Protocol) {
    Protocol["TCP"] = "TCP";
    Protocol["UDP"] = "UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
class ChimeVoiceConnector extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, region, encryption, termination, origination, streaming } = props;
        voiceConnectorValidator_1.voiceConnectorValidator(props);
        const voiceConnectorRequest = new pstnCustomResources_1.PSTNResources(this, 'voiceConnectorRequest', {
            resourceType: 'VoiceConnector',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name !== null && name !== void 0 ? name : uid,
                encryption: encryption || false,
                termination: termination,
                origination: origination,
                streaming: streaming,
            },
        });
        this.voiceConnectorId =
            voiceConnectorRequest.pstnCustomResource.getAttString('voiceConnectorId');
    }
}
exports.ChimeVoiceConnector = ChimeVoiceConnector;
_a = JSII_RTTI_SYMBOL_1;
ChimeVoiceConnector[_a] = { fqn: "cdk-amazon-chime-resources.ChimeVoiceConnector", version: "0.1.2" };
//# sourceMappingURL=data:application/json;base64,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