import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#description ComputeRegionAutoscaler#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#name ComputeRegionAutoscaler#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#project ComputeRegionAutoscaler#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * URL of the region where the instance group resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#region ComputeRegionAutoscaler#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * URL of the managed instance group that this autoscaler will scale.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#target ComputeRegionAutoscaler#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * autoscaling_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#autoscaling_policy ComputeRegionAutoscaler#autoscaling_policy}
     *
     * @stability stable
     */
    readonly autoscalingPolicy: ComputeRegionAutoscalerAutoscalingPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#timeouts ComputeRegionAutoscaler#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionAutoscalerTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization {
    /**
     * Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:.
     *
     * - NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics.
     *
     * - OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#predictive_method ComputeRegionAutoscaler#predictive_method}
     *
     * @stability stable
     */
    readonly predictiveMethod?: string;
    /**
     * The target CPU utilization that the autoscaler should maintain.
     *
     * Must be a float value in the range (0, 1]. If not specified, the
     * default is 0.6.
     *
     * If the CPU level is below the target utilization, the autoscaler
     * scales down the number of instances until it reaches the minimum
     * number of instances you specified or until the average CPU of
     * your instances reaches the target utilization.
     *
     * If the average CPU is above the target utilization, the autoscaler
     * scales up until it reaches the maximum number of instances you
     * specified or until the average utilization reaches the target
     * utilization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#target ComputeRegionAutoscaler#target}
     *
     * @stability stable
     */
    readonly target: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionAutoscalerAutoscalingPolicyCpuUtilizationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _predictiveMethod?;
    /**
     * @stability stable
     */
    get predictiveMethod(): string | undefined;
    /**
     * @stability stable
     */
    set predictiveMethod(value: string | undefined);
    /**
     * @stability stable
     */
    resetPredictiveMethod(): void;
    /**
     * @stability stable
     */
    get predictiveMethodInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): number;
    /**
     * @stability stable
     */
    set target(value: number);
    /**
     * @stability stable
     */
    get targetInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization {
    /**
     * Fraction of backend capacity utilization (set in HTTP(s) load balancing configuration) that autoscaler should maintain.
     *
     * Must
     * be a positive float value. If not defined, the default is 0.8.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#target ComputeRegionAutoscaler#target}
     *
     * @stability stable
     */
    readonly target: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _target?;
    /**
     * @stability stable
     */
    get target(): number;
    /**
     * @stability stable
     */
    set target(value: number);
    /**
     * @stability stable
     */
    get targetInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerAutoscalingPolicyMetric {
    /**
     * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values.
     *
     * The metric must have a value type of INT64 or DOUBLE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#name ComputeRegionAutoscaler#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The target value of the metric that autoscaler should maintain.
     *
     * This must be a positive value. A utilization
     * metric scales number of virtual machines handling requests
     * to increase or decrease proportionally to the metric.
     *
     * For example, a good metric to use as a utilizationTarget is
     * www.googleapis.com/compute/instance/network/received_bytes_count.
     * The autoscaler will work to keep this value constant for each
     * of the instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#target ComputeRegionAutoscaler#target}
     *
     * @stability stable
     */
    readonly target?: number;
    /**
     * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Possible values: ["GAUGE", "DELTA_PER_SECOND", "DELTA_PER_MINUTE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#type ComputeRegionAutoscaler#type}
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas {
    /**
     * Specifies a fixed number of VM instances. This must be a positive integer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#fixed ComputeRegionAutoscaler#fixed}
     *
     * @stability stable
     */
    readonly fixed?: number;
    /**
     * Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#percent ComputeRegionAutoscaler#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _fixed?;
    /**
     * @stability stable
     */
    get fixed(): number | undefined;
    /**
     * @stability stable
     */
    set fixed(value: number | undefined);
    /**
     * @stability stable
     */
    resetFixed(): void;
    /**
     * @stability stable
     */
    get fixedInput(): number | undefined;
    private _percent?;
    /**
     * @stability stable
     */
    get percent(): number | undefined;
    /**
     * @stability stable
     */
    set percent(value: number | undefined);
    /**
     * @stability stable
     */
    resetPercent(): void;
    /**
     * @stability stable
     */
    get percentInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerAutoscalingPolicyScaleInControl {
    /**
     * How long back autoscaling should look when computing recommendations to include directives regarding slower scale down, as described above.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#time_window_sec ComputeRegionAutoscaler#time_window_sec}
     *
     * @stability stable
     */
    readonly timeWindowSec?: number;
    /**
     * max_scaled_in_replicas block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#max_scaled_in_replicas ComputeRegionAutoscaler#max_scaled_in_replicas}
     *
     * @stability stable
     */
    readonly maxScaledInReplicas?: ComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas;
}
/**
 * @stability stable
 */
export declare class ComputeRegionAutoscalerAutoscalingPolicyScaleInControlOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _timeWindowSec?;
    /**
     * @stability stable
     */
    get timeWindowSec(): number | undefined;
    /**
     * @stability stable
     */
    set timeWindowSec(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeWindowSec(): void;
    /**
     * @stability stable
     */
    get timeWindowSecInput(): number | undefined;
    private _maxScaledInReplicas?;
    private __maxScaledInReplicasOutput;
    /**
     * @stability stable
     */
    get maxScaledInReplicas(): ComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference;
    /**
     * @stability stable
     */
    putMaxScaledInReplicas(value: ComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined): void;
    /**
     * @stability stable
     */
    resetMaxScaledInReplicas(): void;
    /**
     * @stability stable
     */
    get maxScaledInReplicasInput(): ComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerAutoscalingPolicyScalingSchedules {
    /**
     * A description of a scaling schedule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#description ComputeRegionAutoscaler#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A boolean value that specifies if a scaling schedule can influence autoscaler recommendations.
     *
     * If set to true, then a scaling schedule has no effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#disabled ComputeRegionAutoscaler#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The duration of time intervals (in seconds) for which this scaling schedule will be running.
     *
     * The minimum allowed value is 300.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#duration_sec ComputeRegionAutoscaler#duration_sec}
     *
     * @stability stable
     */
    readonly durationSec: number;
    /**
     * Minimum number of VM instances that autoscaler will recommend in time intervals starting according to schedule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#min_required_replicas ComputeRegionAutoscaler#min_required_replicas}
     *
     * @stability stable
     */
    readonly minRequiredReplicas: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#name ComputeRegionAutoscaler#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The start timestamps of time intervals when this scaling schedule should provide a scaling signal.
     *
     * This field uses the extended cron format (with an optional year field).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#schedule ComputeRegionAutoscaler#schedule}
     *
     * @stability stable
     */
    readonly schedule: string;
    /**
     * The time zone to be used when interpreting the schedule.
     *
     * The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#time_zone ComputeRegionAutoscaler#time_zone}
     *
     * @stability stable
     */
    readonly timeZone?: string;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerAutoscalingPolicy {
    /**
     * The number of seconds that the autoscaler should wait before it starts collecting information from a new instance.
     *
     * This prevents
     * the autoscaler from collecting information when the instance is
     * initializing, during which the collected usage would not be
     * reliable. The default time autoscaler waits is 60 seconds.
     *
     * Virtual machine initialization times might vary because of
     * numerous factors. We recommend that you test how long an
     * instance may take to initialize. To do this, create an instance
     * and time the startup process.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#cooldown_period ComputeRegionAutoscaler#cooldown_period}
     *
     * @stability stable
     */
    readonly cooldownPeriod?: number;
    /**
     * The maximum number of instances that the autoscaler can scale up to.
     *
     * This is required when creating or updating an autoscaler. The
     * maximum number of replicas should not be lower than minimal number
     * of replicas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#max_replicas ComputeRegionAutoscaler#max_replicas}
     *
     * @stability stable
     */
    readonly maxReplicas: number;
    /**
     * The minimum number of replicas that the autoscaler can scale down to.
     *
     * This cannot be less than 0. If not provided, autoscaler will
     * choose a default value depending on maximum number of instances
     * allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#min_replicas ComputeRegionAutoscaler#min_replicas}
     *
     * @stability stable
     */
    readonly minReplicas: number;
    /**
     * Defines operating mode for this policy. Default value: "ON" Possible values: ["OFF", "ONLY_UP", "ON"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#mode ComputeRegionAutoscaler#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * cpu_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#cpu_utilization ComputeRegionAutoscaler#cpu_utilization}
     *
     * @stability stable
     */
    readonly cpuUtilization?: ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization;
    /**
     * load_balancing_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#load_balancing_utilization ComputeRegionAutoscaler#load_balancing_utilization}
     *
     * @stability stable
     */
    readonly loadBalancingUtilization?: ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization;
    /**
     * metric block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#metric ComputeRegionAutoscaler#metric}
     *
     * @stability stable
     */
    readonly metric?: ComputeRegionAutoscalerAutoscalingPolicyMetric[];
    /**
     * scale_in_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#scale_in_control ComputeRegionAutoscaler#scale_in_control}
     *
     * @stability stable
     */
    readonly scaleInControl?: ComputeRegionAutoscalerAutoscalingPolicyScaleInControl;
    /**
     * scaling_schedules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#scaling_schedules ComputeRegionAutoscaler#scaling_schedules}
     *
     * @stability stable
     */
    readonly scalingSchedules?: ComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[];
}
/**
 * @stability stable
 */
export declare class ComputeRegionAutoscalerAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cooldownPeriod?;
    /**
     * @stability stable
     */
    get cooldownPeriod(): number | undefined;
    /**
     * @stability stable
     */
    set cooldownPeriod(value: number | undefined);
    /**
     * @stability stable
     */
    resetCooldownPeriod(): void;
    /**
     * @stability stable
     */
    get cooldownPeriodInput(): number | undefined;
    private _maxReplicas?;
    /**
     * @stability stable
     */
    get maxReplicas(): number;
    /**
     * @stability stable
     */
    set maxReplicas(value: number);
    /**
     * @stability stable
     */
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    /**
     * @stability stable
     */
    get minReplicas(): number;
    /**
     * @stability stable
     */
    set minReplicas(value: number);
    /**
     * @stability stable
     */
    get minReplicasInput(): number | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string | undefined;
    /**
     * @stability stable
     */
    set mode(value: string | undefined);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _cpuUtilization?;
    private __cpuUtilizationOutput;
    /**
     * @stability stable
     */
    get cpuUtilization(): ComputeRegionAutoscalerAutoscalingPolicyCpuUtilizationOutputReference;
    /**
     * @stability stable
     */
    putCpuUtilization(value: ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization | undefined): void;
    /**
     * @stability stable
     */
    resetCpuUtilization(): void;
    /**
     * @stability stable
     */
    get cpuUtilizationInput(): ComputeRegionAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    private _loadBalancingUtilization?;
    private __loadBalancingUtilizationOutput;
    /**
     * @stability stable
     */
    get loadBalancingUtilization(): ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference;
    /**
     * @stability stable
     */
    putLoadBalancingUtilization(value: ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined): void;
    /**
     * @stability stable
     */
    resetLoadBalancingUtilization(): void;
    /**
     * @stability stable
     */
    get loadBalancingUtilizationInput(): ComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    private _metric?;
    /**
     * @stability stable
     */
    get metric(): ComputeRegionAutoscalerAutoscalingPolicyMetric[] | undefined;
    /**
     * @stability stable
     */
    set metric(value: ComputeRegionAutoscalerAutoscalingPolicyMetric[] | undefined);
    /**
     * @stability stable
     */
    resetMetric(): void;
    /**
     * @stability stable
     */
    get metricInput(): ComputeRegionAutoscalerAutoscalingPolicyMetric[] | undefined;
    private _scaleInControl?;
    private __scaleInControlOutput;
    /**
     * @stability stable
     */
    get scaleInControl(): ComputeRegionAutoscalerAutoscalingPolicyScaleInControlOutputReference;
    /**
     * @stability stable
     */
    putScaleInControl(value: ComputeRegionAutoscalerAutoscalingPolicyScaleInControl | undefined): void;
    /**
     * @stability stable
     */
    resetScaleInControl(): void;
    /**
     * @stability stable
     */
    get scaleInControlInput(): ComputeRegionAutoscalerAutoscalingPolicyScaleInControl | undefined;
    private _scalingSchedules?;
    /**
     * @stability stable
     */
    get scalingSchedules(): ComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[] | undefined;
    /**
     * @stability stable
     */
    set scalingSchedules(value: ComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[] | undefined);
    /**
     * @stability stable
     */
    resetScalingSchedules(): void;
    /**
     * @stability stable
     */
    get scalingSchedulesInput(): ComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionAutoscalerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#create ComputeRegionAutoscaler#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#delete ComputeRegionAutoscaler#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html#update ComputeRegionAutoscaler#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ComputeRegionAutoscalerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html google_compute_region_autoscaler}.
 *
 * @stability stable
 */
export declare class ComputeRegionAutoscaler extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_autoscaler.html google_compute_region_autoscaler} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionAutoscalerConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _autoscalingPolicy?;
    private __autoscalingPolicyOutput;
    /**
     * @stability stable
     */
    get autoscalingPolicy(): ComputeRegionAutoscalerAutoscalingPolicyOutputReference;
    /**
     * @stability stable
     */
    putAutoscalingPolicy(value: ComputeRegionAutoscalerAutoscalingPolicy): void;
    /**
     * @stability stable
     */
    get autoscalingPolicyInput(): ComputeRegionAutoscalerAutoscalingPolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionAutoscalerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRegionAutoscalerTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionAutoscalerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
