import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * The cluster to create the node pool for. Cluster must be present in location provided for zonal clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#cluster ContainerNodePool#cluster}
     *
     * @stability stable
     */
    readonly cluster: string;
    /**
     * The initial number of nodes for the pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#initial_node_count ContainerNodePool#initial_node_count}
     *
     * @stability stable
     */
    readonly initialNodeCount?: number;
    /**
     * The location (region or zone) of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#location ContainerNodePool#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The maximum number of pods per node in this node pool.
     *
     * Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_pods_per_node ContainerNodePool#max_pods_per_node}
     *
     * @stability stable
     */
    readonly maxPodsPerNode?: number;
    /**
     * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#name ContainerNodePool#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#name_prefix ContainerNodePool#name_prefix}
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * The number of nodes per instance group.
     *
     * This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_count ContainerNodePool#node_count}
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * The list of zones in which the node pool's nodes should be located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_locations ContainerNodePool#node_locations}
     *
     * @stability stable
     */
    readonly nodeLocations?: string[];
    /**
     * The ID of the project in which to create the node pool.
     *
     * If blank, the provider-configured project will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#project ContainerNodePool#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Kubernetes version for the nodes in this pool.
     *
     * Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#version ContainerNodePool#version}
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#autoscaling ContainerNodePool#autoscaling}
     *
     * @stability stable
     */
    readonly autoscaling?: ContainerNodePoolAutoscaling;
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#management ContainerNodePool#management}
     *
     * @stability stable
     */
    readonly management?: ContainerNodePoolManagement;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_config ContainerNodePool#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig?: ContainerNodePoolNodeConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#timeouts ContainerNodePool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerNodePoolTimeouts;
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#upgrade_settings ContainerNodePool#upgrade_settings}
     *
     * @stability stable
     */
    readonly upgradeSettings?: ContainerNodePoolUpgradeSettings;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolAutoscaling {
    /**
     * Maximum number of nodes in the NodePool. Must be >= min_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_node_count ContainerNodePool#max_node_count}
     *
     * @stability stable
     */
    readonly maxNodeCount: number;
    /**
     * Minimum number of nodes in the NodePool. Must be >=0 and <= max_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#min_node_count ContainerNodePool#min_node_count}
     *
     * @stability stable
     */
    readonly minNodeCount: number;
}
/**
 * @stability stable
 */
export declare class ContainerNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxNodeCount?;
    /**
     * @stability stable
     */
    get maxNodeCount(): number;
    /**
     * @stability stable
     */
    set maxNodeCount(value: number);
    /**
     * @stability stable
     */
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    /**
     * @stability stable
     */
    get minNodeCount(): number;
    /**
     * @stability stable
     */
    set minNodeCount(value: number);
    /**
     * @stability stable
     */
    get minNodeCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolManagement {
    /**
     * Whether the nodes will be automatically repaired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#auto_repair ContainerNodePool#auto_repair}
     *
     * @stability stable
     */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
     * Whether the nodes will be automatically upgraded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#auto_upgrade ContainerNodePool#auto_upgrade}
     *
     * @stability stable
     */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ContainerNodePoolManagementOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autoRepair?;
    /**
     * @stability stable
     */
    get autoRepair(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autoRepair(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutoRepair(): void;
    /**
     * @stability stable
     */
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    /**
     * @stability stable
     */
    get autoUpgrade(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autoUpgrade(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutoUpgrade(): void;
    /**
     * @stability stable
     */
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#count ContainerNodePool#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#gpu_partition_size ContainerNodePool#gpu_partition_size}.
     *
     * @stability stable
     */
    readonly gpuPartitionSize?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#type ContainerNodePool#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#effect ContainerNodePool#effect}.
     *
     * @stability stable
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#key ContainerNodePool#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#value ContainerNodePool#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#enable_integrity_monitoring ContainerNodePool#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#enable_secure_boot ContainerNodePool#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableIntegrityMonitoring(): void;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableSecureBoot(): void;
    /**
     * @stability stable
     */
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfigWorkloadMetadataConfig {
    /**
     * Mode is the configuration for how to expose metadata to workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#mode ContainerNodePool#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_metadata ContainerNodePool#node_metadata}
     *
     * @stability stable
     */
    readonly nodeMetadata?: string;
}
/**
 * @stability stable
 */
export declare class ContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string | undefined;
    /**
     * @stability stable
     */
    set mode(value: string | undefined);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _nodeMetadata?;
    /**
     * @stability stable
     */
    get nodeMetadata(): string | undefined;
    /**
     * @stability stable
     */
    set nodeMetadata(value: string | undefined);
    /**
     * @stability stable
     */
    resetNodeMetadata(): void;
    /**
     * @stability stable
     */
    get nodeMetadataInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#disk_size_gb ContainerNodePool#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#disk_type ContainerNodePool#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#guest_accelerator ContainerNodePool#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ContainerNodePoolNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#image_type ContainerNodePool#image_type}
     *
     * @stability stable
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#labels ContainerNodePool#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#local_ssd_count ContainerNodePool#local_ssd_count}
     *
     * @stability stable
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#machine_type ContainerNodePool#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#metadata ContainerNodePool#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#min_cpu_platform ContainerNodePool#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#oauth_scopes ContainerNodePool#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#preemptible ContainerNodePool#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#service_account ContainerNodePool#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#tags ContainerNodePool#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#taint ContainerNodePool#taint}
     *
     * @stability stable
     */
    readonly taint?: ContainerNodePoolNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#shielded_instance_config ContainerNodePool#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ContainerNodePoolNodeConfigShieldedInstanceConfig;
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#workload_metadata_config ContainerNodePool#workload_metadata_config}
     *
     * @stability stable
     */
    readonly workloadMetadataConfig?: ContainerNodePoolNodeConfigWorkloadMetadataConfig;
}
/**
 * @stability stable
 */
export declare class ContainerNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number | undefined;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number | undefined);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    /**
     * @stability stable
     */
    get diskType(): string | undefined;
    /**
     * @stability stable
     */
    set diskType(value: string | undefined);
    /**
     * @stability stable
     */
    resetDiskType(): void;
    /**
     * @stability stable
     */
    get diskTypeInput(): string | undefined;
    private _guestAccelerator?;
    /**
     * @stability stable
     */
    get guestAccelerator(): ContainerNodePoolNodeConfigGuestAccelerator[] | undefined;
    /**
     * @stability stable
     */
    set guestAccelerator(value: ContainerNodePoolNodeConfigGuestAccelerator[] | undefined);
    /**
     * @stability stable
     */
    resetGuestAccelerator(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorInput(): ContainerNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    /**
     * @stability stable
     */
    get imageType(): string | undefined;
    /**
     * @stability stable
     */
    set imageType(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageType(): void;
    /**
     * @stability stable
     */
    get imageTypeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    /**
     * @stability stable
     */
    get localSsdCount(): number | undefined;
    /**
     * @stability stable
     */
    set localSsdCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetLocalSsdCount(): void;
    /**
     * @stability stable
     */
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string | undefined;
    /**
     * @stability stable
     */
    set machineType(value: string | undefined);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string | undefined;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string | undefined);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[] | undefined;
    /**
     * @stability stable
     */
    set oauthScopes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    /**
     * @stability stable
     */
    get preemptible(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set preemptible(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPreemptible(): void;
    /**
     * @stability stable
     */
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string | undefined;
    /**
     * @stability stable
     */
    set serviceAccount(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _taint?;
    /**
     * @stability stable
     */
    get taint(): ContainerNodePoolNodeConfigTaint[] | undefined;
    /**
     * @stability stable
     */
    set taint(value: ContainerNodePoolNodeConfigTaint[] | undefined);
    /**
     * @stability stable
     */
    resetTaint(): void;
    /**
     * @stability stable
     */
    get taintInput(): ContainerNodePoolNodeConfigTaint[] | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): ContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putShieldedInstanceConfig(value: ContainerNodePoolNodeConfigShieldedInstanceConfig | undefined): void;
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): ContainerNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig?;
    private __workloadMetadataConfigOutput;
    /**
     * @stability stable
     */
    get workloadMetadataConfig(): ContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    /**
     * @stability stable
     */
    putWorkloadMetadataConfig(value: ContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined): void;
    /**
     * @stability stable
     */
    resetWorkloadMetadataConfig(): void;
    /**
     * @stability stable
     */
    get workloadMetadataConfigInput(): ContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#create ContainerNodePool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#delete ContainerNodePool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#update ContainerNodePool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ContainerNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerNodePoolUpgradeSettings {
    /**
     * The number of additional nodes that can be added to the node pool during an upgrade.
     *
     * Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_surge ContainerNodePool#max_surge}
     *
     * @stability stable
     */
    readonly maxSurge: number;
    /**
     * The number of nodes that can be simultaneously unavailable during an upgrade.
     *
     * Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_unavailable ContainerNodePool#max_unavailable}
     *
     * @stability stable
     */
    readonly maxUnavailable: number;
}
/**
 * @stability stable
 */
export declare class ContainerNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxSurge?;
    /**
     * @stability stable
     */
    get maxSurge(): number;
    /**
     * @stability stable
     */
    set maxSurge(value: number);
    /**
     * @stability stable
     */
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    /**
     * @stability stable
     */
    get maxUnavailable(): number;
    /**
     * @stability stable
     */
    set maxUnavailable(value: number);
    /**
     * @stability stable
     */
    get maxUnavailableInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html google_container_node_pool}.
 *
 * @stability stable
 */
export declare class ContainerNodePool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html google_container_node_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerNodePoolConfig);
    private _cluster?;
    /**
     * @stability stable
     */
    get cluster(): string;
    /**
     * @stability stable
     */
    set cluster(value: string);
    /**
     * @stability stable
     */
    get clusterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialNodeCount?;
    /**
     * @stability stable
     */
    get initialNodeCount(): number | undefined;
    /**
     * @stability stable
     */
    set initialNodeCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetInitialNodeCount(): void;
    /**
     * @stability stable
     */
    get initialNodeCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get instanceGroupUrls(): string[];
    private _location?;
    /**
     * @stability stable
     */
    get location(): string | undefined;
    /**
     * @stability stable
     */
    set location(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxPodsPerNode?;
    /**
     * @stability stable
     */
    get maxPodsPerNode(): number | undefined;
    /**
     * @stability stable
     */
    set maxPodsPerNode(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxPodsPerNode(): void;
    /**
     * @stability stable
     */
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namePrefix?;
    /**
     * @stability stable
     */
    get namePrefix(): string | undefined;
    /**
     * @stability stable
     */
    set namePrefix(value: string | undefined);
    /**
     * @stability stable
     */
    resetNamePrefix(): void;
    /**
     * @stability stable
     */
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number | undefined;
    /**
     * @stability stable
     */
    set nodeCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetNodeCount(): void;
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    /**
     * @stability stable
     */
    get nodeLocations(): string[] | undefined;
    /**
     * @stability stable
     */
    set nodeLocations(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetNodeLocations(): void;
    /**
     * @stability stable
     */
    get nodeLocationsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get operation(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string | undefined;
    /**
     * @stability stable
     */
    set version(value: string | undefined);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _autoscaling?;
    private __autoscalingOutput;
    /**
     * @stability stable
     */
    get autoscaling(): ContainerNodePoolAutoscalingOutputReference;
    /**
     * @stability stable
     */
    putAutoscaling(value: ContainerNodePoolAutoscaling | undefined): void;
    /**
     * @stability stable
     */
    resetAutoscaling(): void;
    /**
     * @stability stable
     */
    get autoscalingInput(): ContainerNodePoolAutoscaling | undefined;
    private _management?;
    private __managementOutput;
    /**
     * @stability stable
     */
    get management(): ContainerNodePoolManagementOutputReference;
    /**
     * @stability stable
     */
    putManagement(value: ContainerNodePoolManagement | undefined): void;
    /**
     * @stability stable
     */
    resetManagement(): void;
    /**
     * @stability stable
     */
    get managementInput(): ContainerNodePoolManagement | undefined;
    private _nodeConfig?;
    private __nodeConfigOutput;
    /**
     * @stability stable
     */
    get nodeConfig(): ContainerNodePoolNodeConfigOutputReference;
    /**
     * @stability stable
     */
    putNodeConfig(value: ContainerNodePoolNodeConfig | undefined): void;
    /**
     * @stability stable
     */
    resetNodeConfig(): void;
    /**
     * @stability stable
     */
    get nodeConfigInput(): ContainerNodePoolNodeConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ContainerNodePoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ContainerNodePoolTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerNodePoolTimeouts | undefined;
    private _upgradeSettings?;
    private __upgradeSettingsOutput;
    /**
     * @stability stable
     */
    get upgradeSettings(): ContainerNodePoolUpgradeSettingsOutputReference;
    /**
     * @stability stable
     */
    putUpgradeSettings(value: ContainerNodePoolUpgradeSettings | undefined): void;
    /**
     * @stability stable
     */
    resetUpgradeSettings(): void;
    /**
     * @stability stable
     */
    get upgradeSettingsInput(): ContainerNodePoolUpgradeSettings | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
