import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceAccountKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Arbitrary map of values that, when changed, will trigger recreation of resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html#keepers ServiceAccountKey#keepers}
     *
     * @stability stable
     */
    readonly keepers?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The algorithm used to generate the key, used only on create.
     *
     * KEY_ALG_RSA_2048 is the default algorithm. Valid values are: "KEY_ALG_RSA_1024", "KEY_ALG_RSA_2048".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html#key_algorithm ServiceAccountKey#key_algorithm}
     *
     * @stability stable
     */
    readonly keyAlgorithm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html#private_key_type ServiceAccountKey#private_key_type}.
     *
     * @stability stable
     */
    readonly privateKeyType?: string;
    /**
     * A field that allows clients to upload their own public key.
     *
     * If set, use this public key data to create a service account key for given service account. Please note, the expected format for this field is a base64 encoded X509_PEM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html#public_key_data ServiceAccountKey#public_key_data}
     *
     * @stability stable
     */
    readonly publicKeyData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html#public_key_type ServiceAccountKey#public_key_type}.
     *
     * @stability stable
     */
    readonly publicKeyType?: string;
    /**
     * The ID of the parent service account of the key.
     *
     * This can be a string in the format {ACCOUNT} or projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}, where {ACCOUNT} is the email address or unique id of the service account. If the {ACCOUNT} syntax is used, the project will be inferred from the provider's configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html#service_account_id ServiceAccountKey#service_account_id}
     *
     * @stability stable
     */
    readonly serviceAccountId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html google_service_account_key}.
 *
 * @stability stable
 */
export declare class ServiceAccountKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account_key.html google_service_account_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceAccountKeyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _keepers?;
    /**
     * @stability stable
     */
    get keepers(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set keepers(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetKeepers(): void;
    /**
     * @stability stable
     */
    get keepersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _keyAlgorithm?;
    /**
     * @stability stable
     */
    get keyAlgorithm(): string | undefined;
    /**
     * @stability stable
     */
    set keyAlgorithm(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyAlgorithm(): void;
    /**
     * @stability stable
     */
    get keyAlgorithmInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateKey(): string;
    private _privateKeyType?;
    /**
     * @stability stable
     */
    get privateKeyType(): string | undefined;
    /**
     * @stability stable
     */
    set privateKeyType(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateKeyType(): void;
    /**
     * @stability stable
     */
    get privateKeyTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicKey(): string;
    private _publicKeyData?;
    /**
     * @stability stable
     */
    get publicKeyData(): string | undefined;
    /**
     * @stability stable
     */
    set publicKeyData(value: string | undefined);
    /**
     * @stability stable
     */
    resetPublicKeyData(): void;
    /**
     * @stability stable
     */
    get publicKeyDataInput(): string | undefined;
    private _publicKeyType?;
    /**
     * @stability stable
     */
    get publicKeyType(): string | undefined;
    /**
     * @stability stable
     */
    set publicKeyType(value: string | undefined);
    /**
     * @stability stable
     */
    resetPublicKeyType(): void;
    /**
     * @stability stable
     */
    get publicKeyTypeInput(): string | undefined;
    private _serviceAccountId?;
    /**
     * @stability stable
     */
    get serviceAccountId(): string;
    /**
     * @stability stable
     */
    set serviceAccountId(value: string);
    /**
     * @stability stable
     */
    get serviceAccountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get validAfter(): string;
    /**
     * @stability stable
     */
    get validBefore(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
