"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingAppInstanceUser = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const instanceUserValidator_1 = require("./instanceUserValidator");
const messagingCustomResources_1 = require("./messagingCustomResources");
class MessagingAppInstanceUser extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, metadata, clientRequestToken, appInstanceArn, appInstanceUserId, } = props;
        instanceUserValidator_1.instanceUserValidator(props);
        const appInstanceRequest = new messagingCustomResources_1.MessagingResources(this, 'MessagingAppInstance', {
            resourceType: 'AppInstanceUser',
            uid: uid,
            properties: {
                name: name || uid,
                metadata: metadata,
                clientRequestToken: clientRequestToken,
                appInstanceArn: appInstanceArn,
                appInstanceUserId: appInstanceUserId,
            },
        });
        this.appInstanceUserArn =
            appInstanceRequest.messagingCustomResource.getAttString('appInstanceUser');
    }
}
exports.MessagingAppInstanceUser = MessagingAppInstanceUser;
_a = JSII_RTTI_SYMBOL_1;
MessagingAppInstanceUser[_a] = { fqn: "cdk-amazon-chime-resources.MessagingAppInstanceUser", version: "0.1.89" };
//# sourceMappingURL=data:application/json;base64,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