# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-06-30 21:16
from __future__ import unicode_literals

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import medlemssys.medlem.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Giro',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('belop', models.PositiveIntegerField(verbose_name='Bel\xf8p')),
                ('innbetalt_belop', models.PositiveIntegerField(default=0, verbose_name='Innbetalt bel\xf8p')),
                ('kid', models.CharField(blank=True, max_length=255, unique=True, verbose_name='KID-nummer')),
                ('oppretta', models.DateTimeField(auto_now_add=True, verbose_name='oppretta')),
                ('oppdatert', models.DateTimeField(auto_now=True, verbose_name='oppatert')),
                ('innbetalt', models.DateField(blank=True, null=True, verbose_name='Dato betalt')),
                ('konto', models.CharField(choices=[('A', 'Medlemskonto (KID)'), ('M', 'Medlemskonto'), ('K', 'Kassa'), ('B', 'Brukskonto'), ('S', 'SMS')], default='M', max_length=1, verbose_name='Konto')),
                ('hensikt', models.CharField(choices=[('P', 'Medlemspengar'), ('G', 'G\xe5ve'), ('T', 'Tilskiping'), ('A', 'Anna')], default='P', max_length=1, verbose_name='Hensikt')),
                ('desc', models.TextField(blank=True, default='', verbose_name='Forklaring')),
                ('status', models.CharField(choices=[('V', 'Ventar'), ('1', 'Epost sendt'), ('E', '(E) Sendingsfeil'), ('M', 'Manuelt postlagt'), ('F', 'Ferdig'), ('U', 'Utg\xe5tt ubetalt')], default='V', max_length=1, verbose_name='Status')),
                ('gjeldande_aar', models.PositiveIntegerField(default=medlemssys.medlem.models.this_year, verbose_name='Gjeldande \xe5r')),
            ],
            options={
                'ordering': ('-oppdatert', '-innbetalt', '-pk'),
                'verbose_name_plural': 'giroar',
            },
        ),
        migrations.CreateModel(
            name='Innmeldingstype',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('namn', models.CharField(max_length=255, unique=True, verbose_name='namn')),
            ],
            options={
                'verbose_name_plural': 'innmeldingstypar',
            },
        ),
        migrations.CreateModel(
            name='Lokallag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('namn', models.CharField(max_length=255, unique=True, verbose_name='namn')),
                ('slug', models.SlugField(blank=True, max_length=255, unique=True, verbose_name='nettnamn')),
                ('kommunes', models.CharField(blank=True, help_text='Kommaseparert med stor forbokstav, t.d. "Stavanger, Sandnes".', max_length=255, verbose_name='kommunar')),
                ('fylke', models.CharField(blank=True, help_text='Berre eitt fylke, stor forbokstav. Overstyrer kommuner visst denne finst.', max_length=255, verbose_name='fylke')),
                ('andsvar', models.CharField(blank=True, max_length=255, verbose_name='andsvar')),
                ('lokalsats', models.IntegerField(default=0, verbose_name='lokalsats')),
                ('aktivt', models.BooleanField(default=True, verbose_name='aktivt')),
                ('epost', models.EmailField(blank=True, help_text='Eiga epostliste til styret. Tek prioritet\n        over \xe5 senda enkeltvis til dei som er registrert som styre.', max_length=254, verbose_name='epost')),
            ],
            options={
                'ordering': ['-aktivt', 'namn'],
                'verbose_name_plural': 'lokallag',
            },
        ),
        migrations.CreateModel(
            name='LokallagOvervaking',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('epost', models.CharField(blank=True, help_text='Vert brukt dersom medlem ikkje er satt', max_length=255, verbose_name='epost')),
                ('deaktivert', models.DateTimeField(blank=True, null=True)),
                ('sist_oppdatert', models.DateTimeField(auto_now=True)),
                ('lokallag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lokallag_overvaking_set', to='medlem.Lokallag')),
            ],
            options={
                'verbose_name_plural': 'lokallagovervakingar',
            },
        ),
        migrations.CreateModel(
            name='Medlem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fornamn', models.CharField(max_length=255, verbose_name='fornamn')),
                ('mellomnamn', models.CharField(blank=True, max_length=255, verbose_name='mellomnamn')),
                ('etternamn', models.CharField(max_length=255, verbose_name='etternamn')),
                ('fodt', models.IntegerField(blank=True, null=True, verbose_name='f\xf8dt')),
                ('postnr', models.CharField(help_text="'0000' viss norsk adresse manglar", max_length=4, verbose_name='postnr')),
                ('epost', models.CharField(blank=True, max_length=255, verbose_name='epost')),
                ('postadr', models.CharField(blank=True, help_text='Skriv utanlands-/skuleadresse i borte-addresse', max_length=255, null=True, verbose_name='postadresse')),
                ('ekstraadr', models.CharField(blank=True, max_length=255, verbose_name='ekstraadresse')),
                ('mobnr', models.CharField(blank=True, max_length=50, verbose_name='mobiltelefon')),
                ('heimenr', models.CharField(blank=True, max_length=50, verbose_name='heimetelefon')),
                ('bortepostnr', models.CharField(blank=True, help_text="T.d. '0864' eller 'c/o John Smith, 50012 OX-5, Oxford England'", max_length=255, null=True, verbose_name='borte-postnr')),
                ('borteadr', models.CharField(blank=True, help_text='Dersom borte-adressene er sett, vert post sendt her. For t.d. hybel- og utenlandsadresser.', max_length=255, null=True, verbose_name='borte-adresse')),
                ('gjer', models.CharField(blank=True, max_length=255, verbose_name='gjer')),
                ('kjon', models.CharField(choices=[('M', 'Mann'), ('K', 'Kvinne'), ('U', 'Udefinert')], default='U', max_length=1, verbose_name='kj\xf8nn')),
                ('merknad', models.TextField(blank=True, default='', verbose_name='merknad')),
                ('_siste_medlemspengar', models.PositiveIntegerField(blank=True, default=None, editable=False, null=True)),
                ('innmeldt_dato', models.DateField(default=datetime.date.today, verbose_name='innmeldt')),
                ('utmeldt_dato', models.DateField(blank=True, default=None, null=True, verbose_name='utmeldt')),
                ('status', models.CharField(choices=[('M', 'Vanleg medlem'), ('I', 'Infoperson'), ('L', 'Livstidsmedlem')], default='M', max_length=1, verbose_name='medlstatus')),
                ('innmeldingstype', models.CharField(choices=[('H', 'Heimesida'), ('M', 'M\xe5lferd'), ('V', 'Vervekampanje'), ('F', 'Flygeblad'), ('L', 'Lagsskiping/\xe5rsm\xf8te'), ('D', 'Direkteverva'), ('S', 'SMS'), ('O', 'Vitjing'), ('A', 'Anna'), ('U', '--')], default='U', max_length=1, verbose_name='innmtype')),
                ('innmeldingsdetalj', models.CharField(blank=True, help_text='Skriv inn vervemedlem i hakeparantesar ([1234])', max_length=255, verbose_name='detalj om innmelding')),
                ('oppretta', models.DateTimeField(auto_now_add=True, verbose_name='oppretta')),
                ('oppdatert', models.DateTimeField(auto_now=True, verbose_name='oppdatert')),
                ('nykel', models.CharField(blank=True, default=medlemssys.medlem.models.generate_password, max_length=255, verbose_name='nykel')),
                ('betalt_av', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='betalar_for', to='medlem.Medlem')),
                ('lokallag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='medlem.Lokallag')),
            ],
            options={
                'ordering': ['-id'],
                'verbose_name_plural': 'medlem',
            },
        ),
        migrations.CreateModel(
            name='PostNummer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('postnr', models.CharField(max_length=6)),
                ('poststad', models.CharField(max_length=50)),
                ('bruksomrade', models.CharField(max_length=50)),
                ('folketal', models.SmallIntegerField(blank=True, null=True)),
                ('bydel', models.CharField(max_length=50)),
                ('kommnr', models.CharField(max_length=50)),
                ('kommune', models.CharField(max_length=50)),
                ('fylke', models.CharField(max_length=50)),
                ('lat', models.FloatField()),
                ('lon', models.FloatField()),
                ('datakvalitet', models.SmallIntegerField()),
                ('sist_oppdatert', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'postnummer',
            },
        ),
        migrations.CreateModel(
            name='Rolle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lokallag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='rolle_set', to='medlem.Lokallag')),
                ('medlem', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='medlem.Medlem')),
            ],
            options={
                'ordering': ['rolletype', 'medlem'],
                'verbose_name_plural': 'roller',
            },
        ),
        migrations.CreateModel(
            name='Rolletype',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('namn', models.CharField(max_length=64, verbose_name='rollenamn')),
            ],
            options={
                'ordering': ['namn'],
                'verbose_name_plural': 'rolletyper',
            },
        ),
        migrations.CreateModel(
            name='Val',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tittel', models.CharField(max_length=100, unique=True, verbose_name='kort forklaring')),
                ('forklaring', models.TextField(blank=True, verbose_name='lang forklaring')),
            ],
            options={
                'verbose_name_plural': 'val',
            },
        ),
        migrations.AddField(
            model_name='rolle',
            name='rolletype',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='medlem.Rolletype'),
        ),
        migrations.AddField(
            model_name='medlem',
            name='lokallagsrolle',
            field=models.ManyToManyField(blank=True, related_name='rollemedlem', through='medlem.Rolle', to='medlem.Lokallag'),
        ),
        migrations.AddField(
            model_name='medlem',
            name='user',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='innloggingsbrukar'),
        ),
        migrations.AddField(
            model_name='medlem',
            name='val',
            field=models.ManyToManyField(blank=True, to='medlem.Val'),
        ),
        migrations.AddField(
            model_name='medlem',
            name='verva_av',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='har_verva', to='medlem.Medlem'),
        ),
        migrations.AddField(
            model_name='lokallagovervaking',
            name='medlem',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='medlem.Medlem'),
        ),
        migrations.AddField(
            model_name='giro',
            name='medlem',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='giroar', to='medlem.Medlem'),
        ),
    ]
