"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
let app;
let stack;
beforeEach(() => {
    app = new core_1.App();
    stack = new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test('Renders minimal example with just a load balancer', () => {
    const loadBalancer = elbv2.NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(stack, 'elbv2', {
        loadBalancerArn: 'arn:aws:elasticloadbalancing:us-west-2:111111111111:loadbalancer/net/mylb/5d1b75f4f1cee11e',
        loadBalancerDnsName: 'mylb-5d1b75f4f1cee11e.elb.us-west-2.amazonaws.com',
    });
    const origin = new lib_1.LoadBalancerV2Origin(loadBalancer);
    const originBindConfig = origin.bind(stack, { originId: 'StackOrigin029E19582' });
    expect(originBindConfig.originProperty).toEqual({
        id: 'StackOrigin029E19582',
        domainName: loadBalancer.loadBalancerDnsName,
        customOriginConfig: {
            originProtocolPolicy: 'https-only',
        },
    });
});
test('Can customize properties of the origin', () => {
    const loadBalancer = elbv2.NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(stack, 'elbv2', {
        loadBalancerArn: 'arn:aws:elasticloadbalancing:us-west-2:111111111111:loadbalancer/net/mylb/5d1b75f4f1cee11e',
        loadBalancerDnsName: 'mylb-5d1b75f4f1cee11e.elb.us-west-2.amazonaws.com',
    });
    const origin = new lib_1.LoadBalancerV2Origin(loadBalancer, {
        connectionAttempts: 3,
        connectionTimeout: core_1.Duration.seconds(5),
        protocolPolicy: cloudfront.OriginProtocolPolicy.MATCH_VIEWER,
    });
    const originBindConfig = origin.bind(stack, { originId: 'StackOrigin029E19582' });
    expect(originBindConfig.originProperty).toEqual({
        id: 'StackOrigin029E19582',
        domainName: loadBalancer.loadBalancerDnsName,
        connectionAttempts: 3,
        connectionTimeout: 5,
        customOriginConfig: {
            originProtocolPolicy: 'match-viewer',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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