# Generated by Django 3.2.10 on 2021-12-29 11:41

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('eveonline', '0015_factions'),
    ]

    operations = [
        migrations.CreateModel(
            name='AlumniSetup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name_plural': 'Alumni Config',
            },
        ),
        migrations.CreateModel(
            name='CharacterCorporationHistory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('corporation_id', models.PositiveIntegerField()),
                ('is_deleted', models.BooleanField(default=False, help_text='True if the corporation has been deleted')),
                ('record_id', models.IntegerField(help_text='An incrementing ID that can be used to canonically establish order of records in cases where dates may be ambiguous')),
                ('start_date', models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name='CorporationAllianceHistory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('corporation_id', models.PositiveIntegerField()),
                ('alliance_id', models.PositiveIntegerField(blank=True, null=True)),
                ('is_deleted', models.BooleanField(default=False, help_text='True if the corporation has been deleted')),
                ('record_id', models.IntegerField(help_text='An incrementing ID that can be used to canonically establish order of records in cases where dates may be ambiguous')),
                ('start_date', models.DateTimeField()),
            ],
        ),
        migrations.AddConstraint(
            model_name='corporationalliancehistory',
            constraint=models.UniqueConstraint(fields=('corporation_id', 'record_id'), name='CorporationAllianceRecord'),
        ),
        migrations.AddField(
            model_name='charactercorporationhistory',
            name='character',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveonline.evecharacter'),
        ),
        migrations.AddField(
            model_name='alumnisetup',
            name='alumni_alliances',
            field=models.ManyToManyField(blank=True, help_text='Characters with these Alliances in their History will be given Alumni Status', to='eveonline.EveAllianceInfo'),
        ),
        migrations.AddField(
            model_name='alumnisetup',
            name='alumni_corporations',
            field=models.ManyToManyField(blank=True, help_text='Characters with these Corps in their History will be given Alumni Status', to='eveonline.EveCorporationInfo'),
        ),
        migrations.AddConstraint(
            model_name='charactercorporationhistory',
            constraint=models.UniqueConstraint(fields=('character', 'record_id'), name='CharacterCorporationRecord'),
        ),
    ]
