import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Determine whether a role bypasses every row-level security (RLS) policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#bypass_row_level_security Role#bypass_row_level_security}
     *
     * @stability stable
     */
    readonly bypassRowLevelSecurity?: boolean | cdktf.IResolvable;
    /**
     * How many concurrent connections can be made with this role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#connection_limit Role#connection_limit}
     *
     * @stability stable
     */
    readonly connectionLimit?: number;
    /**
     * Define a role's ability to create databases.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#create_database Role#create_database}
     *
     * @stability stable
     */
    readonly createDatabase?: boolean | cdktf.IResolvable;
    /**
     * Determine whether this role will be permitted to create new roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#create_role Role#create_role}
     *
     * @stability stable
     */
    readonly createRole?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#encrypted Role#encrypted}.
     *
     * @stability stable
     */
    readonly encrypted?: string;
    /**
     * Control whether the password is stored encrypted in the system catalogs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#encrypted_password Role#encrypted_password}
     *
     * @stability stable
     */
    readonly encryptedPassword?: boolean | cdktf.IResolvable;
    /**
     * Terminate any session with an open transaction that has been idle for longer than the specified duration in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#idle_in_transaction_session_timeout Role#idle_in_transaction_session_timeout}
     *
     * @stability stable
     */
    readonly idleInTransactionSessionTimeout?: number;
    /**
     * Determine whether a role "inherits" the privileges of roles it is a member of.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#inherit Role#inherit}
     *
     * @stability stable
     */
    readonly inherit?: boolean | cdktf.IResolvable;
    /**
     * Determine whether a role is allowed to log in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#login Role#login}
     *
     * @stability stable
     */
    readonly login?: boolean | cdktf.IResolvable;
    /**
     * The name of the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#name Role#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Sets the role's password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#password Role#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Determine whether a role is allowed to initiate streaming replication or put the system in and out of backup mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#replication Role#replication}
     *
     * @stability stable
     */
    readonly replication?: boolean | cdktf.IResolvable;
    /**
     * Role(s) to grant to this new role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#roles Role#roles}
     *
     * @stability stable
     */
    readonly roles?: string[];
    /**
     * Sets the role's search path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#search_path Role#search_path}
     *
     * @stability stable
     */
    readonly searchPath?: string[];
    /**
     * Skip actually running the DROP ROLE command when removing a ROLE from PostgreSQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#skip_drop_role Role#skip_drop_role}
     *
     * @stability stable
     */
    readonly skipDropRole?: boolean | cdktf.IResolvable;
    /**
     * Skip actually running the REASSIGN OWNED command when removing a role from PostgreSQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#skip_reassign_owned Role#skip_reassign_owned}
     *
     * @stability stable
     */
    readonly skipReassignOwned?: boolean | cdktf.IResolvable;
    /**
     * Abort any statement that takes more than the specified number of milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#statement_timeout Role#statement_timeout}
     *
     * @stability stable
     */
    readonly statementTimeout?: number;
    /**
     * Determine whether the new role is a "superuser".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#superuser Role#superuser}
     *
     * @stability stable
     */
    readonly superuser?: boolean | cdktf.IResolvable;
    /**
     * Sets a date and time after which the role's password is no longer valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/role.html#valid_until Role#valid_until}
     *
     * @stability stable
     */
    readonly validUntil?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/role.html postgresql_role}.
 *
 * @stability stable
 */
export declare class Role extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/role.html postgresql_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _bypassRowLevelSecurity?;
    /**
     * @stability stable
     */
    get bypassRowLevelSecurity(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set bypassRowLevelSecurity(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetBypassRowLevelSecurity(): void;
    /**
     * @stability stable
     */
    get bypassRowLevelSecurityInput(): boolean | cdktf.IResolvable | undefined;
    private _connectionLimit?;
    /**
     * @stability stable
     */
    get connectionLimit(): number | undefined;
    /**
     * @stability stable
     */
    set connectionLimit(value: number | undefined);
    /**
     * @stability stable
     */
    resetConnectionLimit(): void;
    /**
     * @stability stable
     */
    get connectionLimitInput(): number | undefined;
    private _createDatabase?;
    /**
     * @stability stable
     */
    get createDatabase(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set createDatabase(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCreateDatabase(): void;
    /**
     * @stability stable
     */
    get createDatabaseInput(): boolean | cdktf.IResolvable | undefined;
    private _createRole?;
    /**
     * @stability stable
     */
    get createRole(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set createRole(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCreateRole(): void;
    /**
     * @stability stable
     */
    get createRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _encrypted?;
    /**
     * @stability stable
     */
    get encrypted(): string | undefined;
    /**
     * @stability stable
     */
    set encrypted(value: string | undefined);
    /**
     * @stability stable
     */
    resetEncrypted(): void;
    /**
     * @stability stable
     */
    get encryptedInput(): string | undefined;
    private _encryptedPassword?;
    /**
     * @stability stable
     */
    get encryptedPassword(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set encryptedPassword(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEncryptedPassword(): void;
    /**
     * @stability stable
     */
    get encryptedPasswordInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _idleInTransactionSessionTimeout?;
    /**
     * @stability stable
     */
    get idleInTransactionSessionTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set idleInTransactionSessionTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetIdleInTransactionSessionTimeout(): void;
    /**
     * @stability stable
     */
    get idleInTransactionSessionTimeoutInput(): number | undefined;
    private _inherit?;
    /**
     * @stability stable
     */
    get inherit(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set inherit(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInherit(): void;
    /**
     * @stability stable
     */
    get inheritInput(): boolean | cdktf.IResolvable | undefined;
    private _login?;
    /**
     * @stability stable
     */
    get login(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set login(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLogin(): void;
    /**
     * @stability stable
     */
    get loginInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _replication?;
    /**
     * @stability stable
     */
    get replication(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set replication(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetReplication(): void;
    /**
     * @stability stable
     */
    get replicationInput(): boolean | cdktf.IResolvable | undefined;
    private _roles?;
    /**
     * @stability stable
     */
    get roles(): string[] | undefined;
    /**
     * @stability stable
     */
    set roles(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRoles(): void;
    /**
     * @stability stable
     */
    get rolesInput(): string[] | undefined;
    private _searchPath?;
    /**
     * @stability stable
     */
    get searchPath(): string[] | undefined;
    /**
     * @stability stable
     */
    set searchPath(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSearchPath(): void;
    /**
     * @stability stable
     */
    get searchPathInput(): string[] | undefined;
    private _skipDropRole?;
    /**
     * @stability stable
     */
    get skipDropRole(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set skipDropRole(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSkipDropRole(): void;
    /**
     * @stability stable
     */
    get skipDropRoleInput(): boolean | cdktf.IResolvable | undefined;
    private _skipReassignOwned?;
    /**
     * @stability stable
     */
    get skipReassignOwned(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set skipReassignOwned(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSkipReassignOwned(): void;
    /**
     * @stability stable
     */
    get skipReassignOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _statementTimeout?;
    /**
     * @stability stable
     */
    get statementTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set statementTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetStatementTimeout(): void;
    /**
     * @stability stable
     */
    get statementTimeoutInput(): number | undefined;
    private _superuser?;
    /**
     * @stability stable
     */
    get superuser(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set superuser(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSuperuser(): void;
    /**
     * @stability stable
     */
    get superuserInput(): boolean | cdktf.IResolvable | undefined;
    private _validUntil?;
    /**
     * @stability stable
     */
    get validUntil(): string | undefined;
    /**
     * @stability stable
     */
    set validUntil(value: string | undefined);
    /**
     * @stability stable
     */
    resetValidUntil(): void;
    /**
     * @stability stable
     */
    get validUntilInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
