"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Analytics = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const es = require("@aws-cdk/aws-elasticsearch");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class Analytics extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        const account = cdk.Stack.of(this).account;
        const esDomainName = (_b = props.domainName) !== null && _b !== void 0 ? _b : props.clusterId;
        this.vpc = props.vpc;
        // PolicyName: ElasticsearchPermissions
        const trustedSourceIpCidr = [
            `${props.sechedulerPublicIp}/32`,
        ];
        if (props.clientIpCidr)
            trustedSourceIpCidr.push(props.clientIpCidr);
        const elasticsearchPermissionsPolicy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: [
                'es:ESHttp*',
            ],
            principals: [new iam.AccountRootPrincipal()],
            conditions: {
                IpAddress: { 'aws:SourceIp': trustedSourceIpCidr },
            },
            resources: [`arn:aws:es:${region}:${account}:domain/${esDomainName}/*`],
        });
        //Create Elasticsearch service
        const esDomain = new es.Domain(this, 'ElasticsearchDomain', {
            version: es.ElasticsearchVersion.V7_4,
            domainName: esDomainName,
            nodeToNodeEncryption: true,
            encryptionAtRest: {
                enabled: true,
            },
            ebs: {
                volumeSize: 100,
                volumeType: ec2.EbsDeviceVolumeType.GP2,
                enabled: true,
            },
            capacity: {
                masterNodeInstanceType: 'm5.large.elasticsearch',
                dataNodes: 2,
                dataNodeInstanceType: 'm5.large.elasticsearch',
            },
            zoneAwareness: {
                enabled: true,
            },
            automatedSnapshotStartHour: 0,
            accessPolicies: [
                elasticsearchPermissionsPolicy,
            ],
            enforceHttps: true,
            logging: {
                slowSearchLogEnabled: true,
                appLogEnabled: true,
                slowIndexLogEnabled: true,
            },
            removalPolicy: (_c = props.removalPolicy) !== null && _c !== void 0 ? _c : cdk.RemovalPolicy.DESTROY,
        });
        new cdk.CfnOutput(this, 'ESDomainArn:', { value: esDomain.domainArn });
        new cdk.CfnOutput(this, 'ESDomainEndpoint:', { value: esDomain.domainEndpoint });
    }
}
exports.Analytics = Analytics;
_a = JSII_RTTI_SYMBOL_1;
Analytics[_a] = { fqn: "cdk-soca.Analytics", version: "0.2.42" };
//# sourceMappingURL=data:application/json;base64,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