"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IamRoles = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * (experimental) Create all required IAM roles.
 *
 * @experimental
 */
class IamRoles extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const urlsuffix = cdk.Stack.of(this).urlSuffix;
        const stack = cdk.Stack.of(this);
        const region = cdk.Stack.of(this).region;
        // ComputeNodeIAMRole
        const computeNodeIamRole = new iam.Role(this, 'ComputeNodeIamRole', {
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal(`ec2.${urlsuffix}`), new iam.ServicePrincipal(`ssm.${urlsuffix}`)),
        });
        computeNodeIamRole.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // PolicyName: ComputeNodePermissions
        const computeNodePermissionsPolicy = new iam.Policy(this, 'ComputeNodePermissionsPolicy');
        computeNodePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                's3:GetObject',
                's3:ListBucket',
                's3:PutObject',
            ],
            resources: [
                // S3InstallBucket/*
                stack.formatArn({
                    service: 's3',
                    account: '',
                    resource: '',
                    region: '',
                    resourceName: `${props.s3InstallBucketName}/*`,
                }),
                // S3InstallBucket
                stack.formatArn({
                    service: 's3',
                    account: '',
                    resource: '',
                    region: '',
                    resourceName: `${props.s3InstallBucketName}`,
                }),
            ],
        }));
        computeNodePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                's3:GetObject',
                's3:ListBucket',
            ],
            resources: [
                stack.formatArn({
                    service: 's3',
                    account: '',
                    resource: '',
                    region: '',
                    resourceName: `dcv-license.${region}/*`,
                }),
                stack.formatArn({
                    service: 's3',
                    account: '',
                    resource: '',
                    region: '',
                    resourceName: 'ec2-linux-nvidia-drivers/*',
                }),
                stack.formatArn({
                    service: 's3',
                    account: '',
                    resource: '',
                    region: '',
                    resourceName: 'ec2-linux-nvidia-drivers',
                }),
            ],
        }));
        computeNodePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: ['ses:SendEmail'],
            resources: [
                stack.formatArn({ service: 'ses', resource: 'identity' }),
            ],
        }));
        computeNodePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: ['ec2:CreateTags'],
            resources: [
                stack.formatArn({ service: 'ec2', resource: 'volume' }),
                stack.formatArn({ service: 'ec2', resource: 'network-interface' }),
            ],
        }));
        computeNodePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'ec2:DescribeVolumes',
                'ec2:DescribeNetworkInterfaces',
                'fsx:CreateDataRepositoryTask',
                'fsx:DescribeFileSystems',
                'tag:GetResources',
                'tag:GetTagValues',
                'tag:GetTagKeys',
            ],
            resources: ['*'],
        }));
        // attach to the role
        computeNodePermissionsPolicy.attachToRole(computeNodeIamRole);
        this.computeNodeIamRole = computeNodeIamRole;
        // ComputeNodeInstanceProfile
        this.computeNodeInstanceProfileName = new iam.CfnInstanceProfile(this, 'ComputeNodeInstanceProfile', {
            roles: [this.computeNodeIamRole.roleName],
        }).ref;
        // SpotFleetIAMRole
        const spotFleetIAMRole = new iam.Role(this, 'SpotFleetIAMRole', {
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal(`spotfleet.${urlsuffix}`)),
        });
        // PolicyName: SpotFleetPermissions
        const spotFleetPermissionsPolicy = new iam.Policy(this, 'SpotFleetPermissionsPolicy');
        spotFleetPermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'ec2:DescribeImages',
                'ec2:DescribeSubnets',
                'ec2:DescribeInstanceStatus',
            ],
            resources: ['*'],
        }));
        spotFleetPermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'ec2:RequestSpotInstances',
                'ec2:TerminateInstances',
                'ec2:CreateTags',
            ],
            resources: [
                stack.formatArn({ service: 'ec2', resource: 'instance' }),
            ],
            conditions: {
                'ForAllValues:ArnEqualsIfExists': {
                    'ec2:Vpc': stack.formatArn({ service: 'ec2', resource: 'vpc', resourceName: props.network.vpc.vpcId }),
                },
            },
        }));
        spotFleetPermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'iam:PassRole',
            ],
            resources: [
                computeNodeIamRole.roleArn,
            ],
            conditions: {
                StringEquals: {
                    'iam:PassedToService': [
                        'ec2.amazonaws.com',
                        'ec2.amazonaws.com.cn',
                    ],
                },
            },
        }));
        spotFleetPermissionsPolicy.attachToRole(spotFleetIAMRole);
        // SchedulerIAMRole
        const schedulerIAMRole = new iam.Role(this, 'SchedulerIAMRole', {
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal(`ec2.${urlsuffix}`), new iam.ServicePrincipal(`ssm.${urlsuffix}`)),
        });
        schedulerIAMRole.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // PolicyName: SchedulerReadPermissions
        const schedulerReadPermissionsPolicy = new iam.Policy(this, 'SchedulerReadPermissionsPolicy');
        schedulerReadPermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'pricing:GetProducts',
                'budgets:ViewBudget',
                'ec2:DescribeInstances',
                'ec2:DescribeSubnets',
                'ec2:DescribeSecurityGroups',
                'ec2:DescribeImages',
                'ec2:DescribeInstanceAttribute',
                'ec2:DescribeInstanceTypes',
                'ec2:DescribeReservedInstances',
                'ec2:DescribeSpotInstanceRequests',
                'ec2:DescribeVpcClassicLink',
                'ec2:DescribeVolumes',
                'ec2:DescribePlacementGroups',
                'ec2:DescribeKeyPairs',
                'ec2:DescribeLaunchTemplates',
                'ec2:DescribeLaunchTemplateVersions',
                'ec2:DescribeNetworkInterfaces',
                'ec2:DescribeSpotFleetRequests',
                'ec2:DescribeSpotFleetInstances',
                'fsx:DescribeFileSystems',
                'autoscaling:DescribeAutoScalingGroups',
                'autoscaling:DescribeScalingActivities',
                'autoscaling:DescribeLaunchConfigurations',
                'elasticloadbalancing:DescribeRules',
                'elasticloadbalancing:DescribeListeners',
                'elasticloadbalancing:DescribeTargetGroups',
                'savingsplans:DescribeSavingsPlans',
                'servicequotas:ListServiceQuotas',
            ],
            resources: ['*'],
        }));
        // PolicyName: SchedulerWritePermissions
        const schedulerWritePermissionsPolicy = new iam.Policy(this, 'SchedulerWritePermissionsPolicy');
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'autoscaling:UpdateAutoScalingGroup',
                'autoscaling:DeleteAutoScalingGroup',
                'autoscaling:CreateAutoScalingGroup',
                'autoscaling:DetachInstances',
                'ec2:DeleteLaunchTemplate',
                'ec2:CreateLaunchTemplate',
                'fsx:CreateDataRepositoryTask',
            ],
            resources: ['*'],
            conditions: {
                StringLikeIfExists: {
                    'autoscaling:LaunchConfigurationName': props.network.clusterId,
                },
            },
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'ec2:CreateTags',
            ],
            resources: [
                stack.formatArn({ service: 'ec2', resource: 'volume' }),
                stack.formatArn({ service: 'ec2', resource: 'network-interface' }),
                stack.formatArn({ service: 'ec2', resource: 'instance' }),
            ],
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'cloudformation:CreateStack',
                'cloudformation:DeleteStack',
                'cloudformation:DescribeStacks',
            ],
            resources: ['*'],
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'ec2:RunInstances',
                'ec2:TerminateInstances',
                'ec2:CreatePlacementGroup',
                'ec2:DeletePlacementGroup',
            ],
            resources: [
                stack.formatArn({ service: 'ec2', resource: 'subnet' }),
                stack.formatArn({ service: 'ec2', resource: 'key-pair' }),
                stack.formatArn({ service: 'ec2', resource: 'instance' }),
                stack.formatArn({ service: 'ec2', resource: 'snapshot', account: '' }),
                stack.formatArn({ service: 'ec2', resource: 'launch-template' }),
                stack.formatArn({ service: 'ec2', resource: 'volume' }),
                stack.formatArn({ service: 'ec2', resource: 'security-group' }),
                stack.formatArn({ service: 'ec2', resource: 'placement-group' }),
                stack.formatArn({ service: 'ec2', resource: 'network-interface' }),
                stack.formatArn({ service: 'ec2', resource: 'image', account: '' }),
            ],
            conditions: {
                'ForAllValues:ArnEqualsIfExists': {
                    'ec2:Vpc': stack.formatArn({ service: 'ec2', resource: 'vpc', resourceName: props.network.vpc.vpcId }),
                },
            },
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: ['lambda:InvokeFunction'],
            resources: [
                stack.formatArn({
                    service: 'lambda',
                    resource: 'function',
                    resourceName: `${props.network.clusterId}-Metrics`,
                }),
            ],
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: ['fsx:CreateFileSystem'],
            resources: [
                stack.formatArn({
                    service: 'fsx',
                    resource: 'file-system',
                }),
            ],
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: ['fsx:DeleteFileSystem'],
            resources: [
                stack.formatArn({
                    service: 'fsx',
                    resource: 'file-system',
                }),
            ],
            conditions: {
                StringLike: {
                    'aws:ResourceTag/soca:ClusterId': props.network.clusterId,
                },
            },
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'iam:CreateServiceLinkedRole',
                'iam:AttachRolePolicy',
                'iam:PutRolePolicy',
            ],
            resources: [
                stack.formatArn({
                    service: 'iam',
                    resource: 'role',
                    region: '',
                    resourceName: 'aws-service-role/s3.data-source.lustre.fsx.amazonaws.com',
                }),
                stack.formatArn({
                    service: 'iam',
                    resource: 'role',
                    region: '',
                    resourceName: 'aws-service-role/autoscaling.amazonaws.com',
                }),
                stack.formatArn({
                    service: 'iam',
                    resource: 'role',
                    region: '',
                    resourceName: 'aws-service-role/spotfleet.amazonaws.com',
                }),
            ],
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'ses:SendEmail',
            ],
            resources: [
                stack.formatArn({
                    service: 'ses',
                    resource: 'identity',
                }),
            ],
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'ec2:CreatePlacementGroup',
                'ec2:DeletePlacementGroup',
                'ec2:RequestSpotFleet',
                'ec2:ModifySpotFleetRequest',
                'ec2:CancelSpotFleetRequests',
            ],
            resources: ['*'],
            conditions: {
                'ForAllValues:ArnEqualsIfExists': {
                    'ec2:Vpc': stack.formatArn({ service: 'ec2', resource: 'vpc', resourceName: props.network.vpc.vpcId }),
                },
            },
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                's3:GetObject',
                's3:ListBucket',
                's3:PutObject',
            ],
            resources: [
                // S3InstallBucket/*
                stack.formatArn({
                    service: 's3',
                    account: '',
                    resource: '',
                    region: '',
                    resourceName: `${props.s3InstallBucketName}/*`,
                }),
                // S3InstallBucket
                stack.formatArn({
                    service: 's3',
                    account: '',
                    resource: '',
                    region: '',
                    resourceName: `${props.s3InstallBucketName}`,
                }),
            ],
            conditions: {
                'ForAllValues:ArnEqualsIfExists': {
                    'ec2:Vpc': stack.formatArn({ service: 'ec2', resource: 'vpc', resourceName: props.network.vpc.vpcId }),
                },
            },
        }));
        schedulerWritePermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'iam:PassRole',
                'iam:CreateServiceLinkedRole',
            ],
            resources: [
                computeNodeIamRole.roleArn,
                spotFleetIAMRole.roleArn,
            ],
            conditions: {
                'ForAllValues:ArnEqualsIfExists': {
                    'ec2:Vpc': stack.formatArn({ service: 'ec2', resource: 'vpc', resourceName: props.network.vpc.vpcId }),
                },
            },
        }));
        // attach to the role
        schedulerWritePermissionsPolicy.attachToRole(schedulerIAMRole);
        this.schedulerIAMRole = schedulerIAMRole;
        // SchedulerIAMInstanceProfile
        this.schedulerIamInstanceProfileName = new iam.CfnInstanceProfile(this, 'SchedulerIamInstanceProfileName', {
            roles: [this.schedulerIAMRole.roleName],
        }).ref;
        // LambdaSolutionMetricRole
        const lambdaSolutionMetricRole = new iam.Role(this, 'LambdaSolutionMetricRole', {
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal(`lambda.${urlsuffix}`)),
        });
        // PolicyName: SolutionMetric
        const solutionMetricPolicy = new iam.Policy(this, 'SolutionMetricPolicy');
        spotFleetPermissionsPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'logs:CreateLogGroup',
            ],
            resources: [
                stack.formatArn({
                    service: 'logs',
                    resource: 'log-group',
                    resourceName: `/aws/lambda/${props.network.clusterId}*`,
                }),
            ],
        }));
        solutionMetricPolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'logs:CreateLogStream',
                'logs:PutLogEvents',
                'logs:DeleteLogStream',
            ],
            resources: [
                stack.formatArn({
                    service: 'logs',
                    resource: 'log-group',
                    resourceName: `/aws/lambda/${props.network.clusterId}*:log-stream:*`,
                }),
            ],
        }));
        solutionMetricPolicy.attachToRole(lambdaSolutionMetricRole);
        // LambdaACMIAMRole
        const lambdaACMIAMRole = new iam.Role(this, 'LambdaACMIAMRole', {
            assumedBy: new iam.CompositePrincipal(new iam.ServicePrincipal(`lambda.${urlsuffix}`)),
        });
        // PolicyName: ${clusterId}-LambdaACMIamRole-Policy
        const lambdaACMIamRolePolicy = new iam.Policy(this, 'LambdaACMIamRolePolicy');
        lambdaACMIamRolePolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'logs:CreateLogGroup',
            ],
            resources: [
                stack.formatArn({
                    service: 'logs',
                    resource: 'log-group',
                    resourceName: `/aws/lambda/${props.network.clusterId}*`,
                }),
            ],
        }));
        lambdaACMIamRolePolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'logs:CreateLogStream',
                'logs:PutLogEvents',
            ],
            resources: [
                stack.formatArn({
                    service: 'logs',
                    resource: 'log-group',
                    resourceName: `/aws/lambda/${props.network.clusterId}*:log-stream:*`,
                }),
            ],
        }));
        lambdaACMIamRolePolicy.addStatements(new iam.PolicyStatement({
            actions: [
                'acm:ImportCertificate',
                'acm:ListCertificates',
                'acm:AddTagsToCertificate',
            ],
            resources: ['*'],
        }));
        lambdaACMIamRolePolicy.attachToRole(lambdaACMIAMRole);
    }
}
exports.IamRoles = IamRoles;
_a = JSII_RTTI_SYMBOL_1;
IamRoles[_a] = { fqn: "cdk-soca.IamRoles", version: "0.2.42" };
//# sourceMappingURL=data:application/json;base64,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