"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const analytics_1 = require("./analytics");
const iam_roles_1 = require("./iam-roles");
const network_1 = require("./network");
const scheduler_1 = require("./scheduler");
const storage_1 = require("./storage");
/**
 * @experimental
 */
class Workload extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e;
        super(scope, id);
        const stack = cdk.Stack.of(this);
        const s3InstallBucket = (_b = props.s3InstallBucket) !== null && _b !== void 0 ? _b : 'solutions-reference';
        const s3InstallFolder = (_c = props.s3InstallFolder) !== null && _c !== void 0 ? _c : 'scale-out-computing-on-aws/v2.5.0';
        // network construct
        const network = new network_1.Network(stack, 'SocaNetwork');
        // assets construct
        // const assets = new Assets(stack, 'S3Assets');
        // iam roles
        new iam_roles_1.IamRoles(stack, 'IamRoles', {
            s3InstallBucketName: s3InstallBucket,
            network,
        });
        // compute node security group
        const computeNodeSecurityGroup = new aws_ec2_1.SecurityGroup(this, 'ComputeNodeSecurityGroup', {
            vpc: network.vpc,
            allowAllOutbound: false,
        });
        // explicitly allow the egress of the security group
        computeNodeSecurityGroup.connections.allowToAnyIpv4(aws_ec2_1.Port.allTcp());
        computeNodeSecurityGroup.connections.allowToAnyIpv4(aws_ec2_1.Port.allUdp());
        computeNodeSecurityGroup.connections.allowToAnyIpv4(aws_ec2_1.Port.allIcmp());
        /**
         * Allow all traffic internally
         */
        computeNodeSecurityGroup.connections.allowInternally(aws_ec2_1.Port.allTcp());
        computeNodeSecurityGroup.connections.allowInternally(aws_ec2_1.Port.allUdp());
        computeNodeSecurityGroup.connections.allowInternally(aws_ec2_1.Port.allIcmp());
        const schedulerSecurityGroup = new aws_ec2_1.SecurityGroup(this, 'SchedulerSecurityGroup', {
            vpc: network.vpc,
            allowAllOutbound: false,
        });
        // explicitly allow the egress of the security group
        schedulerSecurityGroup.connections.allowToAnyIpv4(aws_ec2_1.Port.allTcp());
        schedulerSecurityGroup.connections.allowToAnyIpv4(aws_ec2_1.Port.allUdp());
        schedulerSecurityGroup.connections.allowToAnyIpv4(aws_ec2_1.Port.allIcmp());
        /**
         * SchedulerInboundRule
         * Allow all traffic from computeNodeSecurityGroup to schedulerSecurityGroup
         */
        schedulerSecurityGroup.connections.allowFrom(computeNodeSecurityGroup, aws_ec2_1.Port.allTcp());
        schedulerSecurityGroup.connections.allowFrom(computeNodeSecurityGroup, aws_ec2_1.Port.allUdp());
        schedulerSecurityGroup.connections.allowFrom(computeNodeSecurityGroup, aws_ec2_1.Port.allIcmp());
        /**
         * SchedulerInboundRuleAllowClientIP
         * SchedulerInboundRuleAllowClientIPHTTPS
         * SchedulerInboundRuleAllowClientIPHTTP
         * 1. Allow SSH traffic from client IP to master host
         * 2. Allow HTTP traffic from client IP to ELB
         * 3. Allow HTTPS traffic from client IP to ELB
         */
        if (props.clientIpCidr) {
            schedulerSecurityGroup.connections.allowFrom(aws_ec2_1.Peer.ipv4(props.clientIpCidr), aws_ec2_1.Port.tcp(22));
            schedulerSecurityGroup.connections.allowFrom(aws_ec2_1.Peer.ipv4(props.clientIpCidr), aws_ec2_1.Port.tcp(80));
            schedulerSecurityGroup.connections.allowFrom(aws_ec2_1.Peer.ipv4(props.clientIpCidr), aws_ec2_1.Port.tcp(443));
        }
        /**
         * Allow traffic between Master agent and compute nodes
         */
        computeNodeSecurityGroup.connections.allowFrom(schedulerSecurityGroup, aws_ec2_1.Port.allTcp());
        computeNodeSecurityGroup.connections.allowFrom(schedulerSecurityGroup, aws_ec2_1.Port.allUdp());
        /**
         * Allow ELB healtcheck to communicate with web ui on master host
         */
        schedulerSecurityGroup.connections.allowInternally(aws_ec2_1.Port.tcp(8443));
        const storage = new storage_1.EfsStorage(stack, 'EfsStorage', {
            clusterId: network.clusterId,
            vpc: network.vpc,
            schedulerSecurityGroup,
            computeNodeSecurityGroup,
        });
        const scheduler = new scheduler_1.Scheduler(stack, 'Scheduler', {
            s3InstallBucket,
            s3InstallFolder,
            schedulerSecurityGroup,
            network,
            storage,
            instanceType: new aws_ec2_1.InstanceType('m5.large'),
            ldapUserName: (_d = props.ldapUserName) !== null && _d !== void 0 ? _d : 'ldapUserName',
            ldapUserPassword: (_e = props.ldapUserPassword) !== null && _e !== void 0 ? _e : 'ldapUserPassword!123',
        });
        // add elasticsearch stack
        new analytics_1.Analytics(stack, 'Analytics', {
            vpc: network.vpc,
            clientIpCidr: props.clientIpCidr,
            sechedulerPublicIp: scheduler.publicIp,
            schedulerSecurityGroup: schedulerSecurityGroup,
            clusterId: network.clusterId,
        });
    }
}
exports.Workload = Workload;
_a = JSII_RTTI_SYMBOL_1;
Workload[_a] = { fqn: "cdk-soca.Workload", version: "0.2.42" };
//# sourceMappingURL=data:application/json;base64,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