import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';
import { Network } from './network';
import { EfsStorage } from './storage';
/**
 * @experimental
 */
export declare enum BaseOS {
    /**
     * @experimental
     */
    CENTOS_7 = "centos7",
    /**
     * @experimental
     */
    RHEL_7 = "rhel7",
    /**
     * @experimental
     */
    AMZN2 = "amazonlinux2"
}
/**
 * @experimental
 */
export interface SchedulerProps {
    /**
     * @experimental
     */
    readonly customAmi?: string;
    /**
     * @experimental
     */
    readonly baseOs?: BaseOS;
    /**
     * @experimental
     */
    readonly network: Network;
    /**
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * @experimental
     */
    readonly s3InstallBucket: string;
    /**
     * @experimental
     */
    readonly s3InstallFolder: string;
    /**
     * @experimental
     */
    readonly ldapUserName: string;
    /**
     * @experimental
     */
    readonly ldapUserPassword: string;
    /**
     * @experimental
     */
    readonly schedulerSecurityGroup: ec2.ISecurityGroup;
    /**
     * @experimental
     */
    readonly storage: EfsStorage;
}
/**
 * @experimental
 */
export declare class Scheduler extends cdk.Construct {
    /**
     * @experimental
     */
    readonly publicIp: string;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: SchedulerProps);
}
