import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BinaryAuthorizationAttestorIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#attestor BinaryAuthorizationAttestorIamBinding#attestor}
    */
    readonly attestor: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#members BinaryAuthorizationAttestorIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#project BinaryAuthorizationAttestorIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#role BinaryAuthorizationAttestorIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#condition BinaryAuthorizationAttestorIamBinding#condition}
    */
    readonly condition?: BinaryAuthorizationAttestorIamBindingCondition;
}
export interface BinaryAuthorizationAttestorIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#description BinaryAuthorizationAttestorIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#expression BinaryAuthorizationAttestorIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding#title BinaryAuthorizationAttestorIamBinding#title}
    */
    readonly title: string;
}
export declare function binaryAuthorizationAttestorIamBindingConditionToTerraform(struct?: BinaryAuthorizationAttestorIamBindingConditionOutputReference | BinaryAuthorizationAttestorIamBindingCondition): any;
export declare class BinaryAuthorizationAttestorIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BinaryAuthorizationAttestorIamBindingCondition | undefined;
    set internalValue(value: BinaryAuthorizationAttestorIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding google_binary_authorization_attestor_iam_binding}
*/
export declare class BinaryAuthorizationAttestorIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_binary_authorization_attestor_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor_iam_binding google_binary_authorization_attestor_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BinaryAuthorizationAttestorIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: BinaryAuthorizationAttestorIamBindingConfig);
    private _attestor?;
    get attestor(): string;
    set attestor(value: string);
    get attestorInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): BinaryAuthorizationAttestorIamBindingConditionOutputReference;
    putCondition(value: BinaryAuthorizationAttestorIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): BinaryAuthorizationAttestorIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
