import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerAzureVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_azure_versions#location DataGoogleContainerAzureVersions#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_azure_versions#project DataGoogleContainerAzureVersions#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/container_azure_versions google_container_azure_versions}
*/
export declare class DataGoogleContainerAzureVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_container_azure_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_azure_versions google_container_azure_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerAzureVersionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleContainerAzureVersionsConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get supportedRegions(): string[];
    get validVersions(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
