import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FolderIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member#folder FolderIamMember#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member#member FolderIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member#role FolderIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member#condition FolderIamMember#condition}
    */
    readonly condition?: FolderIamMemberCondition;
}
export interface FolderIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member#description FolderIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member#expression FolderIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member#title FolderIamMember#title}
    */
    readonly title: string;
}
export declare function folderIamMemberConditionToTerraform(struct?: FolderIamMemberConditionOutputReference | FolderIamMemberCondition): any;
export declare class FolderIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderIamMemberCondition | undefined;
    set internalValue(value: FolderIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member google_folder_iam_member}
*/
export declare class FolderIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_folder_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_iam_member google_folder_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FolderIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: FolderIamMemberConfig);
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): FolderIamMemberConditionOutputReference;
    putCondition(value: FolderIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): FolderIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
