import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapAppEngineServiceIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_policy#app_id IapAppEngineServiceIamPolicy#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_policy#policy_data IapAppEngineServiceIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_policy#project IapAppEngineServiceIamPolicy#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_policy#service IapAppEngineServiceIamPolicy#service}
    */
    readonly service: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_policy google_iap_app_engine_service_iam_policy}
*/
export declare class IapAppEngineServiceIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_app_engine_service_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_service_iam_policy google_iap_app_engine_service_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapAppEngineServiceIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: IapAppEngineServiceIamPolicyConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
