import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagementConnectivityTestConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user-supplied description of the Connectivity Test.
  Maximum of 512 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#description NetworkManagementConnectivityTest#description}
    */
    readonly description?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#labels NetworkManagementConnectivityTest#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Unique name for the connectivity test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#name NetworkManagementConnectivityTest#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#project NetworkManagementConnectivityTest#project}
    */
    readonly project?: string;
    /**
    * IP Protocol of the test. When not provided, "TCP" is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#protocol NetworkManagementConnectivityTest#protocol}
    */
    readonly protocol?: string;
    /**
    * Other projects that may be relevant for reachability analysis.
  This is applicable to scenarios where a test can cross project
  boundaries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#related_projects NetworkManagementConnectivityTest#related_projects}
    */
    readonly relatedProjects?: string[];
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#destination NetworkManagementConnectivityTest#destination}
    */
    readonly destination: NetworkManagementConnectivityTestDestination;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#source NetworkManagementConnectivityTest#source}
    */
    readonly source: NetworkManagementConnectivityTestSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#timeouts NetworkManagementConnectivityTest#timeouts}
    */
    readonly timeouts?: NetworkManagementConnectivityTestTimeouts;
}
export interface NetworkManagementConnectivityTestDestination {
    /**
    * A Compute Engine instance URI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#instance NetworkManagementConnectivityTest#instance}
    */
    readonly instance?: string;
    /**
    * The IP address of the endpoint, which can be an external or
  internal IP. An IPv6 address is only allowed when the test's
  destination is a global load balancer VIP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#ip_address NetworkManagementConnectivityTest#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * A Compute Engine network URI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#network NetworkManagementConnectivityTest#network}
    */
    readonly network?: string;
    /**
    * The IP protocol port of the endpoint. Only applicable when
  protocol is TCP or UDP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#port NetworkManagementConnectivityTest#port}
    */
    readonly port?: number;
    /**
    * Project ID where the endpoint is located. The Project ID can be
  derived from the URI if you provide a VM instance or network URI.
  The following are two cases where you must provide the project ID:
  1. Only the IP address is specified, and the IP address is within
  a GCP project. 2. When you are using Shared VPC and the IP address
  that you provide is from the service project. In this case, the
  network that the IP address resides in is defined in the host
  project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#project_id NetworkManagementConnectivityTest#project_id}
    */
    readonly projectId?: string;
}
export declare function networkManagementConnectivityTestDestinationToTerraform(struct?: NetworkManagementConnectivityTestDestinationOutputReference | NetworkManagementConnectivityTestDestination): any;
export declare class NetworkManagementConnectivityTestDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagementConnectivityTestDestination | undefined;
    set internalValue(value: NetworkManagementConnectivityTestDestination | undefined);
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface NetworkManagementConnectivityTestSource {
    /**
    * A Compute Engine instance URI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#instance NetworkManagementConnectivityTest#instance}
    */
    readonly instance?: string;
    /**
    * The IP address of the endpoint, which can be an external or
  internal IP. An IPv6 address is only allowed when the test's
  destination is a global load balancer VIP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#ip_address NetworkManagementConnectivityTest#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * A Compute Engine network URI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#network NetworkManagementConnectivityTest#network}
    */
    readonly network?: string;
    /**
    * Type of the network where the endpoint is located. Possible values: ["GCP_NETWORK", "NON_GCP_NETWORK"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#network_type NetworkManagementConnectivityTest#network_type}
    */
    readonly networkType?: string;
    /**
    * The IP protocol port of the endpoint. Only applicable when
  protocol is TCP or UDP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#port NetworkManagementConnectivityTest#port}
    */
    readonly port?: number;
    /**
    * Project ID where the endpoint is located. The Project ID can be
  derived from the URI if you provide a VM instance or network URI.
  The following are two cases where you must provide the project ID:
  
  1. Only the IP address is specified, and the IP address is
     within a GCP project.
  2. When you are using Shared VPC and the IP address
     that you provide is from the service project. In this case,
     the network that the IP address resides in is defined in the
     host project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#project_id NetworkManagementConnectivityTest#project_id}
    */
    readonly projectId?: string;
}
export declare function networkManagementConnectivityTestSourceToTerraform(struct?: NetworkManagementConnectivityTestSourceOutputReference | NetworkManagementConnectivityTestSource): any;
export declare class NetworkManagementConnectivityTestSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagementConnectivityTestSource | undefined;
    set internalValue(value: NetworkManagementConnectivityTestSource | undefined);
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkType?;
    get networkType(): string;
    set networkType(value: string);
    resetNetworkType(): void;
    get networkTypeInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
export interface NetworkManagementConnectivityTestTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#create NetworkManagementConnectivityTest#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#delete NetworkManagementConnectivityTest#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test#update NetworkManagementConnectivityTest#update}
    */
    readonly update?: string;
}
export declare function networkManagementConnectivityTestTimeoutsToTerraform(struct?: NetworkManagementConnectivityTestTimeoutsOutputReference | NetworkManagementConnectivityTestTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagementConnectivityTestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagementConnectivityTestTimeouts | undefined;
    set internalValue(value: NetworkManagementConnectivityTestTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test google_network_management_connectivity_test}
*/
export declare class NetworkManagementConnectivityTest extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_management_connectivity_test";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test google_network_management_connectivity_test} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagementConnectivityTestConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagementConnectivityTestConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _relatedProjects?;
    get relatedProjects(): string[];
    set relatedProjects(value: string[]);
    resetRelatedProjects(): void;
    get relatedProjectsInput(): string[] | undefined;
    private _destination;
    get destination(): NetworkManagementConnectivityTestDestinationOutputReference;
    putDestination(value: NetworkManagementConnectivityTestDestination): void;
    get destinationInput(): NetworkManagementConnectivityTestDestination | undefined;
    private _source;
    get source(): NetworkManagementConnectivityTestSourceOutputReference;
    putSource(value: NetworkManagementConnectivityTestSource): void;
    get sourceInput(): NetworkManagementConnectivityTestSource | undefined;
    private _timeouts;
    get timeouts(): NetworkManagementConnectivityTestTimeoutsOutputReference;
    putTimeouts(value: NetworkManagementConnectivityTestTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkManagementConnectivityTestTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
