import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCertificateTemplateIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#certificate_template PrivatecaCertificateTemplateIamBinding#certificate_template}
    */
    readonly certificateTemplate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#location PrivatecaCertificateTemplateIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#members PrivatecaCertificateTemplateIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#project PrivatecaCertificateTemplateIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#role PrivatecaCertificateTemplateIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#condition PrivatecaCertificateTemplateIamBinding#condition}
    */
    readonly condition?: PrivatecaCertificateTemplateIamBindingCondition;
}
export interface PrivatecaCertificateTemplateIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#description PrivatecaCertificateTemplateIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#expression PrivatecaCertificateTemplateIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding#title PrivatecaCertificateTemplateIamBinding#title}
    */
    readonly title: string;
}
export declare function privatecaCertificateTemplateIamBindingConditionToTerraform(struct?: PrivatecaCertificateTemplateIamBindingConditionOutputReference | PrivatecaCertificateTemplateIamBindingCondition): any;
export declare class PrivatecaCertificateTemplateIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateTemplateIamBindingCondition | undefined;
    set internalValue(value: PrivatecaCertificateTemplateIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding google_privateca_certificate_template_iam_binding}
*/
export declare class PrivatecaCertificateTemplateIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_certificate_template_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_binding google_privateca_certificate_template_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatecaCertificateTemplateIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateTemplateIamBindingConfig);
    private _certificateTemplate?;
    get certificateTemplate(): string;
    set certificateTemplate(value: string);
    get certificateTemplateInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): PrivatecaCertificateTemplateIamBindingConditionOutputReference;
    putCondition(value: PrivatecaCertificateTemplateIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): PrivatecaCertificateTemplateIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
