import * as codepipeline from '@aws-cdk/aws-codepipeline';
import { Action } from '../action';
import { IJenkinsProvider } from './jenkins-provider';
import { Construct } from '@aws-cdk/core';
/**
 * The type of the Jenkins Action that determines its CodePipeline Category - Build, or Test.
 *
 * Note that a Jenkins provider, even if it has the same name,
 * must be separately registered for each type.
 *
 * @stability stable
 */
export declare enum JenkinsActionType {
    /**
     * The Action will have the Build Category.
     *
     * @stability stable
     */
    BUILD = 0,
    /**
     * The Action will have the Test Category.
     *
     * @stability stable
     */
    TEST = 1
}
/**
 * Construction properties of {@link JenkinsAction}.
 *
 * @stability stable
 */
export interface JenkinsActionProps extends codepipeline.CommonActionProps {
    /**
     * The source to use as input for this build.
     *
     * @stability stable
     */
    readonly inputs?: codepipeline.Artifact[];
    /**
     * @stability stable
     */
    readonly outputs?: codepipeline.Artifact[];
    /**
     * The Jenkins Provider for this Action.
     *
     * @stability stable
     */
    readonly jenkinsProvider: IJenkinsProvider;
    /**
     * The name of the project (sometimes also called job, or task) on your Jenkins installation that will be invoked by this Action.
     *
     * @stability stable
     * @example
     *
     * 'MyJob'
     */
    readonly projectName: string;
    /**
     * The type of the Action - Build, or Test.
     *
     * @stability stable
     */
    readonly type: JenkinsActionType;
}
/**
 * Jenkins build CodePipeline Action.
 *
 * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-four-stage-pipeline.html
 * @stability stable
 */
export declare class JenkinsAction extends Action {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: JenkinsActionProps);
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     *
     * @stability stable
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, _options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
