"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WindowsBastion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk_ec2_key_pair_1 = require("cdk-ec2-key-pair");
const security_tag_1 = require("./security-tag");
class WindowsBastion extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = (props === null || props === void 0 ? void 0 : props.securityTag) ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        const key = (props === null || props === void 0 ? void 0 : props.createKeyPair) ? new cdk_ec2_key_pair_1.KeyPair(this, 'KeyPair', {
            name: `${aws_cdk_lib_1.Stack.of(this).stackName}-${id}-windows-bastion-key`,
            storePublicKey: false,
        })
            : undefined;
        if (key)
            aws_cdk_lib_1.Tags.of(key).add(securityTag.key, securityTag.value);
        this.securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'BastionSecurityGroup', {
            vpc: props.vpc,
            allowAllOutbound: true,
        });
        if (props.machineImage &&
            props.machineImage.getImage(this).osType !=
                aws_cdk_lib_1.aws_ec2.OperatingSystemType.WINDOWS)
            throw 'machineImage is not Windows based';
        const machineImage = props.machineImage
            ? props.machineImage
            : aws_cdk_lib_1.aws_ec2.MachineImage.latestWindows(aws_cdk_lib_1.aws_ec2.WindowsVersion.WINDOWS_SERVER_2022_ENGLISH_FULL_BASE);
        const instanceType = props.instanceType
            ? props.instanceType
            : aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.T3A, aws_cdk_lib_1.aws_ec2.InstanceSize.LARGE);
        const instanceProps = {
            ...props,
            propagateTagsToVolumeOnCreation: true,
            userDataCausesReplacement: true,
            keyName: key === null || key === void 0 ? void 0 : key.keyPairName,
            machineImage,
            instanceType,
        };
        const bastionInstance = new aws_cdk_lib_1.aws_ec2.Instance(this, 'BastionInstance', instanceProps);
        if (props.windowsPackages) {
            const packageUserData = [
                'Write-Output "Waiting before installing packages incase another installer is already running"',
                'Start-Sleep -Seconds 150',
                // Unfortunately Windows Server 2022 doesn't support WinGet yet ...
                // https://github.com/microsoft/winget-cli/issues/1929
                'iwr -UseBasicParsing https://github.com/jedieaston/winget-build/raw/main/Install.ps1 | iex',
                ...props.windowsPackages.map((p) => {
                    return `wingetdev install --silent --accept-source-agreements --accept-package-agreements ${p}`;
                }),
                'wingetdev upgrade --all --silent --accept-source-agreements --accept-package-agreements',
            ].join('\n');
            bastionInstance.addUserData(packageUserData);
        }
        aws_cdk_lib_1.Tags.of(bastionInstance.instance).add(securityTag.key, securityTag.value);
        bastionInstance.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        this.instanceId = bastionInstance.instanceId;
        this.instanceAvailabilityZone = bastionInstance.instanceAvailabilityZone;
        this.instancePrivateDnsName = bastionInstance.instancePrivateDnsName;
        this.instancePrivateIp = bastionInstance.instancePrivateIp;
        this.grantPrincipal = bastionInstance.grantPrincipal;
        this.instancePublicDnsName = bastionInstance.instancePublicDnsName;
        this.instancePublicIp = bastionInstance.instancePublicIp;
        this.connections = bastionInstance.connections;
        this.role = bastionInstance.role;
    }
}
exports.WindowsBastion = WindowsBastion;
_a = JSII_RTTI_SYMBOL_1;
WindowsBastion[_a] = { fqn: "pwed-cdk.pwed_bastion.WindowsBastion", version: "0.0.49" };
//# sourceMappingURL=data:application/json;base64,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