"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ttl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Ttl extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const ttl = props.ttl;
        const pollInterval = props.pollInterval
            ? props.pollInterval
            : aws_cdk_lib_1.Duration.hours(1);
        const ttlLambda = new aws_cdk_lib_1.aws_lambda.Function(this, 'TtlFunction', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            code: aws_cdk_lib_1.aws_lambda.Code.fromInline(`#!/bin/env python
import boto3
import os
import time
import logging

log = logging.Logger("logger")
log.setLevel("INFO")

def handler(event, context):
    print(event)

    stack_name = os.environ['STACK_NAME']
    ttl = int(os.environ['TTL'])
    cfn = boto3.client('cloudformation')

    print(
        f"""
        StackName: {stack_name}
        TTL:       {ttl}
        """
    )

    stack = cfn.describe_stacks(StackName=stack_name)
    creation_time = stack['Stacks'][0]['CreationTime']
    creation_time_epoch = int(time.mktime(creation_time.timetuple()))

    now = time.time()
    delta = now - creation_time_epoch
    print(
        f"""
        Now:           {now}
        Creation Time: {creation_time}
        Delta:         {delta}
        """
    )
    if delta > ttl:
        print(f"deleting stack: {stack_name}")
        cfn.delete_stack(StackName=stack_name)
        return

    print(f"not deleting stack yet, {delta} seconds remaining")
    return`),
            handler: 'ttl.handler',
            environment: {
                TTL: ttl.toSeconds().toString(),
                STACK_NAME: aws_cdk_lib_1.Fn.ref('AWS:AccountId'),
            },
            role: new aws_cdk_lib_1.aws_iam.Role(this, 'TtlRole', {
                assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
                managedPolicies: [
                    aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
                ],
            }),
        });
        new aws_cdk_lib_1.aws_events.Rule(this, 'IntercalSchedule', {
            schedule: aws_cdk_lib_1.aws_events.Schedule.rate(pollInterval),
            targets: [new aws_cdk_lib_1.aws_events_targets.LambdaFunction(ttlLambda)],
        });
    }
}
exports.Ttl = Ttl;
_a = JSII_RTTI_SYMBOL_1;
Ttl[_a] = { fqn: "pwed-cdk.pwed_ttl.Ttl", version: "0.0.49" };
//# sourceMappingURL=data:application/json;base64,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