import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [comprehend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehend.html).
 *
 * @experimental
 */
export declare class Comprehend extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to detect the language or languages present in the list of text documents.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectDominantLanguage.html
     *
     * @experimental
     */
    toBatchDetectDominantLanguage(): this;
    /**
     * (experimental) Grants permission to detect the named entities ("People", "Places", "Locations", etc) within the given list of text documents.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectEntities.html
     *
     * @experimental
     */
    toBatchDetectEntities(): this;
    /**
     * (experimental) Grants permission to detect the phrases in the list of text documents that are most indicative of the content.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectKeyPhrases.html
     *
     * @experimental
     */
    toBatchDetectKeyPhrases(): this;
    /**
     * (experimental) Grants permission to detect the sentiment of a text in the list of documents (Positive, Negative, Neutral, or Mixed).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectSentiment.html
     *
     * @experimental
     */
    toBatchDetectSentiment(): this;
    /**
     * (experimental) Grants permission to detect syntactic information (like Part of Speech, Tokens) in a list of text documents.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_BatchDetectSyntax.html
     *
     * @experimental
     */
    toBatchDetectSyntax(): this;
    /**
     * (experimental) Grants permission to create a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ClassifyDocument.html
     *
     * @experimental
     */
    toClassifyDocument(): this;
    /**
     * (experimental) Grants permission to classify the personally identifiable information within given documents at realtime.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ContainsPiiEntities.html
     *
     * @experimental
     */
    toContainsPiiEntities(): this;
    /**
     * (experimental) Grants permission to create a new document classifier that you can use to categorize documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifModelKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateDocumentClassifier.html
     *
     * @experimental
     */
    toCreateDocumentClassifier(): this;
    /**
     * (experimental) Grants permission to create a model-specific endpoint for synchronous inference for a previously trained custom model.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateEndpoint.html
     *
     * @experimental
     */
    toCreateEndpoint(): this;
    /**
     * (experimental) Grants permission to create an entity recognizer using submitted files.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifModelKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_CreateEntityRecognizer.html
     *
     * @experimental
     */
    toCreateEntityRecognizer(): this;
    /**
     * (experimental) Grants permission to delete a previously created document classifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteDocumentClassifier.html
     *
     * @experimental
     */
    toDeleteDocumentClassifier(): this;
    /**
     * (experimental) Grants permission to delete a model-specific endpoint for a previously-trained custom model.
     *
     * All endpoints must be deleted in order for the model to be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteEndpoint.html
     *
     * @experimental
     */
    toDeleteEndpoint(): this;
    /**
     * (experimental) Grants permission to delete a submitted entity recognizer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DeleteEntityRecognizer.html
     *
     * @experimental
     */
    toDeleteEntityRecognizer(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a document classification job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDocumentClassificationJob.html
     *
     * @experimental
     */
    toDescribeDocumentClassificationJob(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a document classifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDocumentClassifier.html
     *
     * @experimental
     */
    toDescribeDocumentClassifier(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a dominant language detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeDominantLanguageDetectionJob.html
     *
     * @experimental
     */
    toDescribeDominantLanguageDetectionJob(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a specific endpoint.
     *
     * Use this operation to get the status of an endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEndpoint.html
     *
     * @experimental
     */
    toDescribeEndpoint(): this;
    /**
     * (experimental) Grants permission to get the properties associated with an entities detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEntitiesDetectionJob.html
     *
     * @experimental
     */
    toDescribeEntitiesDetectionJob(): this;
    /**
     * (experimental) Grants permission to provide details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEntityRecognizer.html
     *
     * @experimental
     */
    toDescribeEntityRecognizer(): this;
    /**
     * (experimental) Grants permission to get the properties associated with an Events detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeEventsDetectionJob.html
     *
     * @experimental
     */
    toDescribeEventsDetectionJob(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a key phrases detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeKeyPhrasesDetectionJob.html
     *
     * @experimental
     */
    toDescribeKeyPhrasesDetectionJob(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a PII entities detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribePiiEntitiesDetectionJob.html
     *
     * @experimental
     */
    toDescribePiiEntitiesDetectionJob(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a sentiment detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeSentimentDetectionJob.html
     *
     * @experimental
     */
    toDescribeSentimentDetectionJob(): this;
    /**
     * (experimental) Grants permission to get the properties associated with a topic detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DescribeTopicsDetectionJob.html
     *
     * @experimental
     */
    toDescribeTopicsDetectionJob(): this;
    /**
     * (experimental) Grants permission to detect the language or languages present in the text.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html
     *
     * @experimental
     */
    toDetectDominantLanguage(): this;
    /**
     * (experimental) Grants permission to detect the named entities ("People", "Places", "Locations", etc) within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectEntities.html
     *
     * @experimental
     */
    toDetectEntities(): this;
    /**
     * (experimental) Grants permission to detect the phrases in the text that are most indicative of the content.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectKeyPhrases.html
     *
     * @experimental
     */
    toDetectKeyPhrases(): this;
    /**
     * (experimental) Grants permission to detect the personally identifiable information entities ("Name", "SSN", "PIN", etc) within the given text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectPiiEntities.html
     *
     * @experimental
     */
    toDetectPiiEntities(): this;
    /**
     * (experimental) Grants permission to detect the sentiment of a text in a document (Positive, Negative, Neutral, or Mixed).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectSentiment.html
     *
     * @experimental
     */
    toDetectSentiment(): this;
    /**
     * (experimental) Grants permission to detect syntactic information (like Part of Speech, Tokens) in a text document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectSyntax.html
     *
     * @experimental
     */
    toDetectSyntax(): this;
    /**
     * (experimental) Grants permission to get a list of the document classification jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassificationJobs.html
     *
     * @experimental
     */
    toListDocumentClassificationJobs(): this;
    /**
     * (experimental) Grants permission to get a list of summaries of the document classifiers that you have created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassifierSummaries.html
     *
     * @experimental
     */
    toListDocumentClassifierSummaries(): this;
    /**
     * (experimental) Grants permission to get a list of the document classifiers that you have created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDocumentClassifiers.html
     *
     * @experimental
     */
    toListDocumentClassifiers(): this;
    /**
     * (experimental) Grants permission to get a list of the dominant language detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListDominantLanguageDetectionJobs.html
     *
     * @experimental
     */
    toListDominantLanguageDetectionJobs(): this;
    /**
     * (experimental) Grants permission to get a list of all existing endpoints that you've created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEndpoints.html
     *
     * @experimental
     */
    toListEndpoints(): this;
    /**
     * (experimental) Grants permission to get a list of the entity detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntitiesDetectionJobs.html
     *
     * @experimental
     */
    toListEntitiesDetectionJobs(): this;
    /**
     * (experimental) Grants permission to get a list of summaries for the entity recognizers that you have created.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntityRecognizerSummaries.html
     *
     * @experimental
     */
    toListEntityRecognizerSummaries(): this;
    /**
     * (experimental) Grants permission to get a list of the properties of all entity recognizers that you created, including recognizers currently in training.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEntityRecognizers.html
     *
     * @experimental
     */
    toListEntityRecognizers(): this;
    /**
     * (experimental) Grants permission to get a list of Events detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListEventsDetectionJobs.html
     *
     * @experimental
     */
    toListEventsDetectionJobs(): this;
    /**
     * (experimental) Grants permission to get a list of key phrase detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListKeyPhrasesDetectionJobs.html
     *
     * @experimental
     */
    toListKeyPhrasesDetectionJobs(): this;
    /**
     * (experimental) Grants permission to get a list of PII entities detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListPiiEntitiesDetectionJobs.html
     *
     * @experimental
     */
    toListPiiEntitiesDetectionJobs(): this;
    /**
     * (experimental) Grants permission to get a list of sentiment detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListSentimentDetectionJobs.html
     *
     * @experimental
     */
    toListSentimentDetectionJobs(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to get a list of the topic detection jobs that you have submitted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_ListTopicsDetectionJobs.html
     *
     * @experimental
     */
    toListTopicsDetectionJobs(): this;
    /**
     * (experimental) Grants permission to start an asynchronous document classification job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartDocumentClassificationJob.html
     *
     * @experimental
     */
    toStartDocumentClassificationJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous dominant language detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartDominantLanguageDetectionJob.html
     *
     * @experimental
     */
    toStartDominantLanguageDetectionJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous entity detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStartEntitiesDetectionJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous Events detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifOutputKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartEventsDetectionJob.html
     *
     * @experimental
     */
    toStartEventsDetectionJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous key phrase detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartKeyPhrasesDetectionJob.html
     *
     * @experimental
     */
    toStartKeyPhrasesDetectionJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous PII entities detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifOutputKmsKey()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartPiiEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStartPiiEntitiesDetectionJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous sentiment detection job for a collection of documents.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartSentimentDetectionJob.html
     *
     * @experimental
     */
    toStartSentimentDetectionJob(): this;
    /**
     * (experimental) Grants permission to start an asynchronous job to detect the most common topics in the collection of documents and the phrases associated with each topic.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVolumeKmsKey()
     * - .ifOutputKmsKey()
     * - .ifVpcSecurityGroupIds()
     * - .ifVpcSubnets()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StartTopicsDetectionJob.html
     *
     * @experimental
     */
    toStartTopicsDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop a dominant language detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopDominantLanguageDetectionJob.html
     *
     * @experimental
     */
    toStopDominantLanguageDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop an entity detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStopEntitiesDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop an Events detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopEventsDetectionJob.html
     *
     * @experimental
     */
    toStopEventsDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop a key phrase detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopKeyPhrasesDetectionJob.html
     *
     * @experimental
     */
    toStopKeyPhrasesDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop a PII entities detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopPiiEntitiesDetectionJob.html
     *
     * @experimental
     */
    toStopPiiEntitiesDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop a sentiment detection job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopSentimentDetectionJob.html
     *
     * @experimental
     */
    toStopSentimentDetectionJob(): this;
    /**
     * (experimental) Grants permission to stop a previously created document classifier training job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopTrainingDocumentClassifier.html
     *
     * @experimental
     */
    toStopTrainingDocumentClassifier(): this;
    /**
     * (experimental) Grants permission to stop a previously created entity recognizer training job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_StopTrainingEntityRecognizer.html
     *
     * @experimental
     */
    toStopTrainingEntityRecognizer(): this;
    /**
     * (experimental) Grants permission to tag a resource with given key value pairs.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource with given key.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update information about the specified endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_UpdateEndpoint.html
     *
     * @experimental
     */
    toUpdateEndpoint(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type document-classifier to the statement.
     *
     * @param documentClassifierName - Identifier for the documentClassifierName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDocumentClassifier(documentClassifierName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type document-classifier-endpoint to the statement.
     *
     * @param documentClassifierEndpointName - Identifier for the documentClassifierEndpointName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDocumentClassifierEndpoint(documentClassifierEndpointName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type entity-recognizer to the statement.
     *
     * @param entityRecognizerName - Identifier for the entityRecognizerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntityRecognizer(entityRecognizerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type entity-recognizer-endpoint to the statement.
     *
     * @param entityRecognizerEndpointName - Identifier for the entityRecognizerEndpointName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntityRecognizerEndpoint(entityRecognizerEndpointName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dominant-language-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDominantLanguageDetectionJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type entities-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEntitiesDetectionJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type pii-entities-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPiiEntitiesDetectionJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type events-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEventsDetectionJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type key-phrases-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onKeyPhrasesDetectionJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type sentiment-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSentimentDetectionJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type topics-detection-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTopicsDetectionJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type document-classification-job to the statement.
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDocumentClassificationJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the model KMS key associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifModelKmsKey(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the output KMS key associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartEventsDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartPiiEntitiesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifOutputKmsKey(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the volume KMS key associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifVolumeKmsKey(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the list of all VPC security group ids associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpcSecurityGroupIds(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the list of all VPC subnets associated with the resource in the request.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncomprehend.html#amazoncomprehend-policy-keys
     *
     * Applies to actions:
     * - .toCreateDocumentClassifier()
     * - .toCreateEntityRecognizer()
     * - .toStartDocumentClassificationJob()
     * - .toStartDominantLanguageDetectionJob()
     * - .toStartEntitiesDetectionJob()
     * - .toStartKeyPhrasesDetectionJob()
     * - .toStartSentimentDetectionJob()
     * - .toStartTopicsDetectionJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpcSubnets(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [comprehend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehend.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
