import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [elemental-activations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalappliancesandsoftwareactivationservice.html).
 *
 * @experimental
 */
export declare class ElementalActivations extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to complete the process of registering customer account for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toCompleteAccountRegistration(): this;
    /**
     * (experimental) Grants permission to complete the process of uploading a Software file for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toCompleteFileUpload(): this;
    /**
     * (experimental) Grants permission to download the Software files for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toDownloadSoftware(): this;
    /**
     * (experimental) Grants permission to generate Software Licenses for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toGenerateLicenses(): this;
    /**
     * (experimental) Grants permission to describe an activation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toGetActivation(): this;
    /**
     * (experimental) Grants permission to list tags for an AWS Elemental Activations resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to start the process of registering customer account for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toStartAccountRegistration(): this;
    /**
     * (experimental) Grants permission to start the process of uploading a Software file for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toStartFileUpload(): this;
    /**
     * (experimental) Grants permission to add a tag for an AWS Elemental Activations resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove a tag from an AWS Elemental Activations resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type activation to the statement.
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActivation(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [elemental-activations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalappliancesandsoftwareactivationservice.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
