import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [health](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awshealthapisandnotifications.html).
 *
 * @experimental
 */
export declare class Health extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Gets a list of accounts that have been affected by the specified events in organization.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:ListAccounts
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedAccountsForOrganization.html
     *
     * @experimental
     */
    toDescribeAffectedAccountsForOrganization(): this;
    /**
     * (experimental) Gets a list of entities that have been affected by the specified events.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifEventTypeCode()
     * - .ifService()
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html
     *
     * @experimental
     */
    toDescribeAffectedEntities(): this;
    /**
     * (experimental) Gets a list of entities that have been affected by the specified events and accounts in organization.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:ListAccounts
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html
     *
     * @experimental
     */
    toDescribeAffectedEntitiesForOrganization(): this;
    /**
     * (experimental) Returns the number of entities that are affected by each of the specified events.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEntityAggregates.html
     *
     * @experimental
     */
    toDescribeEntityAggregates(): this;
    /**
     * (experimental) Returns the number of events of each event type (issue, scheduled change, and account notification).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventAggregates.html
     *
     * @experimental
     */
    toDescribeEventAggregates(): this;
    /**
     * (experimental) Returns detailed information about one or more specified events.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifEventTypeCode()
     * - .ifService()
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html
     *
     * @experimental
     */
    toDescribeEventDetails(): this;
    /**
     * (experimental) Returns detailed information about one or more specified events for provided accounts in organization.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:ListAccounts
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html
     *
     * @experimental
     */
    toDescribeEventDetailsForOrganization(): this;
    /**
     * (experimental) Returns the event types that meet the specified filter criteria.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventTypes.html
     *
     * @experimental
     */
    toDescribeEventTypes(): this;
    /**
     * (experimental) Returns information about events that meet the specified filter criteria.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html
     *
     * @experimental
     */
    toDescribeEvents(): this;
    /**
     * (experimental) Returns information about events that meet the specified filter criteria in organization.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:ListAccounts
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventsForOrganization.html
     *
     * @experimental
     */
    toDescribeEventsForOrganization(): this;
    /**
     * (experimental) Returns the status of enabling or disabling the Organizational View feature.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:ListAccounts
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeHealthServiceStatusForOrganization.html
     *
     * @experimental
     */
    toDescribeHealthServiceStatusForOrganization(): this;
    /**
     * (experimental) Disables the Organizational View feature.
     *
     * Access Level: Permissions management
     *
     * Dependent actions:
     * - organizations:DisableAWSServiceAccess
     * - organizations:ListAccounts
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_DisableHealthServiceAccessForOrganization.html
     *
     * @experimental
     */
    toDisableHealthServiceAccessForOrganization(): this;
    /**
     * (experimental) Enables the Organizational View feature.
     *
     * Access Level: Permissions management
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:EnableAWSServiceAccess
     * - organizations:ListAccounts
     *
     * https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html
     *
     * @experimental
     */
    toEnableHealthServiceAccessForOrganization(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type event to the statement.
     *
     * https://docs.aws.amazon.com/health/latest/ug/supported-operations.html
     *
     * @param service - Identifier for the service.
     * @param eventTypeCode - Identifier for the eventTypeCode.
     * @param eventTypePlusId - Identifier for the eventTypePlusId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEvent(service: string, eventTypeCode: string, eventTypePlusId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) The type of event.
     *
     * https://docs.aws.amazon.com/health/latest/ug/controlling-access.html
     *
     * Applies to actions:
     * - .toDescribeAffectedEntities()
     * - .toDescribeEventDetails()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifEventTypeCode(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The service of the event.
     *
     * https://docs.aws.amazon.com/health/latest/ug/controlling-access.html
     *
     * Applies to actions:
     * - .toDescribeAffectedEntities()
     * - .toDescribeEventDetails()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifService(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [health](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awshealthapisandnotifications.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
