import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [lookoutmetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutformetrics.html).
 *
 * @experimental
 */
export declare class Lookoutmetrics extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to activate an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ActivateAnomalyDetector.html
     *
     * @experimental
     */
    toActivateAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to run a backtest with an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_BackTestAnomalyDetector.html
     *
     * @experimental
     */
    toBackTestAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to create an alert for an anomaly detector.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateAlert.html
     *
     * @experimental
     */
    toCreateAlert(): this;
    /**
     * (experimental) Grants permission to create an anomaly detector.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateAnomalyDetector.html
     *
     * @experimental
     */
    toCreateAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to create a dataset.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateMetricSet.html
     *
     * @experimental
     */
    toCreateMetricSet(): this;
    /**
     * (experimental) Grants permission to delete an alert.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DeleteAlert.html
     *
     * @experimental
     */
    toDeleteAlert(): this;
    /**
     * (experimental) Grants permission to delete an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DeleteAnomalyDetector.html
     *
     * @experimental
     */
    toDeleteAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to get details about an alert.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAlert.html
     *
     * @experimental
     */
    toDescribeAlert(): this;
    /**
     * (experimental) Grants permission to get information about an anomaly detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAnomalyDetectionExecutions.html
     *
     * @experimental
     */
    toDescribeAnomalyDetectionExecutions(): this;
    /**
     * (experimental) Grants permission to get details about an anomaly detector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAnomalyDetector.html
     *
     * @experimental
     */
    toDescribeAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to get details about a dataset.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeMetricSet.html
     *
     * @experimental
     */
    toDescribeMetricSet(): this;
    /**
     * (experimental) Grants permission to get details about a group of affected metrics.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetAnomalyGroup.html
     *
     * @experimental
     */
    toGetAnomalyGroup(): this;
    /**
     * (experimental) Grants permission to get data quality metrics for an anomaly detector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetDataQualityMetrics.html
     *
     * @experimental
     */
    toGetDataQualityMetrics(): this;
    /**
     * (experimental) Grants permission to get feedback on affected metrics for an anomaly group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetFeedback.html
     *
     * @experimental
     */
    toGetFeedback(): this;
    /**
     * (experimental) Grants permission to get a selection of sample records from an Amazon S3 datasource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetSampleData.html
     *
     * @experimental
     */
    toGetSampleData(): this;
    /**
     * (experimental) Grants permission to get a list of alerts for a detector.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAlerts.html
     *
     * @experimental
     */
    toListAlerts(): this;
    /**
     * (experimental) Grants permission to get a list of anomaly detectors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyDetectors.html
     *
     * @experimental
     */
    toListAnomalyDetectors(): this;
    /**
     * (experimental) Grants permission to get a list of anomaly groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyGroupSummaries.html
     *
     * @experimental
     */
    toListAnomalyGroupSummaries(): this;
    /**
     * (experimental) Grants permission to get a list of affected metrics for a measure in an anomaly group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyGroupTimeSeries.html
     *
     * @experimental
     */
    toListAnomalyGroupTimeSeries(): this;
    /**
     * (experimental) Grants permission to get a list of datasets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListMetricSets.html
     *
     * @experimental
     */
    toListMetricSets(): this;
    /**
     * (experimental) Grants permission to get a list of tags for a detector, dataset, or alert.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to add feedback for an affected metric in an anomaly group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_PutFeedback.html
     *
     * @experimental
     */
    toPutFeedback(): this;
    /**
     * (experimental) Grants permission to add tags to a detector, dataset, or alert.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a detector, dataset, or alert.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UpdateAnomalyDetector.html
     *
     * @experimental
     */
    toUpdateAnomalyDetector(): this;
    /**
     * (experimental) Grants permission to update a dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UpdateMetricSet.html
     *
     * @experimental
     */
    toUpdateMetricSet(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type AnomalyDetector to the statement.
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_AnomalyDetectorSummary.html
     *
     * @param anomalyDetectorName - Identifier for the anomalyDetectorName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAnomalyDetector(anomalyDetectorName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type MetricSet to the statement.
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_MetricSetSummary.html
     *
     * @param anomalyDetectorName - Identifier for the anomalyDetectorName.
     * @param metricSetName - Identifier for the metricSetName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMetricSet(anomalyDetectorName: string, metricSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Alert to the statement.
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_AlertSummary.html
     *
     * @param alertName - Identifier for the alertName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAlert(alertName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [lookoutmetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutformetrics.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
