import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [pricing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html).
 *
 * @experimental
 */
export declare class Pricing extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Returns the service details for all (paginated) services (if serviceCode is not set) or service detail for a particular service (if given serviceCode).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_DescribeServices.html
     *
     * @experimental
     */
    toDescribeServices(): this;
    /**
     * (experimental) Returns all (paginated) possible values for a given attribute.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetAttributeValues.html
     *
     * @experimental
     */
    toGetAttributeValues(): this;
    /**
     * (experimental) Returns all matching products with given search criteria.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetProducts.html
     *
     * @experimental
     */
    toGetProducts(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [pricing](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspricelist.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
