"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithCDKPrincipal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// @ts-ignore only available after swapping 1-base
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _6_principals_1 = require("./6-principals");
/**
 * (experimental) Adds CDK specific "principal" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithCDKPrincipal extends _6_principals_1.PolicyStatementWithPrincipal {
    constructor() {
        super(...arguments);
        /**
         * @experimental
         */
        this.cdkPrincipals = [];
        this.cdkPrincipalsApplied = false;
    }
    /**
     * (experimental) Adds any number of CDK principals to the statement.
     *
     * @param principals Principals to add to the statement.
     * @experimental
     */
    forCdkPrincipal(...principals) {
        this.skipAutoResource = true;
        this.cdkPrincipals.push(...principals);
        return this;
    }
    /**
     * @experimental
     */
    cdkApplyPrincipals() {
        if (!this.cdkPrincipalsApplied) {
            const mode = this.useNotPrincipals ? 'addNotPrincipals' : 'addPrincipals';
            // @ts-ignore only available after swapping 1-base
            this[mode](...this.cdkPrincipals);
            if (this.hasPrincipals()) {
                Object.keys(this.principals).forEach((prefix) => {
                    switch (prefix) {
                        case _6_principals_1.PrincipalType.AWS:
                            this.principals[prefix].forEach((arn) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.ArnPrincipal(arn));
                            });
                            break;
                        case _6_principals_1.PrincipalType.CANONICAL_USER:
                            this.principals[prefix].forEach((userId) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.CanonicalUserPrincipal(userId));
                            });
                            break;
                        case _6_principals_1.PrincipalType.FEDERATED:
                            this.principals[prefix].forEach((provider) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.FederatedPrincipal(provider, {}));
                            });
                            break;
                        case _6_principals_1.PrincipalType.SERVICE:
                            this.principals[prefix].forEach((service) => {
                                // @ts-ignore only available after swapping 1-base
                                this[mode](new aws_cdk_lib_1.aws_iam.ServicePrincipal(service));
                            });
                            break;
                        default:
                            throw Error(`Unhandled principal type: ${prefix}`);
                    }
                });
            }
            this.cdkPrincipalsApplied = true;
        }
    }
}
exports.PolicyStatementWithCDKPrincipal = PolicyStatementWithCDKPrincipal;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithCDKPrincipal[_a] = { fqn: "cdk-iam-floyd.PolicyStatementWithCDKPrincipal", version: "0.300.0" };
//# sourceMappingURL=data:application/json;base64,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