one_to_one_map = {
    "ID": ("Union[str, int]", "0"),
    "String": ("str", "''"),
    "Int": ("int", "0"),
    "Float": ("float", "0.0"),
    "Date": ("date", "date.today()"),
    "Time": ("time", "datetime.now().time()"),
    "DateTime": ("datetime", "datetime.now()"),
    "Boolean": ("bool", "False"),
    "map": ("dict", "{}"),
    "Json": ("dict", "{}"),
    "Jsonb": ("dict", "{}"),
    "Text": ("str", "''"),
    "Enum": ("str", "''")
}


def default_map(var_type, variable):
    """This function determines the 'python values'

    Args:
        var_type (str): Attribut type
        variable (str): Default value

    Returns:
        tuple: returns a tuple with the class data
    """
    if var_type == 'Int':
        return ("int", int(variable))
    elif var_type == 'Float':
        return ("float", float(variable))
    elif var_type == 'Date':
        return ('date', f'get_datetime_object({variable}, "{var_type}")')
    elif var_type == 'Time':
        return ('time', f'get_datetime_object({variable}, "{var_type}")')
    elif var_type == 'DateTime':
        return ('datetime', f'get_datetime_object({variable}, "{var_type}")')
    elif var_type == "Boolean":
        return ("bool", variable.capitalize())
    elif var_type == "map":
        return ("dict", variable)
    elif var_type == "String":
        return ("str", variable)
    else:  # Enum
        return (var_type, variable)


imports = """
from __future__ import annotations
from typing import List, Union
from datetime import datetime, date, time
from gstorm.GraphQLType import GraphQLType
from gstorm.helpers.typing_helpers import convert_to, list_convert_to, gql_repr, gql_list_repr
from gstorm.helpers.date_helpers import iso8601_to_local_date, get_datetime_object
import attr
from enum import Enum
"""

example = {'Author': {'fields': [{'has_one': False,
                                  'name': 'name',
                                  'type': {'kind': 'SCALAR', 'name': 'String'},
                                  'unique': True},
                                 {'has_one': False,
                                  'name': 'lastName',
                                  'type': {'kind': 'SCALAR', 'name': 'String'},
                                  'unique': True},
                                 {'has_one': False,
                                  'name': 'finishTurn',
                                  'type': {'kind': 'SCALAR', 'name': 'Time'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'dateOfBirth',
                                  'type': {'kind': 'SCALAR', 'name': 'Date'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'active',
                                  'type': {'kind': 'SCALAR', 'name': 'Boolean'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'blogPosts',
                                  'type': {'kind': 'LIST', 'name': 'BlogPost'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'comments',
                                  'type': {'kind': 'LIST', 'name': 'Comment'},
                                  'unique': False},
                                 {'has_one': True,
                                  'name': 'avatar',
                                  'type': {'kind': 'OBJECT', 'name': 'Avatar'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'categories',
                                  'type': {'kind': 'LIST', 'name': 'Category'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'session',
                                  'type': {'kind': 'SCALAR', 'name': 'Float'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'email',
                                  'type': {'kind': 'SCALAR', 'name': 'String'},
                                  'unique': False}],
                      'kind': 'TYPE',
                      'name': 'Author'},
           'Avatar': {'fields': [{'has_one': False,
                                  'name': 'imageUrl',
                                  'type': {'kind': 'SCALAR', 'name': 'String'},
                                  'unique': True},
                                 {'has_one': False,
                                  'name': 'avatarConfigurations',
                                  'type': {'kind': 'LIST', 'name': 'AvatarConfiguration'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'comments',
                                  'type': {'kind': 'LIST', 'name': 'Comment'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'owner',
                                  'type': {'kind': 'OBJECT', 'name': 'Author'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'blogPost',
                                  'type': {'kind': 'OBJECT', 'name': 'BlogPost'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'providers',
                                  'type': {'kind': 'LIST', 'name': 'Reply'},
                                  'unique': False},
                                 {'has_one': False,
                                  'name': 'consumers',
                                  'type': {'kind': 'LIST', 'name': 'Reply'},
                                  'unique': False}],
                      'kind': 'TYPE',
                      'name': 'Avatar'},
           'AvatarConfiguration': {'fields': [{'has_one': False,
                                               'name': 'guid',
                                               'type': {'kind': 'SCALAR',
                                                        'name': 'String'},
                                               'unique': True},
                                              {'has_one': False,
                                               'name': 'config',
                                               'type': {'kind': 'OBJECT',
                                                        'name': 'Avatar'},
                                               'unique': False},
                                              {'has_one': False,
                                               'name': 'version',
                                               'type': {'kind': 'SCALAR',
                                                        'name': 'String'},
                                               'unique': False}],
                                   'kind': 'TYPE',
                                   'name': 'AvatarConfiguration'},
           'BlogPost': {'fields': [{'has_one': False,
                                    'name': 'author',
                                    'type': {'kind': 'OBJECT', 'name': 'Author'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'name',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': True},
                                   {'has_one': False,
                                    'name': 'body',
                                    'type': {'kind': 'SCALAR', 'name': 'Text'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'title',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'lastName',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'dateOfPublication',
                                    'type': {'kind': 'SCALAR', 'name': 'Date'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'statusWord',
                                    'type': {'kind': 'ENUM', 'name': 'StatusWord'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'comments',
                                    'type': {'kind': 'LIST', 'name': 'Comment'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'approvedAt',
                                    'type': {'kind': 'SCALAR', 'name': 'DateTime'},
                                    'unique': False},
                                   {'has_one': True,
                                    'name': 'alias',
                                    'type': {'kind': 'OBJECT', 'name': 'Avatar'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'tag',
                                    'type': {'kind': 'ENUM', 'name': 'Tag'},
                                    'unique': False},
                                   {'has_one': True,
                                    'name': 'wordCount',
                                    'type': {'kind': 'OBJECT', 'name': 'WordCount'},
                                    'unique': False}],
                        'kind': 'TYPE',
                        'name': 'BlogPost'},
           'Category': {'fields': [{'has_one': False,
                                    'name': 'name',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': True},
                                   {'has_one': False,
                                    'name': 'description',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'createdBy',
                                    'type': {'kind': 'OBJECT', 'name': 'Author'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'editedBy',
                                    'type': {'kind': 'OBJECT', 'name': 'Author'},
                                    'unique': False}],
                        'kind': 'TYPE',
                        'name': 'Category'},
           'Comment': {'fields': [{'has_one': False,
                                   'name': 'author',
                                   'type': {'kind': 'OBJECT', 'name': 'Author'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'supremeAuthor',
                                   'type': {'kind': 'OBJECT', 'name': 'Author'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'blogPost',
                                   'type': {'kind': 'OBJECT', 'name': 'BlogPost'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'body',
                                   'type': {'kind': 'SCALAR', 'name': 'String'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'recievedAt',
                                   'type': {'kind': 'SCALAR', 'name': 'DateTime'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'reportedAt',
                                   'type': {'kind': 'SCALAR', 'name': 'DateTime'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'avatar',
                                   'type': {'kind': 'OBJECT', 'name': 'Avatar'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'styles',
                                   'type': {'kind': 'LIST', 'name': 'Style'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'finishedAt',
                                   'type': {'kind': 'SCALAR', 'name': 'Int'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'type',
                                   'type': {'kind': 'SCALAR', 'name': 'Int'},
                                   'unique': False},
                                  {'has_one': False,
                                   'name': 'tag',
                                   'type': {'kind': 'ENUM', 'name': 'Tag'},
                                   'unique': False}],
                       'kind': 'TYPE',
                       'name': 'Comment'},
           'Employee': {'fields': [{'has_one': False,
                                    'name': 'name',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'email',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': True},
                                   {'has_one': False,
                                    'name': 'department',
                                    'type': {'kind': 'SCALAR', 'name': 'String'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'employer',
                                    'type': {'kind': 'OBJECT', 'name': 'Employee'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'employees',
                                    'type': {'kind': 'LIST', 'name': 'Employee'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'boss',
                                    'type': {'kind': 'OBJECT', 'name': 'Employee'},
                                    'unique': False},
                                   {'has_one': False,
                                    'name': 'workers',
                                    'type': {'kind': 'LIST', 'name': 'Employee'},
                                    'unique': False}],
                        'kind': 'TYPE',
                        'name': 'Employee'},
           'Equipment': {'fields': [{'has_one': False,
                                     'name': 'name',
                                     'type': {'kind': 'SCALAR', 'name': 'String'},
                                     'unique': True},
                                    {'has_one': False,
                                     'name': 'description',
                                     'type': {'kind': 'SCALAR', 'name': 'Text'},
                                     'unique': False},
                                    {'has_one': False,
                                     'name': 'information',
                                     'type': {'kind': 'SCALAR', 'name': 'map'},
                                     'unique': False}],
                         'kind': 'TYPE',
                         'name': 'Equipment'},
           'OrderComment': {'fields': [{'has_one': False,
                                        'name': 'description',
                                        'type': {'kind': 'SCALAR', 'name': 'Text'},
                                        'unique': False}],
                            'kind': 'TYPE',
                            'name': 'OrderComment'},
           'Reply': {'fields': [{'has_one': False,
                                 'name': 'title',
                                 'type': {'kind': 'SCALAR', 'name': 'String'},
                                 'unique': True},
                                {'has_one': False,
                                 'name': 'provider',
                                 'type': {'kind': 'OBJECT', 'name': 'Avatar'},
                                 'unique': False},
                                {'has_one': False,
                                 'name': 'consumer',
                                 'type': {'kind': 'OBJECT', 'name': 'Avatar'},
                                 'unique': False},
                                {'has_one': False,
                                 'name': 'struct',
                                 'type': {'kind': 'SCALAR', 'name': 'map'},
                                 'unique': False}],
                     'kind': 'TYPE',
                     'name': 'Reply'},
           'StatusWord': {'enumValues': ['APPROVED', 'PENDING', 'REJECTED'],
                          'kind': 'ENUM',
                          'name': 'StatusWord'},
           'Style': {'fields': [{'has_one': False,
                                 'name': 'description',
                                 'type': {'kind': 'SCALAR', 'name': 'Text'},
                                 'unique': False},
                                {'has_one': False,
                                 'name': 'comment',
                                 'type': {'kind': 'OBJECT', 'name': 'Comment'},
                                 'unique': False}],
                     'kind': 'TYPE',
                     'name': 'Style'},
           'Tag': {'enumValues': ['QUESTION', 'DEPENDENCY', 'NEWS'],
                   'kind': 'ENUM',
                   'name': 'Tag'},
           'WordCount': {'fields': [{'has_one': False,
                                     'name': 'outputBlogPost',
                                     'type': {'kind': 'OBJECT', 'name': 'BlogPost'},
                                     'unique': False},
                                    {'has_one': False,
                                     'name': 'count',
                                     'type': {'kind': 'SCALAR', 'name': 'Int'},
                                     'unique': False}],
                         'kind': 'TYPE',
                         'name': 'WordCount'}}
